/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.matches;

import com.compomics.util.experiment.biology.Peptide;
import com.compomics.util.experiment.identification.IdentificationMatch;
import com.compomics.util.experiment.identification.SpectrumIdentificationAssumption;
import com.compomics.util.experiment.identification.amino_acid_tags.matchers.TagMatcher;
import com.compomics.util.experiment.identification.protein_inference.PeptideProteinMapping;
import com.compomics.util.experiment.identification.protein_inference.proteintree.ProteinTree;
import com.compomics.util.experiment.identification.spectrum_assumptions.PeptideAssumption;
import com.compomics.util.experiment.identification.spectrum_assumptions.TagAssumption;
import com.compomics.util.preferences.SequenceMatchingPreferences;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;

public class SpectrumMatch
extends IdentificationMatch {
    static final long serialVersionUID = 3227760855215444318L;
    private String spectrumKey;
    private HashMap<Integer, HashMap<Double, ArrayList<SpectrumIdentificationAssumption>>> assumptionsMap = null;
    private int tagAssumptionsMapKeySize = -1;
    private PeptideAssumption bestPeptideAssumption;
    private TagAssumption bestTagAsssumption;
    private Integer spectrumNumber = null;

    public SpectrumMatch() {
    }

    public SpectrumMatch(String spectrumKey, SpectrumIdentificationAssumption assumption) {
        int advocateId = assumption.getAdvocate();
        if (this.assumptionsMap == null) {
            this.assumptionsMap = new HashMap(1);
        }
        this.assumptionsMap.put(advocateId, new HashMap());
        this.assumptionsMap.get(advocateId).put(assumption.getScore(), new ArrayList());
        this.assumptionsMap.get(advocateId).get(assumption.getScore()).add(assumption);
        this.spectrumKey = spectrumKey;
    }

    public SpectrumMatch(String spectrumKey) {
        this.spectrumKey = spectrumKey;
    }

    public PeptideAssumption getBestPeptideAssumption() {
        return this.bestPeptideAssumption;
    }

    public void setBestPeptideAssumption(PeptideAssumption bestAssumption) {
        this.bestPeptideAssumption = bestAssumption;
    }

    public TagAssumption getBestTagAssumption() {
        return this.bestTagAsssumption;
    }

    public void setBestTagAssumption(TagAssumption bestTagAsssumption) {
        this.bestTagAsssumption = bestTagAsssumption;
    }

    @Override
    public String getKey() {
        return this.spectrumKey;
    }

    public HashMap<Double, ArrayList<SpectrumIdentificationAssumption>> getAllAssumptions(int advocateId) {
        if (this.assumptionsMap == null) {
            return null;
        }
        return this.assumptionsMap.get(advocateId);
    }

    public ArrayList<SpectrumIdentificationAssumption> getAllAssumptions() {
        if (this.assumptionsMap == null) {
            return null;
        }
        ArrayList<SpectrumIdentificationAssumption> result = new ArrayList<SpectrumIdentificationAssumption>();
        for (HashMap<Double, ArrayList<SpectrumIdentificationAssumption>> seMap : this.assumptionsMap.values()) {
            for (double eValue : seMap.keySet()) {
                result.addAll((Collection<SpectrumIdentificationAssumption>)seMap.get(eValue));
            }
        }
        return result;
    }

    public HashMap<Integer, HashMap<Double, ArrayList<SpectrumIdentificationAssumption>>> getAssumptionsMap() {
        return this.assumptionsMap;
    }

    public void removeAssumptions() {
        this.assumptionsMap = null;
    }

    public void addHit(int otherAdvocateId, SpectrumIdentificationAssumption otherAssumption, boolean ascendingScore) {
        double score;
        ArrayList<SpectrumIdentificationAssumption> assumptionList;
        HashMap<Double, ArrayList<SpectrumIdentificationAssumption>> advocateMap;
        if (this.assumptionsMap == null) {
            this.assumptionsMap = new HashMap(1);
        }
        if ((advocateMap = this.assumptionsMap.get(otherAdvocateId)) == null) {
            advocateMap = new HashMap(1);
            this.assumptionsMap.put(otherAdvocateId, advocateMap);
        }
        if ((assumptionList = advocateMap.get(score = otherAssumption.getScore().doubleValue())) == null) {
            assumptionList = new ArrayList(1);
            advocateMap.put(score, assumptionList);
        }
        assumptionList.add(otherAssumption);
    }

    @Override
    public IdentificationMatch.MatchType getType() {
        return IdentificationMatch.MatchType.Spectrum;
    }

    public void setKey(String newKey) {
        this.spectrumKey = newKey;
    }

    public Integer getSpectrumNumber() {
        return this.spectrumNumber;
    }

    public void setSpectrumNumber(Integer spectrumNumber) {
        this.spectrumNumber = spectrumNumber;
    }

    public void removeAssumption(SpectrumIdentificationAssumption assumption) {
        if (this.assumptionsMap != null) {
            ArrayList<Integer> seToRemove = new ArrayList<Integer>();
            for (int se : this.assumptionsMap.keySet()) {
                ArrayList<Double> eValueToRemove = new ArrayList<Double>();
                for (double eValue : this.assumptionsMap.get(se).keySet()) {
                    this.assumptionsMap.get(se).get(eValue).remove(assumption);
                    if (!this.assumptionsMap.get(se).get(eValue).isEmpty()) continue;
                    eValueToRemove.add(eValue);
                }
                for (double eValue : eValueToRemove) {
                    this.assumptionsMap.get(se).remove(eValue);
                }
                if (!this.assumptionsMap.get(se).isEmpty()) continue;
                seToRemove.add(se);
            }
            for (int se : seToRemove) {
                this.assumptionsMap.remove(se);
            }
        }
    }

    public boolean hasAssumption() {
        if (this.assumptionsMap == null) {
            return false;
        }
        for (int se : this.assumptionsMap.keySet()) {
            for (ArrayList<SpectrumIdentificationAssumption> assumptionsAtScore : this.assumptionsMap.get(se).values()) {
                if (assumptionsAtScore.isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasAssumption(int advocateId) {
        if (this.assumptionsMap == null) {
            return false;
        }
        if (this.assumptionsMap.containsKey(advocateId)) {
            for (ArrayList<SpectrumIdentificationAssumption> assumptionsAtEvalue : this.assumptionsMap.get(advocateId).values()) {
                if (assumptionsAtEvalue.isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    public SpectrumMatch getPeptidesFromTags(ProteinTree proteinTree, TagMatcher tagMatcher, SequenceMatchingPreferences sequenceMatchingPreferences, Double massTolerance, boolean scoreInAscendingOrder, boolean ascendingScore) throws IOException, InterruptedException, ClassNotFoundException, SQLException {
        SpectrumMatch spectrumMatch = new SpectrumMatch(this.spectrumKey);
        if (this.assumptionsMap == null) {
            return spectrumMatch;
        }
        for (int advocateId : this.assumptionsMap.keySet()) {
            int rank = 1;
            ArrayList<Double> scores = new ArrayList<Double>(this.assumptionsMap.get(advocateId).keySet());
            if (scoreInAscendingOrder) {
                Collections.sort(scores);
            } else {
                Collections.sort(scores, Collections.reverseOrder());
            }
            for (double score : scores) {
                ArrayList<SpectrumIdentificationAssumption> originalAssumptions = this.assumptionsMap.get(advocateId).get(score);
                for (SpectrumIdentificationAssumption assumption : originalAssumptions) {
                    if (!(assumption instanceof TagAssumption)) continue;
                    TagAssumption tagAssumption = (TagAssumption)assumption;
                    ArrayList<PeptideProteinMapping> proteinMapping = proteinTree.getProteinMapping(tagAssumption.getTag(), tagMatcher, sequenceMatchingPreferences, massTolerance);
                    for (Peptide peptide : PeptideProteinMapping.getPeptides(proteinMapping, sequenceMatchingPreferences)) {
                        PeptideAssumption peptideAssumption = new PeptideAssumption(peptide, rank, advocateId, assumption.getIdentificationCharge(), score, assumption.getIdentificationFile());
                        peptideAssumption.setRawScore(score);
                        peptideAssumption.addUrParam(tagAssumption);
                        spectrumMatch.addHit(advocateId, peptideAssumption, ascendingScore);
                    }
                }
            }
        }
        return spectrumMatch;
    }
}

