/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.protein_inference;

public enum PeptideMapperType {
    fm_index(0, "FM-Index", "Full-text index in Minute space index stored in a wavelet tree."),
    tree(1, "Tree", "Protein fasta database index in the form of a tree using a database as back-end.");

    public final int index;
    public final String name;
    public final String description;

    private PeptideMapperType(int index, String name, String description) {
        this.index = index;
        this.name = name;
        this.description = description;
    }

    public static String getCommandLineOptions() {
        StringBuilder optionsStringBuilder = new StringBuilder();
        for (PeptideMapperType matchingType : PeptideMapperType.values()) {
            if (optionsStringBuilder.length() != 0) {
                optionsStringBuilder.append(", ");
            }
            optionsStringBuilder.append(matchingType.index).append(": ").append(matchingType.description);
        }
        return optionsStringBuilder.toString();
    }

    public String toString() {
        return this.name;
    }

    public static PeptideMapperType getPeptideMapperType(int index) {
        for (PeptideMapperType mapperType : PeptideMapperType.values()) {
            if (mapperType.index != index) continue;
            return mapperType;
        }
        throw new IllegalArgumentException("No peptide mapper type found for index " + index + ".");
    }
}

