/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.ptm;

import java.util.ArrayList;

public enum PtmScore {
    AScore(0, "A-score"),
    PhosphoRS(1, "PhosphoRS"),
    None(2, "None");

    private int id;
    private String name;

    private PtmScore(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public static ArrayList<PtmScore> getImplementedPtmScores() {
        ArrayList<PtmScore> result = new ArrayList<PtmScore>();
        result.add(AScore);
        result.add(PhosphoRS);
        result.add(None);
        return result;
    }

    public static PtmScore getScore(int id) {
        for (PtmScore ptmScore : PtmScore.getImplementedPtmScores()) {
            if (ptmScore.getId() != id) continue;
            return ptmScore;
        }
        throw new IllegalArgumentException("PTM score of id " + id + " not recognized.");
    }

    public static PtmScore getScore(String name) {
        for (PtmScore ptmScore : PtmScore.getImplementedPtmScores()) {
            if (!ptmScore.getName().equals(name)) continue;
            return ptmScore;
        }
        throw new IllegalArgumentException("PTM score of name " + name + " not recognized.");
    }

    public static String getCommandLineOptions() {
        String result = "";
        for (PtmScore ptmScore : PtmScore.getImplementedPtmScores()) {
            if (!result.equals("")) {
                result = result + ", ";
            }
            result = result + ptmScore.getId() + ": " + ptmScore.getName();
        }
        return result;
    }

    public static PtmScore[] getScoresAsList() {
        ArrayList<PtmScore> tempScores = PtmScore.getImplementedPtmScores();
        PtmScore[] scores = new PtmScore[tempScores.size()];
        for (int i = 0; i < tempScores.size(); ++i) {
            scores[i] = tempScores.get(i);
        }
        return scores;
    }
}

