/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.spectrum_annotation.spectrum_annotators;

import com.compomics.util.experiment.biology.Ion;
import com.compomics.util.experiment.biology.IonFactory;
import com.compomics.util.experiment.biology.NeutralLoss;
import com.compomics.util.experiment.biology.PTM;
import com.compomics.util.experiment.biology.PTMFactory;
import com.compomics.util.experiment.biology.Peptide;
import com.compomics.util.experiment.biology.ions.PeptideFragmentIon;
import com.compomics.util.experiment.identification.matches.IonMatch;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.spectrum_annotation.AnnotationSettings;
import com.compomics.util.experiment.identification.spectrum_annotation.NeutralLossesMap;
import com.compomics.util.experiment.identification.spectrum_annotation.SpecificAnnotationSettings;
import com.compomics.util.experiment.identification.spectrum_annotation.SpectrumAnnotator;
import com.compomics.util.experiment.massspectrometry.MSnSpectrum;
import com.compomics.util.experiment.massspectrometry.Peak;
import com.compomics.util.preferences.SequenceMatchingPreferences;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.commons.math.MathException;

public class PeptideSpectrumAnnotator
extends SpectrumAnnotator {
    private Peptide peptide;

    public void setPeptide(Peptide peptide, int precursorCharge, SpecificAnnotationSettings specificAnnotationSettings) {
        this.setPeptide(peptide, null, precursorCharge, specificAnnotationSettings);
    }

    public void setPeptide(Peptide peptide, HashMap<Integer, HashMap<Integer, ArrayList<Ion>>> possibleFragmentIons, int precursorCharge, SpecificAnnotationSettings specificAnnotationSettings) {
        if (specificAnnotationSettings != null && this.specificAnnotationSettings == null || specificAnnotationSettings == null && this.specificAnnotationSettings != null || specificAnnotationSettings != null && this.specificAnnotationSettings != null && specificAnnotationSettings != this.specificAnnotationSettings || this.peptide == null || !this.peptide.getKey().equals(peptide.getKey()) || !this.peptide.sameModificationsAs(peptide) || this.precursorCharge != precursorCharge) {
            this.peptide = peptide;
            this.precursorCharge = precursorCharge;
            this.theoreticalFragmentIons = possibleFragmentIons == null ? this.fragmentFactory.getFragmentIons(peptide, specificAnnotationSettings) : possibleFragmentIons;
            if (this.massShift != 0.0 || this.massShiftNTerm != 0.0 || this.massShiftCTerm != 0.0) {
                this.updateMassShifts();
            }
        }
    }

    public ArrayList<IonMatch> matchPeak(Peptide peptide, SpecificAnnotationSettings specificAnnotationSettings, Peak peak) {
        this.setPeptide(peptide, specificAnnotationSettings.getPrecursorCharge(), specificAnnotationSettings);
        return this.matchPeak(specificAnnotationSettings, peak);
    }

    public synchronized ArrayList<IonMatch> getSpectrumAnnotation(AnnotationSettings annotationSettings, SpecificAnnotationSettings specificAnnotationSettings, MSnSpectrum spectrum, Peptide peptide) throws InterruptedException, MathException {
        return this.getSpectrumAnnotation(annotationSettings, specificAnnotationSettings, spectrum, peptide, true);
    }

    public synchronized ArrayList<IonMatch> getSpectrumAnnotation(AnnotationSettings annotationSettings, SpecificAnnotationSettings specificAnnotationSettings, MSnSpectrum spectrum, Peptide peptide, boolean useIntensityFilter) throws InterruptedException, MathException {
        return this.getSpectrumAnnotation(annotationSettings, specificAnnotationSettings, spectrum, peptide, null, useIntensityFilter);
    }

    public synchronized ArrayList<IonMatch> getSpectrumAnnotation(AnnotationSettings annotationSettings, SpecificAnnotationSettings specificAnnotationSettings, MSnSpectrum spectrum, Peptide peptide, HashMap<Integer, HashMap<Integer, ArrayList<Ion>>> possiblePeptideFragments, boolean useIntensityFilter) throws InterruptedException, MathException {
        ArrayList<IonMatch> result = new ArrayList<IonMatch>();
        this.setMassTolerance(specificAnnotationSettings.getFragmentIonAccuracy(), specificAnnotationSettings.isFragmentIonPpm(), annotationSettings.getTiesResolution());
        if (spectrum != null) {
            double intensityLimit = useIntensityFilter ? spectrum.getIntensityLimit(annotationSettings.getIntensityThresholdType(), annotationSettings.getAnnotationIntensityLimit()) : 0.0;
            this.setSpectrum(spectrum, intensityLimit);
        }
        this.setPeptide(peptide, possiblePeptideFragments, specificAnnotationSettings.getPrecursorCharge(), specificAnnotationSettings);
        ArrayList<Integer> precursorCharges = new ArrayList<Integer>();
        for (int i = 1; i <= this.precursorCharge; ++i) {
            precursorCharges.add(i);
        }
        HashMap<Ion.IonType, HashSet<Integer>> ionTypes = specificAnnotationSettings.getIonTypes();
        for (Ion.IonType ionType : ionTypes.keySet()) {
            HashMap ionMap = (HashMap)this.theoreticalFragmentIons.get(ionType.index);
            if (ionMap == null) continue;
            HashSet<Integer> subtypes = ionTypes.get((Object)ionType);
            for (int subType : subtypes) {
                ArrayList ions = (ArrayList)ionMap.get(subType);
                if (ions == null) continue;
                for (Ion ion : ions) {
                    if (!this.lossesValidated(specificAnnotationSettings.getNeutralLossesMap(), ion)) continue;
                    ArrayList<Object> ionPossibleCharges = ionType == Ion.IonType.PRECURSOR_ION ? precursorCharges : specificAnnotationSettings.getSelectedCharges();
                    for (Integer n : ionPossibleCharges) {
                        IonMatch ionMatch;
                        if (!this.chargeValidated(ion, n, this.precursorCharge) || (ionMatch = this.matchInSpectrum(ion, n)) == null) continue;
                        result.add(ionMatch);
                    }
                }
            }
        }
        return result;
    }

    public HashMap<Integer, ArrayList<IonMatch>> getCoveredAminoAcids(AnnotationSettings annotationSettings, SpecificAnnotationSettings specificAnnotationSettings, MSnSpectrum spectrum, Peptide peptide, boolean useIntensityFilter) throws InterruptedException, MathException {
        HashMap<Integer, ArrayList<IonMatch>> matchesMap = new HashMap<Integer, ArrayList<IonMatch>>();
        ArrayList<IonMatch> matches = this.getSpectrumAnnotation(annotationSettings, specificAnnotationSettings, spectrum, peptide, useIntensityFilter);
        for (IonMatch ionMatch : matches) {
            Ion ion = ionMatch.ion;
            if (ion.getType() != Ion.IonType.PEPTIDE_FRAGMENT_ION) continue;
            int number = ion.getSubType() == 0 || ion.getSubType() == 1 || ion.getSubType() == 2 ? ((PeptideFragmentIon)ion).getNumber() : peptide.getSequence().length() + 1 - ((PeptideFragmentIon)ion).getNumber();
            if (!matchesMap.containsKey(number)) {
                matchesMap.put(number, new ArrayList());
            }
            matchesMap.get(number).add(ionMatch);
        }
        return matchesMap;
    }

    public HashMap<Integer, ArrayList<Ion>> getExpectedIons(SpecificAnnotationSettings specificAnnotationSettings, Peptide peptide) {
        return this.getExpectedIons(specificAnnotationSettings, peptide, null);
    }

    public HashMap<Integer, ArrayList<Ion>> getExpectedIons(SpecificAnnotationSettings specificAnnotationSettings, Peptide peptide, HashMap<Integer, HashMap<Integer, ArrayList<Ion>>> possibleFragmentIons) {
        this.setPeptide(peptide, possibleFragmentIons, specificAnnotationSettings.getPrecursorCharge(), specificAnnotationSettings);
        return this.getExpectedIons(specificAnnotationSettings);
    }

    @Override
    public ArrayList<IonMatch> getCurrentAnnotation(MSnSpectrum spectrum, AnnotationSettings annotationSettings, SpecificAnnotationSettings specificAnnotationSettings, boolean useIntensityFilter) throws InterruptedException, MathException {
        return this.getSpectrumAnnotation(annotationSettings, specificAnnotationSettings, spectrum, this.peptide, useIntensityFilter);
    }

    public static NeutralLossesMap getDefaultLosses(Peptide peptide, SequenceMatchingPreferences sequenceMatchingSettings, SequenceMatchingPreferences ptmSequenceMatchingSettings) throws IOException, InterruptedException, ClassNotFoundException, SQLException {
        PTMFactory pTMFactory = PTMFactory.getInstance();
        NeutralLossesMap neutralLossesMap = new NeutralLossesMap();
        String sequence = peptide.getSequence();
        int aaMin = sequence.length();
        int aaMax = 0;
        for (NeutralLoss neutralLoss : IonFactory.getDefaultNeutralLosses()) {
            char[] aas = neutralLoss.aminoAcids;
            if (aas == null) continue;
            for (char aa : aas) {
                int firstIndex = sequence.indexOf(aa);
                if (firstIndex == -1) continue;
                aaMin = Math.min(firstIndex, aaMin);
                aaMax = Math.max(sequence.lastIndexOf(aa), aaMax);
            }
            if (aaMin >= sequence.length()) continue;
            neutralLossesMap.addNeutralLoss(neutralLoss, (Integer)(aaMin + 1), (Integer)(sequence.length() - aaMax));
        }
        int modMin = sequence.length();
        int modMax = 0;
        if (peptide.isModified()) {
            for (ModificationMatch modMatch : peptide.getModificationMatches()) {
                PTM ptm = pTMFactory.getPTM(modMatch.getTheoreticPtm());
                for (NeutralLoss neutralLoss : ptm.getNeutralLosses()) {
                    ArrayList<Integer> indexes = peptide.getPotentialModificationSites(ptm, sequenceMatchingSettings, ptmSequenceMatchingSettings);
                    if (!indexes.isEmpty()) {
                        Collections.sort(indexes);
                        modMin = indexes.get(0);
                        modMax = indexes.get(indexes.size() - 1);
                    }
                    neutralLossesMap.addNeutralLoss(neutralLoss, (Integer)modMin, (Integer)(sequence.length() - modMax + 1));
                }
            }
        }
        return neutralLossesMap;
    }

    public Peptide getCurrentlyLoadedPeptide() {
        return this.peptide;
    }
}

