/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.io.massspectrometry;

import com.compomics.util.experiment.io.massspectrometry.MgfIndex;
import com.compomics.util.experiment.io.massspectrometry.MgfReader;
import com.compomics.util.experiment.massspectrometry.Charge;
import com.compomics.util.experiment.massspectrometry.MSnSpectrum;
import com.compomics.util.experiment.massspectrometry.Peak;
import com.compomics.util.experiment.massspectrometry.Precursor;
import com.compomics.util.waiting.WaitingHandler;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import uk.ac.ebi.pride.tools.braf.BufferedRandomAccessFile;

public class MspReader
extends MgfReader {
    public static MSnSpectrum getSpectrum(BufferedReader br, String fileName) throws IOException {
        String line;
        HashMap<Double, Peak> spectrum = new HashMap<Double, Peak>();
        double precursorMz = 0.0;
        double precursorIntensity = 0.0;
        double rt = -1.0;
        double rt1 = -1.0;
        double rt2 = -1.0;
        ArrayList<Charge> precursorCharges = new ArrayList<Charge>();
        String scanNumber = "";
        String spectrumTitle = "";
        int numberofPeaks = 0;
        double molecularWeight = 0.0;
        boolean insideSpectrum = false;
        do {
            if ((line = br.readLine()).endsWith("\r")) {
                line = line.replace("\r", "");
            }
            if (line.startsWith("Name:")) {
                insideSpectrum = true;
                spectrumTitle = line;
                try {
                    spectrumTitle = URLDecoder.decode(spectrumTitle, "utf-8");
                    int val = Integer.parseInt(line.substring(line.indexOf(47) + 1));
                    precursorCharges.add(new Charge(0, val));
                }
                catch (UnsupportedEncodingException e) {
                    System.out.println("An exception was thrown when trying to decode the msp title '" + spectrumTitle + "'.");
                    e.printStackTrace();
                }
                continue;
            }
            if (line.startsWith("MW:")) {
                try {
                    molecularWeight = Double.parseDouble(line.substring(line.indexOf(58) + 2));
                }
                catch (Exception e) {
                    System.out.println("An exception was thrown when trying to decode the msp Molecular Weight'" + molecularWeight + "'.");
                    e.printStackTrace();
                }
                continue;
            }
            if (line.startsWith("Comment")) {
                String temp = line.substring(line.indexOf("Parent"));
                temp = temp.substring(temp.indexOf("=") + 1);
                precursorMz = Double.parseDouble(temp);
                if (!line.contains("Scan")) continue;
                scanNumber = line.substring(line.indexOf("Scan=5"), line.indexOf(""));
                continue;
            }
            if (line.startsWith("Num peaks:")) {
                String temp = line.substring(line.indexOf(58) + 2);
                try {
                    numberofPeaks = Integer.parseInt(temp);
                }
                catch (Exception e) {
                    System.out.println("An exception was thrown when trying to decode the number of peaks " + numberofPeaks + ".");
                    e.printStackTrace();
                }
                continue;
            }
            if (line.equals("") || line == null) {
                insideSpectrum = false;
                Precursor precursor = rt1 != -1.0 && rt2 != -1.0 ? new Precursor(precursorMz, precursorIntensity, precursorCharges, rt1, rt2) : new Precursor(rt, precursorMz, precursorIntensity, precursorCharges);
                MSnSpectrum msnSpectrum = new MSnSpectrum(2, precursor, spectrumTitle, spectrum, fileName);
                if (scanNumber.length() > 0) {
                    msnSpectrum.setScanNumber(scanNumber);
                }
                return msnSpectrum;
            }
            if (!insideSpectrum) continue;
            try {
                String[] values = line.split("\\s+");
                Double mz = new Double(values[0]);
                Double intensity = new Double(values[1]);
                spectrum.put(mz, new Peak(mz, intensity));
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (line != null);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList<MSnSpectrum> getSpectra(File aFile) throws FileNotFoundException, IOException, IllegalArgumentException {
        ArrayList<MSnSpectrum> spectra = new ArrayList<MSnSpectrum>();
        BufferedReader br = new BufferedReader(new FileReader(aFile));
        try {
            MSnSpectrum spectrum;
            while ((spectrum = MspReader.getSpectrum(br, aFile.getName())) != null) {
                spectra.add(spectrum);
            }
        }
        finally {
            br.close();
        }
        return spectra;
    }

    public static MgfIndex getIndexMap(File mspFile, WaitingHandler waitingHandler) throws FileNotFoundException, IOException {
        String line;
        HashMap<String, Long> indexes = new HashMap<String, Long>();
        HashMap<String, Integer> spectrumIndexes = new HashMap<String, Integer>();
        HashMap<Integer, Double> precursorMzMap = new HashMap<Integer, Double>();
        LinkedHashSet<String> spectrumTitles = new LinkedHashSet<String>();
        HashMap<String, Integer> duplicateTitles = new HashMap<String, Integer>();
        BufferedRandomAccessFile bufferedRandomAccessFile = new BufferedRandomAccessFile(mspFile, "r", 102400);
        long currentIndex = 0L;
        String title = null;
        int spectrumCounter = 0;
        double maxRT = -1.0;
        double minRT = Double.MAX_VALUE;
        double maxMz = -1.0;
        double maxIntensity = 0.0;
        int maxCharge = 0;
        int maxPeakCount = 0;
        int peakCount = 0;
        boolean peakPicked = true;
        boolean precursorChargesMissing = false;
        int numberofPeaks = 0;
        double molecularWeight = 0.0;
        if (waitingHandler != null) {
            waitingHandler.setSecondaryProgressCounterIndeterminate(false);
            waitingHandler.setMaxSecondaryProgressCounter(100);
            waitingHandler.setSecondaryProgressCounter(0);
        }
        long progressUnit = bufferedRandomAccessFile.length() / 100L;
        boolean insideSpectrum = false;
        boolean chargeTagFound = false;
        do {
            String temp;
            if ((line = bufferedRandomAccessFile.getNextLine()).endsWith("\r")) {
                line = line.replace("\r", "");
            }
            if (line.startsWith("Name")) {
                insideSpectrum = true;
                chargeTagFound = false;
                currentIndex = bufferedRandomAccessFile.getFilePointer() - (long)line.length() - 1L;
                ++spectrumCounter;
                peakCount = 0;
                if (waitingHandler != null) {
                    if (waitingHandler.isRunCanceled()) break;
                    waitingHandler.setSecondaryProgressCounter((int)(currentIndex / progressUnit));
                }
                title = line;
                try {
                    title = URLDecoder.decode(title, "utf-8");
                }
                catch (UnsupportedEncodingException e) {
                    if (waitingHandler != null) {
                        waitingHandler.appendReport("An exception was thrown when trying to decode an msp title: " + title, true, true);
                    }
                    System.out.println("An exception was thrown when trying to decode an msp title: " + title);
                    e.printStackTrace();
                }
                Integer nDuplicates = (Integer)duplicateTitles.get(title);
                if (nDuplicates != null || spectrumTitles.contains(title)) {
                    if (nDuplicates == null) {
                        nDuplicates = 0;
                        System.err.println("Warning: Spectrum title " + title + " is not unique in " + mspFile.getName() + "!");
                    }
                    nDuplicates = nDuplicates + 1;
                    duplicateTitles.put(title, nDuplicates);
                    title = title + "_" + nDuplicates;
                }
                spectrumTitles.add(title);
                indexes.put(title, currentIndex);
                spectrumIndexes.put(title, spectrumCounter - 1);
                ArrayList<Charge> precursorCharges = new ArrayList<Charge>();
                int val = Integer.parseInt(line.substring(line.indexOf(47) + 1));
                precursorCharges.add(new Charge(0, val));
                for (Charge charge : precursorCharges) {
                    if (charge.value <= maxCharge) continue;
                    maxCharge = charge.value;
                }
                chargeTagFound = true;
                continue;
            }
            if (line.startsWith("MW:")) {
                try {
                    molecularWeight = Double.parseDouble(line.substring(line.indexOf(58) + 2));
                }
                catch (Exception e) {
                    System.out.println("An exception was thrown when trying to decode the msp Molecular Weight'" + molecularWeight + "'.");
                    e.printStackTrace();
                }
                continue;
            }
            if (line.startsWith("Comment")) {
                temp = line.substring(line.indexOf("Parent"));
                double precursorMz = Double.parseDouble(temp = temp.substring(temp.indexOf("=") + 1));
                if (precursorMz > maxMz) {
                    maxMz = precursorMz;
                }
                precursorMzMap.put(spectrumCounter - 1, precursorMz);
                continue;
            }
            if (line.startsWith("Num peaks:")) {
                temp = line.substring(line.indexOf(58) + 2);
                try {
                    numberofPeaks = Integer.parseInt(temp);
                }
                catch (Exception e) {
                    System.out.println("An exception was thrown when trying to decode the number of peaks " + numberofPeaks + ".");
                    e.printStackTrace();
                }
                continue;
            }
            if (line.equals("") || line == null) {
                insideSpectrum = false;
                if (title != null && peakCount > maxPeakCount) {
                    maxPeakCount = peakCount;
                }
                title = null;
                if (chargeTagFound) continue;
                precursorChargesMissing = true;
                continue;
            }
            if (!insideSpectrum) continue;
            try {
                String[] values = line.split("\\s+");
                Double intensity = new Double(values[1]);
                if (peakPicked && intensity == 0.0) {
                    peakPicked = false;
                }
                ++peakCount;
            }
            catch (Exception values) {
                // empty catch block
            }
        } while (line != null);
        if (waitingHandler != null) {
            waitingHandler.setSecondaryProgressCounterIndeterminate(true);
        }
        bufferedRandomAccessFile.close();
        if (minRT == Double.MAX_VALUE) {
            minRT = 0.0;
        }
        ArrayList<String> spectrumTitlesAsArrayList = new ArrayList<String>();
        for (String temp : spectrumTitles) {
            spectrumTitlesAsArrayList.add(temp);
        }
        return new MgfIndex(spectrumTitlesAsArrayList, duplicateTitles, indexes, spectrumIndexes, precursorMzMap, mspFile.getName(), minRT, maxRT, maxMz, maxIntensity, maxCharge, maxPeakCount, peakPicked, precursorChargesMissing, mspFile.lastModified(), spectrumCounter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addMissingSpectrumTitles(File mspFile, WaitingHandler waitingHandler) throws FileNotFoundException, IOException, UnsupportedEncodingException {
        ArrayList<String> spectrumTitles = new ArrayList<String>();
        File tempSpectrumFile = new File(mspFile.getParentFile(), mspFile.getName() + "_temp");
        if (waitingHandler != null) {
            waitingHandler.setSecondaryProgressCounterIndeterminate(false);
            waitingHandler.setMaxSecondaryProgressCounter(100);
            waitingHandler.setSecondaryProgressCounter(0);
        }
        BufferedRandomAccessFile br = new BufferedRandomAccessFile(mspFile, "r", 102400);
        String lineBreak = System.getProperty("line.separator");
        try {
            long progressUnit = br.length() / 100L;
            FileWriter fw = new FileWriter(tempSpectrumFile);
            try {
                BufferedWriter bw = new BufferedWriter(fw);
                try {
                    String line;
                    String currentSpectrum = "";
                    String title = null;
                    int spectrumCounter = 0;
                    do {
                        if ((line = br.readLine()).startsWith("Name:")) {
                            ++spectrumCounter;
                            currentSpectrum = currentSpectrum + line + lineBreak;
                            title = line;
                            try {
                                title = URLDecoder.decode(title, "utf-8");
                            }
                            catch (UnsupportedEncodingException e) {
                                e.printStackTrace();
                                throw new UnsupportedEncodingException("An exception was thrown when trying to decode an  title: " + title);
                            }
                            spectrumTitles.add(title);
                            if (waitingHandler == null) continue;
                            if (waitingHandler.isRunCanceled()) {
                                break;
                            }
                            waitingHandler.setSecondaryProgressCounter((int)(br.getFilePointer() / progressUnit));
                            continue;
                        }
                        if (line.startsWith("") || line == null) {
                            bw.write("Name: ");
                            if (title == null) {
                                title = "Spectrum " + spectrumCounter;
                                while (spectrumTitles.contains(title)) {
                                    title = "Spectrum " + ++spectrumCounter;
                                }
                                spectrumTitles.add(title);
                                bw.write("TITLE=" + title + lineBreak);
                            }
                            bw.write(currentSpectrum);
                            bw.write("" + lineBreak);
                            currentSpectrum = "";
                            title = null;
                            continue;
                        }
                        currentSpectrum = currentSpectrum + line + lineBreak;
                    } while (line != null);
                }
                finally {
                    bw.close();
                }
            }
            finally {
                fw.close();
            }
        }
        finally {
            br.close();
        }
        if (waitingHandler != null) {
            waitingHandler.setSecondaryProgressCounterIndeterminate(true);
        }
        String orignalFilePath = mspFile.getAbsolutePath();
        boolean fileDeleted = mspFile.delete();
        if (!fileDeleted) {
            throw new IOException("Failed to delete the original spectrum file.");
        }
        boolean fileRenamed = tempSpectrumFile.renameTo(new File(orignalFilePath));
        if (!fileRenamed) {
            throw new IOException("Failed to replace the original spectrum file.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeZeroes(File File2, WaitingHandler waitingHandler) throws FileNotFoundException, IOException, UnsupportedEncodingException {
        File tempSpectrumFile = new File(File2.getParentFile(), File2.getName() + "_temp");
        if (waitingHandler != null) {
            waitingHandler.setSecondaryProgressCounterIndeterminate(false);
            waitingHandler.setMaxSecondaryProgressCounter(100);
            waitingHandler.setSecondaryProgressCounter(0);
        }
        BufferedRandomAccessFile br = new BufferedRandomAccessFile(File2, "r", 102400);
        try {
            long progressUnit = br.length() / 100L;
            FileWriter fw = new FileWriter(tempSpectrumFile);
            try {
                BufferedWriter bw = new BufferedWriter(fw);
                try {
                    String line;
                    boolean spectrum = false;
                    do {
                        if ((line = br.readLine()).startsWith("Name:")) {
                            spectrum = true;
                            if (waitingHandler != null) {
                                if (waitingHandler.isRunCanceled()) {
                                    break;
                                }
                                waitingHandler.setSecondaryProgressCounter((int)(br.getFilePointer() / progressUnit));
                            }
                        } else if (line.startsWith("") || line == null) {
                            spectrum = false;
                        }
                        boolean peak = true;
                        boolean zero = false;
                        String[] split = line.split(" ");
                        if (split.length != 2 && split.length != 3 && (split = line.split("\t")).length != 2 && split.length != 3) {
                            peak = false;
                        }
                        if (peak) {
                            try {
                                new Double(split[0]);
                            }
                            catch (Exception e) {
                                peak = false;
                            }
                            if (peak) {
                                try {
                                    Double intensity = new Double(split[1]);
                                    if (intensity == 0.0) {
                                        zero = true;
                                    }
                                }
                                catch (Exception e) {
                                    throw new IllegalArgumentException("Line not recognized:\n" + line);
                                }
                            }
                        }
                        if (spectrum && peak && zero) continue;
                        bw.write(line);
                        bw.newLine();
                    } while (line != null);
                }
                finally {
                    bw.close();
                }
            }
            finally {
                fw.close();
            }
        }
        finally {
            br.close();
        }
        if (waitingHandler != null) {
            waitingHandler.setSecondaryProgressCounterIndeterminate(true);
        }
        String orignalFilePath = File2.getAbsolutePath();
        boolean fileDeleted = File2.delete();
        if (!fileDeleted) {
            throw new IOException("Failed to delete the original spectrum file.");
        }
        boolean fileRenamed = tempSpectrumFile.renameTo(new File(orignalFilePath));
        if (!fileRenamed) {
            throw new IOException("Failed to replace the original spectrum file.");
        }
    }

    public static void renameDuplicateSpectrumTitles(File mspFile, WaitingHandler waitingHandler) throws FileNotFoundException, IOException, UnsupportedEncodingException {
        String line;
        ArrayList<String> spectrumTitles = new ArrayList<String>();
        File tempSpectrumFile = new File(mspFile.getParentFile(), mspFile.getName() + "_temp");
        FileWriter fw = new FileWriter(tempSpectrumFile);
        BufferedWriter bw = new BufferedWriter(fw);
        FileReader fr = new FileReader(mspFile);
        BufferedReader br = new BufferedReader(fr);
        String lineBreak = System.getProperty("line.separator");
        do {
            if ((line = br.readLine()).startsWith("Name:")) {
                if (waitingHandler != null && waitingHandler.isRunCanceled()) break;
                String originalTitle = line;
                try {
                    originalTitle = URLDecoder.decode(originalTitle, "utf-8");
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                    throw new UnsupportedEncodingException("An exception was thrown when trying to decode an msp title: " + originalTitle);
                }
                String tempTitle = originalTitle;
                int counter = 2;
                while (spectrumTitles.contains(tempTitle)) {
                    tempTitle = originalTitle + " (" + counter++ + ")";
                }
                spectrumTitles.add(tempTitle);
                bw.write("Name:" + tempTitle + lineBreak);
                continue;
            }
            bw.write(line + lineBreak);
        } while (line != null);
        br.close();
        fr.close();
        bw.close();
        fw.close();
        String orignalFilePath = mspFile.getAbsolutePath();
        boolean fileDeleted = mspFile.delete();
        if (!fileDeleted) {
            throw new IOException("Failed to delete the original spectrum file.");
        }
        boolean fileRenamed = tempSpectrumFile.renameTo(new File(orignalFilePath));
        if (!fileRenamed) {
            throw new IOException("Failed to replace the original spectrum file.");
        }
    }

    @Override
    public ArrayList<MgfIndex> splitFile(File mspFile, int nSpectra, WaitingHandler waitingHandler) throws FileNotFoundException, IOException {
        String fileName = mspFile.getName();
        if (fileName.toLowerCase().endsWith(".msp")) {
            String line;
            if (waitingHandler != null) {
                waitingHandler.setSecondaryProgressCounterIndeterminate(false);
                waitingHandler.setMaxSecondaryProgressCounter(100);
                waitingHandler.setSecondaryProgressCounter(0);
            }
            String splittedName = fileName.substring(0, fileName.lastIndexOf("."));
            ArrayList<File> splittedFiles = new ArrayList<File>();
            int fileCounter = 1;
            int spectrumCounter = 0;
            String currentName = splittedName + "_" + fileCounter + ".msp";
            File testFile = new File(mspFile.getParent(), currentName);
            splittedFiles.add(testFile);
            BufferedRandomAccessFile writeBufferedRandomAccessFile = new BufferedRandomAccessFile(testFile, "rw", 102400);
            BufferedRandomAccessFile readBufferedRandomAccessFile = new BufferedRandomAccessFile(mspFile, "r", 102400);
            String lineBreak = System.getProperty("line.separator");
            long sizeOfReadAccessFile = readBufferedRandomAccessFile.length();
            long lastIndex = 0L;
            long progressUnit = sizeOfReadAccessFile / 100L;
            while ((line = readBufferedRandomAccessFile.getNextLine()) != null) {
                if (line.startsWith("Name:")) {
                    long readIndex = readBufferedRandomAccessFile.getFilePointer();
                    if (++spectrumCounter > nSpectra && sizeOfReadAccessFile - readIndex > (readIndex - lastIndex) / 2L) {
                        writeBufferedRandomAccessFile.close();
                        currentName = splittedName + "_" + ++fileCounter + ".msp";
                        testFile = new File(mspFile.getParent(), currentName);
                        splittedFiles.add(testFile);
                        lastIndex = readIndex;
                        spectrumCounter = 0;
                        writeBufferedRandomAccessFile = new BufferedRandomAccessFile(testFile, "rw", 102400);
                    }
                    if (waitingHandler != null) {
                        if (waitingHandler.isRunCanceled()) break;
                        waitingHandler.setSecondaryProgressCounter((int)(readIndex / progressUnit));
                    }
                }
                writeBufferedRandomAccessFile.writeBytes(line + lineBreak);
            }
            writeBufferedRandomAccessFile.close();
            readBufferedRandomAccessFile.close();
            ArrayList<MgfIndex> mspIndexes = new ArrayList<MgfIndex>();
            for (int i = 0; i < splittedFiles.size(); ++i) {
                File newFile = (File)splittedFiles.get(i);
                if (waitingHandler != null) {
                    waitingHandler.setWaitingText("Indexing New Files " + (i + 1) + "/" + splittedFiles.size() + ". Please Wait...");
                }
                mspIndexes.add(MspReader.getIndexMap(newFile, waitingHandler));
                if (waitingHandler.isRunCanceled()) break;
            }
            if (waitingHandler != null) {
                waitingHandler.setSecondaryProgressCounterIndeterminate(true);
            }
            return mspIndexes;
        }
        throw new IllegalArgumentException("Spectrum file format not supported.");
    }

    public static MSnSpectrum getSpectrum(BufferedRandomAccessFile bufferedRandomAccessFile, long index, String fileName) throws IOException, IllegalArgumentException {
        String line;
        bufferedRandomAccessFile.seek(index);
        HashMap<Double, Peak> spectrum = new HashMap<Double, Peak>();
        double precursorMz = 0.0;
        double precursorIntensity = 0.0;
        double rt = -1.0;
        double rt1 = -1.0;
        double rt2 = -1.0;
        ArrayList<Charge> precursorCharges = new ArrayList<Charge>();
        String scanNumber = "";
        String spectrumTitle = "";
        int numberofPeaks = 0;
        double molecularWeight = 0.0;
        boolean insideSpectrum = false;
        do {
            if ((line = bufferedRandomAccessFile.getNextLine()).endsWith("\r")) {
                line = line.replace("\r", "");
            }
            if (line.startsWith("Name:")) {
                insideSpectrum = true;
                spectrumTitle = line;
                try {
                    spectrumTitle = URLDecoder.decode(spectrumTitle, "utf-8");
                    int val = Integer.parseInt(line.substring(line.indexOf(47) + 1));
                    precursorCharges.add(new Charge(0, val));
                }
                catch (UnsupportedEncodingException e) {
                    System.out.println("An exception was thrown when trying to decode the msp title '" + spectrumTitle + "'.");
                    e.printStackTrace();
                }
                continue;
            }
            if (line.startsWith("MW:")) {
                try {
                    molecularWeight = Double.parseDouble(line.substring(line.indexOf(58) + 2));
                }
                catch (Exception e) {
                    System.out.println("An exception was thrown when trying to decode the msp Molecular Weight'" + molecularWeight + "'.");
                    e.printStackTrace();
                }
                continue;
            }
            if (line.startsWith("Comment")) {
                String temp = line.substring(line.indexOf("Parent"));
                temp = temp.substring(temp.indexOf("=") + 1);
                precursorMz = Double.parseDouble(temp);
                if (line.contains("Scan")) {
                    scanNumber = line.substring(line.indexOf("Scan=5"), line.indexOf(""));
                }
                if (!line.contains("Origfile")) continue;
                spectrumTitle = line.substring(line.indexOf("Origfile=9"), line.indexOf(""));
                continue;
            }
            if (line.startsWith("Num peaks:")) {
                String temp = line.substring(line.indexOf(58) + 2);
                try {
                    numberofPeaks = Integer.parseInt(temp);
                }
                catch (Exception e) {
                    System.out.println("An exception was thrown when trying to decode the number of peaks " + numberofPeaks + ".");
                    e.printStackTrace();
                }
                continue;
            }
            if (line.equals("") || line == null) {
                insideSpectrum = false;
                Precursor precursor = rt1 != -1.0 && rt2 != -1.0 ? new Precursor(precursorMz, precursorIntensity, precursorCharges, rt1, rt2) : new Precursor(rt, precursorMz, precursorIntensity, precursorCharges);
                MSnSpectrum msnSpectrum = new MSnSpectrum(2, precursor, spectrumTitle, spectrum, fileName);
                if (scanNumber.length() > 0) {
                    msnSpectrum.setScanNumber(scanNumber);
                }
                return msnSpectrum;
            }
            if (!insideSpectrum) continue;
            try {
                String[] values = line.split("\\s+");
                Double mz = new Double(values[0]);
                Double intensity = new Double(values[1]);
                spectrum.put(mz, new Peak(mz, intensity));
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (line != null);
        throw new IllegalArgumentException("End of the file reached before encountering the tag \"END IONS\".");
    }

    public static Precursor getPrecursor(BufferedRandomAccessFile bufferedRandomAccessFile, Long index, String fileName) throws IOException, IllegalArgumentException {
        String line;
        bufferedRandomAccessFile.seek(index.longValue());
        double precursorMz = 0.0;
        double precursorIntensity = 0.0;
        double rt = -1.0;
        double rt1 = -1.0;
        double rt2 = -1.0;
        ArrayList<Charge> precursorCharges = new ArrayList<Charge>(1);
        do {
            if ((line = bufferedRandomAccessFile.readLine()).endsWith("\r")) {
                line = line.replace("\r", "");
            }
            if (line.startsWith("Name:")) {
                int val = Integer.parseInt(line.substring(line.indexOf(47) + 1));
                precursorCharges.add(new Charge(0, val));
                try {
                    line = URLDecoder.decode(line, "utf-8");
                }
                catch (UnsupportedEncodingException e) {
                    System.out.println("An exception was thrown when trying to decode an msp title: " + line);
                    e.printStackTrace();
                }
                continue;
            }
            if (line.startsWith("Comment")) {
                String temp = line.substring(line.indexOf("Parent"));
                temp = temp.substring(temp.indexOf("=") + 1);
                precursorMz = Double.parseDouble(temp);
                precursorIntensity = 0.0;
                continue;
            }
            if (!line.equals("") && line != null) continue;
            return new Precursor(rt, precursorMz, precursorIntensity, precursorCharges);
        } while (line != null);
        throw new IllegalArgumentException("End of the file reached before encountering the tag \"END IONS\". File: " + fileName + ", title: " + line);
    }
}

