/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.normalization;

import java.io.Serializable;
import java.util.HashMap;

public class NormalizationFactors
implements Serializable {
    private HashMap<String, Double> proteinNormalizationFactors = new HashMap();
    private HashMap<String, Double> peptideNormalizationFactors = new HashMap();
    private HashMap<String, Double> psmNormalizationFactors = new HashMap();

    public boolean hasNormalizationFactors() {
        return this.hasProteinNormalisationFactors() || this.hasPeptideNormalisationFactors() || this.hasPsmNormalisationFactors();
    }

    public boolean hasProteinNormalisationFactors() {
        return !this.proteinNormalizationFactors.isEmpty();
    }

    public boolean hasPeptideNormalisationFactors() {
        return !this.peptideNormalizationFactors.isEmpty();
    }

    public boolean hasPsmNormalisationFactors() {
        return !this.psmNormalizationFactors.isEmpty();
    }

    public void resetProteinNormalisationFactors() {
        this.proteinNormalizationFactors.clear();
    }

    public void resetPeptideNormalisationFactors() {
        this.peptideNormalizationFactors.clear();
    }

    public void resetPsmNormalisationFactors() {
        this.psmNormalizationFactors.clear();
    }

    public void addProteinNormalisationFactor(String sampleName, double normalisationFactor) {
        this.proteinNormalizationFactors.put(sampleName, normalisationFactor);
    }

    public void addPeptideNormalisationFactor(String sampleName, double normalisationFactor) {
        this.peptideNormalizationFactors.put(sampleName, normalisationFactor);
    }

    public void addPsmNormalisationFactor(String sampleName, double normalisationFactor) {
        this.psmNormalizationFactors.put(sampleName, normalisationFactor);
    }

    public double getProteinNormalisationFactor(String sampleName) {
        Double normalisationFactor = this.proteinNormalizationFactors.get(sampleName);
        if (normalisationFactor == null) {
            return 1.0;
        }
        return normalisationFactor;
    }

    public double getPeptideNormalisationFactor(String sampleName) {
        Double normalisationFactor = this.peptideNormalizationFactors.get(sampleName);
        if (normalisationFactor == null) {
            return 1.0;
        }
        return normalisationFactor;
    }

    public double getPsmNormalisationFactor(String sampleName) {
        Double normalisationFactor = this.psmNormalizationFactors.get(sampleName);
        if (normalisationFactor == null) {
            return 1.0;
        }
        return normalisationFactor;
    }
}

