/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.filehandling;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class FileDisplayDialog
extends JDialog {
    private ArrayList<File> files;
    private boolean canceled = true;
    private JPanel backgroundPanel;
    private JButton okButton;
    private JEditorPane selectedFilesEditorPane;
    private JScrollPane selectedFilesScrollPane;

    public FileDisplayDialog(JFrame parent, ArrayList<File> files, boolean modal) {
        super((Frame)parent, modal);
        this.initComponents();
        this.files = files;
        this.updateFileListing();
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    public FileDisplayDialog(JDialog parent, ArrayList<File> files, boolean modal) {
        super((Dialog)parent, modal);
        this.initComponents();
        this.files = files;
        this.updateFileListing();
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    private void updateFileListing() {
        String fileListing = "<html><ol>";
        for (int i = 0; i < this.files.size(); ++i) {
            fileListing = fileListing + "<li>" + this.files.get(i).getName() + " - <a href=\"" + i + "\">remove</a></li>";
        }
        fileListing = fileListing + "</ol></html>";
        this.selectedFilesEditorPane.setText(fileListing);
        this.selectedFilesEditorPane.setCaretPosition(0);
    }

    public boolean canceled() {
        return this.canceled;
    }

    public ArrayList<File> getSelectedFiles() {
        return this.files;
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.selectedFilesScrollPane = new JScrollPane();
        this.selectedFilesEditorPane = new JEditorPane();
        this.okButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Selected Files");
        this.setMinimumSize(new Dimension(300, 300));
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.selectedFilesEditorPane.setEditable(false);
        this.selectedFilesEditorPane.setContentType("text/html");
        this.selectedFilesEditorPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent evt) {
                FileDisplayDialog.this.selectedFilesEditorPaneHyperlinkUpdate(evt);
            }
        });
        this.selectedFilesScrollPane.setViewportView(this.selectedFilesEditorPane);
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileDisplayDialog.this.okButtonActionPerformed(evt);
            }
        });
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.selectedFilesScrollPane, -1, 508, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.okButton))).addContainerGap()));
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.selectedFilesScrollPane, -1, 236, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.okButton).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.canceled = false;
        this.dispose();
    }

    private void selectedFilesEditorPaneHyperlinkUpdate(HyperlinkEvent evt) {
        if (evt.getEventType().toString().equalsIgnoreCase(HyperlinkEvent.EventType.ENTERED.toString())) {
            this.setCursor(new Cursor(12));
        } else if (evt.getEventType().toString().equalsIgnoreCase(HyperlinkEvent.EventType.EXITED.toString())) {
            this.setCursor(new Cursor(0));
        } else if (evt.getEventType().toString().equalsIgnoreCase(HyperlinkEvent.EventType.ACTIVATED.toString())) {
            int selectedFileIndex = Integer.parseInt(evt.getDescription());
            this.files.remove(selectedFileIndex);
            this.updateFileListing();
            this.setCursor(new Cursor(0));
        }
    }
}

