/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.parameters.identification_parameters;

import com.compomics.util.gui.error_handlers.HelpDialog;
import com.compomics.util.preferences.FractionSettings;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;

public class FractionSettingsDialog
extends JDialog {
    private Frame parentFrame;
    private boolean canceled = false;
    private boolean editable;
    private JPanel backgrounPanel;
    private JButton cancelButton;
    private JPanel fractionsPanel;
    private JButton helpJButton;
    private JButton okButton;
    private JLabel proteinMwLabel;
    private JSpinner proteinMwSpinner;

    public FractionSettingsDialog(Frame parentFrame, FractionSettings fractionSettings, boolean editable) {
        super(parentFrame, true);
        this.parentFrame = parentFrame;
        this.editable = editable;
        this.initComponents();
        this.setUpGui();
        this.populateGUI(fractionSettings);
        this.setLocationRelativeTo(parentFrame);
        this.setVisible(true);
    }

    public FractionSettingsDialog(Dialog owner, Frame parentFrame, FractionSettings fractionSettings, boolean editable) {
        super(owner, true);
        this.parentFrame = parentFrame;
        this.editable = editable;
        this.initComponents();
        this.setUpGui();
        this.populateGUI(fractionSettings);
        this.setLocationRelativeTo(owner);
        this.setVisible(true);
    }

    private void setUpGui() {
        this.proteinMwSpinner.setEnabled(this.editable);
    }

    private void populateGUI(FractionSettings fractionSettings) {
        this.proteinMwSpinner.setValue(fractionSettings.getProteinConfidenceMwPlots());
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public FractionSettings getFractionSettings() {
        FractionSettings fractionSettings = new FractionSettings();
        fractionSettings.setProteinConfidenceMwPlots((Double)this.proteinMwSpinner.getValue());
        return fractionSettings;
    }

    private void initComponents() {
        this.backgrounPanel = new JPanel();
        this.fractionsPanel = new JPanel();
        this.proteinMwLabel = new JLabel();
        this.proteinMwSpinner = new JSpinner();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.helpJButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Fraction Analysis");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                FractionSettingsDialog.this.formWindowClosing(evt);
            }
        });
        this.backgrounPanel.setBackground(new Color(230, 230, 230));
        this.fractionsPanel.setBorder(BorderFactory.createTitledBorder("Fractions (Beta)"));
        this.fractionsPanel.setOpaque(false);
        this.proteinMwLabel.setText("Protein Confidence MW (%)");
        this.proteinMwLabel.setToolTipText("<html>\nThe minium protein confidence required to be included in the<br>\naverage molecular weight analysis in the Fractions tab.\n</html>");
        this.proteinMwSpinner.setModel(new SpinnerNumberModel(0.0, 0.0, 100.0, 1.0));
        GroupLayout fractionsPanelLayout = new GroupLayout(this.fractionsPanel);
        this.fractionsPanel.setLayout(fractionsPanelLayout);
        fractionsPanelLayout.setHorizontalGroup(fractionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(fractionsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.proteinMwLabel).addGap(18, 18, 18).addComponent(this.proteinMwSpinner, -1, 209, Short.MAX_VALUE).addContainerGap()));
        fractionsPanelLayout.setVerticalGroup(fractionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(fractionsPanelLayout.createSequentialGroup().addContainerGap().addGroup(fractionsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.proteinMwLabel).addComponent(this.proteinMwSpinner, -2, -1, -2)).addContainerGap(14, Short.MAX_VALUE)));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FractionSettingsDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FractionSettingsDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.helpJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/help.GIF")));
        this.helpJButton.setToolTipText("Help");
        this.helpJButton.setBorder(null);
        this.helpJButton.setBorderPainted(false);
        this.helpJButton.setContentAreaFilled(false);
        this.helpJButton.setFocusable(false);
        this.helpJButton.setHorizontalTextPosition(0);
        this.helpJButton.setVerticalTextPosition(3);
        this.helpJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                FractionSettingsDialog.this.helpJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                FractionSettingsDialog.this.helpJButtonMouseExited(evt);
            }
        });
        this.helpJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FractionSettingsDialog.this.helpJButtonActionPerformed(evt);
            }
        });
        GroupLayout backgrounPanelLayout = new GroupLayout(this.backgrounPanel);
        this.backgrounPanel.setLayout(backgrounPanelLayout);
        backgrounPanelLayout.setHorizontalGroup(backgrounPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgrounPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.fractionsPanel, -1, -1, Short.MAX_VALUE).addGap(7, 7, 7)).addGroup(GroupLayout.Alignment.TRAILING, backgrounPanelLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.helpJButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.okButton, -2, 65, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton).addContainerGap()));
        backgrounPanelLayout.setVerticalGroup(backgrounPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgrounPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.fractionsPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(backgrounPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.helpJButton).addComponent(this.okButton).addComponent(this.cancelButton)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgrounPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgrounPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.canceled = true;
        this.dispose();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.canceled = true;
    }

    private void helpJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void helpJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void helpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        new HelpDialog(this.parentFrame, this.getClass().getResource("/helpFiles/FractionPreferences.html"), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), "Fraction Analysis - Help");
        this.setCursor(new Cursor(0));
    }
}

