/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.parameters.identification_parameters;

import com.compomics.util.experiment.filtering.Filter;
import com.compomics.util.experiment.identification.protein_sequences.SequenceFactory;
import com.compomics.util.gui.error_handlers.HelpDialog;
import com.compomics.util.gui.parameters.identification_parameters.ValidationQCPreferencesDialogParent;
import com.compomics.util.preferences.ValidationQCPreferences;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;

public class ValidationQCPreferencesDialog
extends JDialog {
    private Frame parentFrame;
    private ValidationQCPreferencesDialogParent validationQCPreferencesDialogParent;
    private ArrayList<Filter> psmFilters = new ArrayList();
    private ArrayList<Filter> peptideFilters = new ArrayList();
    private ArrayList<Filter> proteinFilters = new ArrayList();
    boolean canceled = false;
    private boolean userInput = false;
    private boolean editable;
    private JMenuItem addPeptideFilterMenuItem;
    private JMenuItem addProteinFilterMenuItem;
    private JMenuItem addPsmFilterMenuItem;
    private JButton cancelButton;
    private JCheckBox confidenceCheck;
    private JCheckBox dbCheck;
    private JMenuItem editPeptideFilterMenuItem;
    private JMenuItem editProteinFilterMenuItem;
    private JMenuItem editPsmFilterMenuItem;
    private JPanel generalSettingsPanel;
    private JButton helpJButton;
    private JLabel helpLbl;
    private JLabel markDoubtfulLabel;
    private JCheckBox nTargetCheck;
    private JButton okButton;
    private JPanel peptideFiltersPanel;
    private JPopupMenu peptidePopupMenu;
    private JScrollPane peptideScrollPane;
    private JTable peptideTable;
    private JPanel proteinFiltersPanel;
    private JPopupMenu proteinPopupMenu;
    private JScrollPane proteinScrollPane;
    private JTable proteinTable;
    private JPanel psmFiltersPanel;
    private JPopupMenu psmPopupMenu;
    private JScrollPane psmScrollPane;
    private JTable psmTable;
    private JMenuItem removePeptideFilterMenuItem;
    private JMenuItem removeProteinFilterMenuItem;
    private JMenuItem removePsmFilterMenuItem;
    private JPanel validationQCPreferencesDialogPanel;

    public ValidationQCPreferencesDialog(Frame parentFrame, ValidationQCPreferencesDialogParent validationQCPreferencesDialogParent, ValidationQCPreferences validationQCPreferences, boolean editable) {
        super(parentFrame, true);
        ArrayList<Filter> arrayList;
        ArrayList<Filter> originalPeptidesFilters;
        this.initComponents();
        this.parentFrame = parentFrame;
        this.validationQCPreferencesDialogParent = validationQCPreferencesDialogParent;
        this.editable = editable;
        ArrayList<Filter> originalPsmFilters = validationQCPreferences.getPsmFilters();
        if (originalPsmFilters != null) {
            for (Filter filter : originalPsmFilters) {
                this.psmFilters.add(filter.clone());
            }
        } else {
            this.psmFilters = new ArrayList();
        }
        if ((originalPeptidesFilters = validationQCPreferences.getPeptideFilters()) != null) {
            for (Filter filter : originalPeptidesFilters) {
                this.peptideFilters.add(filter.clone());
            }
        } else {
            this.peptideFilters = new ArrayList();
        }
        if ((arrayList = validationQCPreferences.getProteinFilters()) != null) {
            for (Filter filter : arrayList) {
                this.proteinFilters.add(filter.clone());
            }
        } else {
            this.proteinFilters = new ArrayList();
        }
        this.setUpGUI(validationQCPreferences);
        this.setLocationRelativeTo(parentFrame);
        this.setVisible(true);
    }

    public ValidationQCPreferencesDialog(Dialog owner, Frame parentFrame, ValidationQCPreferencesDialogParent validationQCPreferencesDialogParent, ValidationQCPreferences validationQCPreferences, boolean editable) {
        super(owner, true);
        ArrayList<Filter> arrayList;
        ArrayList<Filter> originalPeptidesFilters;
        this.initComponents();
        this.parentFrame = parentFrame;
        this.validationQCPreferencesDialogParent = validationQCPreferencesDialogParent;
        this.editable = editable;
        ArrayList<Filter> originalPsmFilters = validationQCPreferences.getPsmFilters();
        if (originalPsmFilters != null) {
            for (Filter filter : originalPsmFilters) {
                this.psmFilters.add(filter.clone());
            }
        } else {
            this.psmFilters = new ArrayList();
        }
        if ((originalPeptidesFilters = validationQCPreferences.getPeptideFilters()) != null) {
            for (Filter filter : originalPeptidesFilters) {
                this.peptideFilters.add(filter.clone());
            }
        } else {
            this.peptideFilters = new ArrayList();
        }
        if ((arrayList = validationQCPreferences.getProteinFilters()) != null) {
            for (Filter filter : arrayList) {
                this.proteinFilters.add(filter.clone());
            }
        } else {
            this.proteinFilters = new ArrayList();
        }
        this.setUpGUI(validationQCPreferences);
        this.setLocationRelativeTo(owner);
        this.setVisible(true);
    }

    private void setUpGUI(ValidationQCPreferences validationQCPreferences) {
        this.dbCheck.setSelected(validationQCPreferences.isDbSize());
        this.nTargetCheck.setSelected(validationQCPreferences.isFirstDecoy());
        this.confidenceCheck.setSelected(validationQCPreferences.getConfidenceMargin() != 0.0);
        this.psmTable.getColumn(" ").setMaxWidth(30);
        this.peptideTable.getColumn(" ").setMaxWidth(30);
        this.proteinTable.getColumn(" ").setMaxWidth(30);
        this.proteinScrollPane.getViewport().setOpaque(false);
        this.peptideScrollPane.getViewport().setOpaque(false);
        this.psmScrollPane.getViewport().setOpaque(false);
        this.proteinTable.getTableHeader().setReorderingAllowed(false);
        this.peptideTable.getTableHeader().setReorderingAllowed(false);
        this.psmTable.getTableHeader().setReorderingAllowed(false);
        this.dbCheck.setEnabled(this.editable);
        this.nTargetCheck.setEnabled(this.editable);
        this.confidenceCheck.setEnabled(this.editable);
    }

    private void initComponents() {
        this.psmPopupMenu = new JPopupMenu();
        this.addPsmFilterMenuItem = new JMenuItem();
        this.editPsmFilterMenuItem = new JMenuItem();
        this.removePsmFilterMenuItem = new JMenuItem();
        this.peptidePopupMenu = new JPopupMenu();
        this.addPeptideFilterMenuItem = new JMenuItem();
        this.editPeptideFilterMenuItem = new JMenuItem();
        this.removePeptideFilterMenuItem = new JMenuItem();
        this.proteinPopupMenu = new JPopupMenu();
        this.addProteinFilterMenuItem = new JMenuItem();
        this.editProteinFilterMenuItem = new JMenuItem();
        this.removeProteinFilterMenuItem = new JMenuItem();
        this.validationQCPreferencesDialogPanel = new JPanel();
        this.generalSettingsPanel = new JPanel();
        this.dbCheck = new JCheckBox();
        this.nTargetCheck = new JCheckBox();
        this.markDoubtfulLabel = new JLabel();
        this.confidenceCheck = new JCheckBox();
        this.proteinFiltersPanel = new JPanel();
        this.proteinScrollPane = new JScrollPane();
        this.proteinTable = new JTable();
        this.peptideFiltersPanel = new JPanel();
        this.peptideScrollPane = new JScrollPane();
        this.peptideTable = new JTable();
        this.psmFiltersPanel = new JPanel();
        this.psmScrollPane = new JScrollPane();
        this.psmTable = new JTable();
        this.helpLbl = new JLabel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.helpJButton = new JButton();
        this.addPsmFilterMenuItem.setText("Add Filter");
        this.addPsmFilterMenuItem.setToolTipText("Add a new filter");
        this.addPsmFilterMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ValidationQCPreferencesDialog.this.addPsmFilterMenuItemActionPerformed(evt);
            }
        });
        this.psmPopupMenu.add(this.addPsmFilterMenuItem);
        this.editPsmFilterMenuItem.setText("Edit Filter");
        this.editPsmFilterMenuItem.setToolTipText("Edit the selected filter");
        this.editPsmFilterMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ValidationQCPreferencesDialog.this.editPsmFilterMenuItemActionPerformed(evt);
            }
        });
        this.psmPopupMenu.add(this.editPsmFilterMenuItem);
        this.removePsmFilterMenuItem.setText("Remove Filter");
        this.removePsmFilterMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ValidationQCPreferencesDialog.this.removePsmFilterMenuItemActionPerformed(evt);
            }
        });
        this.psmPopupMenu.add(this.removePsmFilterMenuItem);
        this.addPeptideFilterMenuItem.setText("Add Filter");
        this.addPeptideFilterMenuItem.setToolTipText("Add a new filter");
        this.addPeptideFilterMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ValidationQCPreferencesDialog.this.addPeptideFilterMenuItemActionPerformed(evt);
            }
        });
        this.peptidePopupMenu.add(this.addPeptideFilterMenuItem);
        this.editPeptideFilterMenuItem.setText("Edit Filter");
        this.editPeptideFilterMenuItem.setToolTipText("Edit the selected filter");
        this.editPeptideFilterMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ValidationQCPreferencesDialog.this.editPeptideFilterMenuItemActionPerformed(evt);
            }
        });
        this.peptidePopupMenu.add(this.editPeptideFilterMenuItem);
        this.removePeptideFilterMenuItem.setText("Remove Filter");
        this.removePeptideFilterMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ValidationQCPreferencesDialog.this.removePeptideFilterMenuItemActionPerformed(evt);
            }
        });
        this.peptidePopupMenu.add(this.removePeptideFilterMenuItem);
        this.addProteinFilterMenuItem.setText("Add Filter");
        this.addProteinFilterMenuItem.setToolTipText("Add a new filter");
        this.addProteinFilterMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ValidationQCPreferencesDialog.this.addProteinFilterMenuItemActionPerformed(evt);
            }
        });
        this.proteinPopupMenu.add(this.addProteinFilterMenuItem);
        this.editProteinFilterMenuItem.setText("Edit Filter");
        this.editProteinFilterMenuItem.setToolTipText("Edit the selected filter");
        this.editProteinFilterMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ValidationQCPreferencesDialog.this.editProteinFilterMenuItemActionPerformed(evt);
            }
        });
        this.proteinPopupMenu.add(this.editProteinFilterMenuItem);
        this.removeProteinFilterMenuItem.setText("Remove Filter");
        this.removeProteinFilterMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ValidationQCPreferencesDialog.this.removeProteinFilterMenuItemActionPerformed(evt);
            }
        });
        this.proteinPopupMenu.add(this.removeProteinFilterMenuItem);
        this.setDefaultCloseOperation(2);
        this.setTitle("Quality Control (beta)");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ValidationQCPreferencesDialog.this.formWindowClosing(evt);
            }
        });
        this.validationQCPreferencesDialogPanel.setBackground(new Color(230, 230, 230));
        this.generalSettingsPanel.setBorder(BorderFactory.createTitledBorder("General Settings"));
        this.generalSettingsPanel.setOpaque(false);
        this.dbCheck.setText("Hits obtained on small databases (<" + SequenceFactory.minProteinCount + " protein sequences)");
        this.dbCheck.setIconTextGap(15);
        this.dbCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ValidationQCPreferencesDialog.this.dbCheckActionPerformed(evt);
            }
        });
        this.nTargetCheck.setText("Datasets with a low number of target hits");
        this.nTargetCheck.setIconTextGap(15);
        this.nTargetCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ValidationQCPreferencesDialog.this.nTargetCheckActionPerformed(evt);
            }
        });
        this.markDoubtfulLabel.setText("Mark as Doubtful");
        this.confidenceCheck.setText("Hits near the confidence threshold (margin= 1 x resolution)");
        this.confidenceCheck.setIconTextGap(15);
        this.confidenceCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ValidationQCPreferencesDialog.this.confidenceCheckActionPerformed(evt);
            }
        });
        GroupLayout generalSettingsPanelLayout = new GroupLayout(this.generalSettingsPanel);
        this.generalSettingsPanel.setLayout(generalSettingsPanelLayout);
        generalSettingsPanelLayout.setHorizontalGroup(generalSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(generalSettingsPanelLayout.createSequentialGroup().addContainerGap().addGroup(generalSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(generalSettingsPanelLayout.createSequentialGroup().addGap(10, 10, 10).addGroup(generalSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.confidenceCheck).addComponent(this.dbCheck).addComponent(this.nTargetCheck))).addComponent(this.markDoubtfulLabel)).addContainerGap(-1, Short.MAX_VALUE)));
        generalSettingsPanelLayout.setVerticalGroup(generalSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(generalSettingsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.markDoubtfulLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.dbCheck).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nTargetCheck).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.confidenceCheck).addContainerGap(-1, Short.MAX_VALUE)));
        this.proteinFiltersPanel.setBorder(BorderFactory.createTitledBorder("Protein Filters"));
        this.proteinFiltersPanel.setOpaque(false);
        this.proteinScrollPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                ValidationQCPreferencesDialog.this.proteinScrollPaneMouseReleased(evt);
            }
        });
        this.proteinTable.setModel(new FiltersTableModel(this.proteinFilters));
        this.proteinTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                ValidationQCPreferencesDialog.this.proteinTableMouseReleased(evt);
            }
        });
        this.proteinScrollPane.setViewportView(this.proteinTable);
        GroupLayout proteinFiltersPanelLayout = new GroupLayout(this.proteinFiltersPanel);
        this.proteinFiltersPanel.setLayout(proteinFiltersPanelLayout);
        proteinFiltersPanelLayout.setHorizontalGroup(proteinFiltersPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(proteinFiltersPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.proteinScrollPane, -1, 735, Short.MAX_VALUE).addContainerGap()));
        proteinFiltersPanelLayout.setVerticalGroup(proteinFiltersPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(proteinFiltersPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.proteinScrollPane, -1, 123, Short.MAX_VALUE).addContainerGap()));
        this.peptideFiltersPanel.setBorder(BorderFactory.createTitledBorder("Peptide Filters"));
        this.peptideFiltersPanel.setOpaque(false);
        this.peptideScrollPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                ValidationQCPreferencesDialog.this.peptideScrollPaneMouseReleased(evt);
            }
        });
        this.peptideTable.setModel(new FiltersTableModel(this.peptideFilters));
        this.peptideTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                ValidationQCPreferencesDialog.this.peptideTableMouseReleased(evt);
            }
        });
        this.peptideScrollPane.setViewportView(this.peptideTable);
        GroupLayout peptideFiltersPanelLayout = new GroupLayout(this.peptideFiltersPanel);
        this.peptideFiltersPanel.setLayout(peptideFiltersPanelLayout);
        peptideFiltersPanelLayout.setHorizontalGroup(peptideFiltersPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(peptideFiltersPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.peptideScrollPane).addContainerGap()));
        peptideFiltersPanelLayout.setVerticalGroup(peptideFiltersPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(peptideFiltersPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.peptideScrollPane, -1, 123, Short.MAX_VALUE).addContainerGap()));
        this.psmFiltersPanel.setBorder(BorderFactory.createTitledBorder("PSM Filters"));
        this.psmFiltersPanel.setOpaque(false);
        this.psmScrollPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                ValidationQCPreferencesDialog.this.psmScrollPaneMouseReleased(evt);
            }
        });
        this.psmTable.setModel(new FiltersTableModel(this.psmFilters));
        this.psmTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                ValidationQCPreferencesDialog.this.psmTableMouseReleased(evt);
            }
        });
        this.psmScrollPane.setViewportView(this.psmTable);
        GroupLayout psmFiltersPanelLayout = new GroupLayout(this.psmFiltersPanel);
        this.psmFiltersPanel.setLayout(psmFiltersPanelLayout);
        psmFiltersPanelLayout.setHorizontalGroup(psmFiltersPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(psmFiltersPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.psmScrollPane, -1, 735, Short.MAX_VALUE).addContainerGap()));
        psmFiltersPanelLayout.setVerticalGroup(psmFiltersPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(psmFiltersPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.psmScrollPane, -1, 121, Short.MAX_VALUE).addContainerGap()));
        this.helpLbl.setFont(new Font("Tahoma", 2, 11));
        this.helpLbl.setText("Right-click in the tables to edit the filters.");
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ValidationQCPreferencesDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ValidationQCPreferencesDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.helpJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/help.GIF")));
        this.helpJButton.setToolTipText("Help");
        this.helpJButton.setBorder(null);
        this.helpJButton.setBorderPainted(false);
        this.helpJButton.setContentAreaFilled(false);
        this.helpJButton.setFocusable(false);
        this.helpJButton.setHorizontalTextPosition(0);
        this.helpJButton.setVerticalTextPosition(3);
        this.helpJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                ValidationQCPreferencesDialog.this.helpJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                ValidationQCPreferencesDialog.this.helpJButtonMouseExited(evt);
            }
        });
        this.helpJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ValidationQCPreferencesDialog.this.helpJButtonActionPerformed(evt);
            }
        });
        GroupLayout validationQCPreferencesDialogPanelLayout = new GroupLayout(this.validationQCPreferencesDialogPanel);
        this.validationQCPreferencesDialogPanel.setLayout(validationQCPreferencesDialogPanelLayout);
        validationQCPreferencesDialogPanelLayout.setHorizontalGroup(validationQCPreferencesDialogPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(validationQCPreferencesDialogPanelLayout.createSequentialGroup().addContainerGap().addGroup(validationQCPreferencesDialogPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(validationQCPreferencesDialogPanelLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.helpJButton).addGap(18, 18, 18).addComponent(this.helpLbl).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.okButton, -2, 65, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton)).addComponent(this.generalSettingsPanel, -1, -1, Short.MAX_VALUE).addComponent(this.psmFiltersPanel, -1, -1, Short.MAX_VALUE).addComponent(this.proteinFiltersPanel, -1, -1, Short.MAX_VALUE).addComponent(this.peptideFiltersPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        validationQCPreferencesDialogPanelLayout.setVerticalGroup(validationQCPreferencesDialogPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, validationQCPreferencesDialogPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.generalSettingsPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.proteinFiltersPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.peptideFiltersPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.psmFiltersPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(validationQCPreferencesDialogPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.helpJButton).addComponent(this.helpLbl).addComponent(this.okButton).addComponent(this.cancelButton)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.validationQCPreferencesDialogPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.validationQCPreferencesDialogPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.canceled = true;
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (!this.userInput) {
            this.canceled = true;
        }
        this.dispose();
    }

    private void addPsmFilterMenuItemActionPerformed(ActionEvent evt) {
        Filter newFilter = this.validationQCPreferencesDialogParent.createPsmFilter();
        if (newFilter != null) {
            this.psmFilters.add(newFilter);
            ((DefaultTableModel)this.psmTable.getModel()).fireTableDataChanged();
            this.userInput = true;
        }
    }

    private void editPsmFilterMenuItemActionPerformed(ActionEvent evt) {
        int row = this.psmTable.getSelectedRow();
        Filter selectedFilter = this.psmFilters.get(row);
        Filter editedFilter = this.validationQCPreferencesDialogParent.editFilter(selectedFilter);
        if (editedFilter != null) {
            this.psmFilters.set(row, editedFilter);
            ((DefaultTableModel)this.psmTable.getModel()).fireTableDataChanged();
            this.userInput = true;
        }
    }

    private void psmTableMouseReleased(MouseEvent evt) {
        if (evt != null && this.psmTable.rowAtPoint(evt.getPoint()) != -1) {
            int row = this.psmTable.rowAtPoint(evt.getPoint());
            this.psmTable.setRowSelectionInterval(row, row);
        }
        if (evt != null && evt.getButton() == 3 && this.editable) {
            this.editPsmFilterMenuItem.setVisible(this.psmTable.getSelectedRow() != -1);
            this.removePsmFilterMenuItem.setVisible(this.psmTable.getSelectedRow() != -1);
            this.psmPopupMenu.show(this.psmTable, evt.getX(), evt.getY());
        }
        if (evt != null && evt.getButton() == 1 && evt.getClickCount() == 2 && this.editable) {
            this.editPsmFilterMenuItemActionPerformed(null);
        }
    }

    private void addPeptideFilterMenuItemActionPerformed(ActionEvent evt) {
        Filter newFilter = this.validationQCPreferencesDialogParent.createPeptideFilter();
        if (newFilter != null) {
            this.peptideFilters.add(newFilter);
            ((DefaultTableModel)this.peptideTable.getModel()).fireTableDataChanged();
            this.userInput = true;
        }
    }

    private void editPeptideFilterMenuItemActionPerformed(ActionEvent evt) {
        int row = this.peptideTable.getSelectedRow();
        Filter selectedFilter = this.peptideFilters.get(row);
        Filter editedFilter = this.validationQCPreferencesDialogParent.editFilter(selectedFilter);
        if (editedFilter != null) {
            this.peptideFilters.set(row, editedFilter);
            ((DefaultTableModel)this.peptideTable.getModel()).fireTableDataChanged();
            this.userInput = true;
        }
    }

    private void addProteinFilterMenuItemActionPerformed(ActionEvent evt) {
        Filter newFilter = this.validationQCPreferencesDialogParent.createProteinFilter();
        if (newFilter != null) {
            this.proteinFilters.add(newFilter);
            ((DefaultTableModel)this.proteinTable.getModel()).fireTableDataChanged();
            this.userInput = true;
        }
    }

    private void editProteinFilterMenuItemActionPerformed(ActionEvent evt) {
        int row = this.proteinTable.getSelectedRow();
        Filter selectedFilter = this.proteinFilters.get(row);
        Filter editedFilter = this.validationQCPreferencesDialogParent.editFilter(selectedFilter);
        if (editedFilter != null) {
            this.proteinFilters.set(row, editedFilter);
            ((DefaultTableModel)this.proteinTable.getModel()).fireTableDataChanged();
            this.userInput = true;
        }
    }

    private void peptideTableMouseReleased(MouseEvent evt) {
        if (evt != null && this.peptideTable.rowAtPoint(evt.getPoint()) != -1) {
            int row = this.peptideTable.rowAtPoint(evt.getPoint());
            this.peptideTable.setRowSelectionInterval(row, row);
        }
        if (evt != null && evt.getButton() == 3 && this.editable) {
            this.editPeptideFilterMenuItem.setVisible(this.peptideTable.getSelectedRow() != -1);
            this.removePeptideFilterMenuItem.setVisible(this.peptideTable.getSelectedRow() != -1);
            this.peptidePopupMenu.show(this.peptideTable, evt.getX(), evt.getY());
        }
        if (evt != null && evt.getButton() == 1 && evt.getClickCount() == 2 && this.editable) {
            this.editPeptideFilterMenuItemActionPerformed(null);
        }
    }

    private void proteinTableMouseReleased(MouseEvent evt) {
        if (evt != null && this.proteinTable.rowAtPoint(evt.getPoint()) != -1) {
            int row = this.proteinTable.rowAtPoint(evt.getPoint());
            this.proteinTable.setRowSelectionInterval(row, row);
        }
        if (evt != null && evt.getButton() == 3 && this.editable) {
            this.editProteinFilterMenuItem.setVisible(this.proteinTable.getSelectedRow() != -1);
            this.removeProteinFilterMenuItem.setVisible(this.proteinTable.getSelectedRow() != -1);
            this.proteinPopupMenu.show(this.proteinTable, evt.getX(), evt.getY());
        }
        if (evt != null && evt.getButton() == 1 && evt.getClickCount() == 2 && this.editable) {
            this.editProteinFilterMenuItemActionPerformed(null);
        }
    }

    private void removeProteinFilterMenuItemActionPerformed(ActionEvent evt) {
        int row = this.proteinTable.getSelectedRow();
        this.proteinFilters.remove(row);
        ((DefaultTableModel)this.proteinTable.getModel()).fireTableDataChanged();
        this.userInput = true;
    }

    private void removePeptideFilterMenuItemActionPerformed(ActionEvent evt) {
        int row = this.peptideTable.getSelectedRow();
        this.peptideFilters.remove(row);
        ((DefaultTableModel)this.peptideTable.getModel()).fireTableDataChanged();
        this.userInput = true;
    }

    private void removePsmFilterMenuItemActionPerformed(ActionEvent evt) {
        int row = this.psmTable.getSelectedRow();
        this.psmFilters.remove(row);
        ((DefaultTableModel)this.psmTable.getModel()).fireTableDataChanged();
        this.userInput = true;
    }

    private void proteinScrollPaneMouseReleased(MouseEvent evt) {
        this.proteinTableMouseReleased(evt);
    }

    private void formWindowClosing(WindowEvent evt) {
        this.canceled = true;
    }

    private void peptideScrollPaneMouseReleased(MouseEvent evt) {
        this.peptideTableMouseReleased(evt);
    }

    private void psmScrollPaneMouseReleased(MouseEvent evt) {
        this.psmTableMouseReleased(evt);
    }

    private void dbCheckActionPerformed(ActionEvent evt) {
        this.userInput = true;
    }

    private void nTargetCheckActionPerformed(ActionEvent evt) {
        this.userInput = true;
    }

    private void confidenceCheckActionPerformed(ActionEvent evt) {
        this.userInput = true;
    }

    private void helpJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void helpJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void helpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        new HelpDialog(this.parentFrame, this.getClass().getResource("/helpFiles/QualityControlPreferences.html"), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), "Quality Control - Help");
        this.setCursor(new Cursor(0));
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public ValidationQCPreferences getValidationQCPreferences() {
        ValidationQCPreferences validationQCPreferences = new ValidationQCPreferences();
        validationQCPreferences.setDbSize(this.dbCheck.isSelected());
        validationQCPreferences.setFirstDecoy(this.nTargetCheck.isSelected());
        if (!this.confidenceCheck.isSelected()) {
            validationQCPreferences.setConfidenceMargin(0.0);
        } else {
            validationQCPreferences.setConfidenceMargin(1.0);
        }
        validationQCPreferences.setPsmFilters(this.psmFilters);
        validationQCPreferences.setPeptideFilters(this.peptideFilters);
        validationQCPreferences.setProteinFilters(this.proteinFilters);
        return validationQCPreferences;
    }

    private class FiltersTableModel
    extends DefaultTableModel {
        private ArrayList<Filter> filters;

        public FiltersTableModel(ArrayList<Filter> filters) {
            this.filters = filters;
        }

        @Override
        public int getRowCount() {
            if (this.filters == null) {
                return 0;
            }
            return this.filters.size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return " ";
                }
                case 1: {
                    return "Name";
                }
                case 2: {
                    return "Description";
                }
            }
            return "";
        }

        @Override
        public Object getValueAt(int row, int column) {
            Filter filter = this.filters.get(row);
            switch (column) {
                case 0: {
                    return row + 1;
                }
                case 1: {
                    return filter.getName();
                }
                case 2: {
                    return filter.getDescription();
                }
            }
            return "";
        }

        public Class getColumnClass(int columnIndex) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (this.getValueAt(i, columnIndex) == null) continue;
                return this.getValueAt(i, columnIndex).getClass();
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }
    }
}

