/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.variants.aa_substitutions;

import com.compomics.util.experiment.biology.AminoAcid;
import com.compomics.util.experiment.biology.variants.AaSubstitutionMatrix;
import java.util.HashSet;
import javax.swing.table.DefaultTableModel;

public class AaSubstitutionMatrixTableModel
extends DefaultTableModel {
    private char[] aminoAcids = AminoAcid.getUniqueAminoAcids();
    private AaSubstitutionMatrix aaSubstitutionMatrix;
    private boolean editable = false;

    public AaSubstitutionMatrixTableModel(AaSubstitutionMatrix aaSubstitutionMatrix, boolean editable) {
        this.aaSubstitutionMatrix = aaSubstitutionMatrix;
        this.editable = editable;
    }

    @Override
    public int getRowCount() {
        if (this.aminoAcids != null) {
            return this.aminoAcids.length;
        }
        return 0;
    }

    @Override
    public int getColumnCount() {
        if (this.aminoAcids != null) {
            return this.aminoAcids.length + 1;
        }
        return 0;
    }

    @Override
    public String getColumnName(int column) {
        if (column == 0) {
            return "  ";
        }
        return this.aminoAcids[column - 1] + "";
    }

    @Override
    public Object getValueAt(int row, int column) {
        HashSet<Character> possibleVariants;
        char originalAa = this.aminoAcids[row];
        switch (column) {
            case 0: {
                return Character.valueOf(originalAa);
            }
        }
        if (this.aaSubstitutionMatrix != null && (possibleVariants = this.aaSubstitutionMatrix.getSubstitutionAminoAcids(Character.valueOf(originalAa))) != null) {
            Character destinationAminoAcid = Character.valueOf(this.aminoAcids[column - 1]);
            return possibleVariants.contains(destinationAminoAcid);
        }
        return false;
    }

    public Class getColumnClass(int columnIndex) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (this.getValueAt(i, columnIndex) == null) continue;
            return this.getValueAt(i, columnIndex).getClass();
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.editable && columnIndex > 1;
    }

    public void setAaSubstitutionMatrix(AaSubstitutionMatrix aaSubstitutionMatrix) {
        this.aaSubstitutionMatrix = aaSubstitutionMatrix;
    }
}

