/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.io;

import com.compomics.util.enumeration.OperatingSystemEnum;
import com.compomics.util.io.PropertiesManager;
import java.io.File;
import org.apache.log4j.Logger;

public class FileSystemAccessor {
    Logger logger = Logger.getLogger(FileSystemAccessor.class);

    public static OperatingSystemEnum getOperatingSystem() {
        String lOSName = System.getProperty("os.name").toLowerCase();
        if (lOSName.indexOf("win") > -1) {
            return OperatingSystemEnum.WINDOWS;
        }
        if (lOSName.indexOf("uni") > -1) {
            return OperatingSystemEnum.UNIX;
        }
        if (lOSName.indexOf("mac") > -1) {
            return OperatingSystemEnum.MACOS;
        }
        return null;
    }

    public static File getHomeFolder() {
        String lHomeDirectory = System.getProperty("user.home");
        File lFile = new File(lHomeDirectory);
        return lFile;
    }

    public static String getPathOfClass(String aClassname) {
        String lFileSeparator = System.getProperties().get("file.separator").toString();
        String path = PropertiesManager.getInstance().getClass().getProtectionDomain().getCodeSource().getLocation().toString();
        path = path.startsWith("file:") ? path.substring("file:".length(), path.lastIndexOf(lFileSeparator) + 1) : path.substring(0, path.lastIndexOf(lFileSeparator) + 1);
        path = path.replace("%20", " ");
        path = path.replace("%5b", "[");
        path = path.replace("%5d", "]");
        return path;
    }
}

