/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.io.compression;

import com.compomics.util.waiting.WaitingHandler;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;

public class TarUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tarFolder(File folder, File destinationFile, WaitingHandler waitingHandler) throws FileNotFoundException, ArchiveException, IOException {
        FileOutputStream fos = new FileOutputStream(destinationFile);
        try {
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            try {
                TarArchiveOutputStream tarOutput = (TarArchiveOutputStream)new ArchiveStreamFactory().createArchiveOutputStream("tar", (OutputStream)bos);
                try {
                    tarOutput.setLongFileMode(2);
                    File matchFolder = folder;
                    TarUtils.addFolderContent((ArchiveOutputStream)tarOutput, matchFolder, waitingHandler);
                }
                finally {
                    tarOutput.close();
                }
            }
            finally {
                bos.close();
            }
        }
        finally {
            fos.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tarFolderContent(File folder, File destinationFile, HashSet<String> exceptionsPaths, WaitingHandler waitingHandler) throws FileNotFoundException, ArchiveException, IOException {
        FileOutputStream fos = new FileOutputStream(destinationFile);
        try {
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            try {
                TarArchiveOutputStream tarOutput = (TarArchiveOutputStream)new ArchiveStreamFactory().createArchiveOutputStream("tar", (OutputStream)bos);
                try {
                    tarOutput.setLongFileMode(2);
                    for (File file : folder.listFiles()) {
                        String path = file.getAbsolutePath();
                        if (exceptionsPaths.contains(path)) continue;
                        if (file.isDirectory()) {
                            TarUtils.addFolderContent((ArchiveOutputStream)tarOutput, file, waitingHandler);
                            continue;
                        }
                        TarUtils.addFile((ArchiveOutputStream)tarOutput, file, waitingHandler);
                    }
                }
                finally {
                    tarOutput.close();
                }
            }
            finally {
                bos.close();
            }
        }
        finally {
            fos.close();
        }
    }

    public static void addFolderContent(ArchiveOutputStream tarOutput, File folder, WaitingHandler waitingHandler) throws FileNotFoundException, IOException {
        TarUtils.addFolderContent(tarOutput, folder, null, waitingHandler);
    }

    private static void addFolderContent(ArchiveOutputStream tarOutput, File folder, String parentFolder, WaitingHandler waitingHandler) throws FileNotFoundException, IOException {
        if (parentFolder == null) {
            parentFolder = folder.getParentFile().getAbsolutePath();
        }
        for (File file : folder.listFiles()) {
            if (file.isDirectory()) {
                TarUtils.addFolderContent(tarOutput, file, parentFolder, waitingHandler);
                continue;
            }
            TarUtils.addFile(tarOutput, file, parentFolder, waitingHandler);
        }
    }

    private static void addFile(ArchiveOutputStream tarOutput, File file, WaitingHandler waitingHandler) throws FileNotFoundException, IOException {
        TarUtils.addFile(tarOutput, file, null, waitingHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addFile(ArchiveOutputStream tarOutput, File file, String parentFolder, WaitingHandler waitingHandler) throws FileNotFoundException, IOException {
        if (parentFolder == null) {
            parentFolder = file.getParentFile().getAbsolutePath();
        }
        int BUFFER = 2048;
        FileInputStream fi = new FileInputStream(file);
        try {
            BufferedInputStream origin = new BufferedInputStream(fi, 2048);
            try {
                int count;
                byte[] data = new byte[2048];
                String filePath = file.getAbsolutePath();
                String relativePath = filePath.substring(parentFolder.length() + 1);
                TarArchiveEntry entry = new TarArchiveEntry(file, relativePath);
                tarOutput.putArchiveEntry((ArchiveEntry)entry);
                while (!((count = origin.read(data, 0, 2048)) == -1 || waitingHandler != null && waitingHandler.isRunCanceled())) {
                    tarOutput.write(data, 0, count);
                }
                tarOutput.closeArchiveEntry();
            }
            finally {
                origin.close();
            }
        }
        finally {
            fi.close();
        }
    }

    public static void extractFile(File tarFile, WaitingHandler waitingHandler) throws FileNotFoundException, ArchiveException, IOException {
        TarUtils.extractFile(tarFile, null, waitingHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extractFile(File tarFile, File destinationFolder, WaitingHandler waitingHandler) throws FileNotFoundException, ArchiveException, IOException {
        int BUFFER = 2048;
        byte[] data = new byte[2048];
        FileInputStream fi = new FileInputStream(tarFile);
        try {
            BufferedInputStream bis = new BufferedInputStream(fi, 2048);
            boolean isWindowsPlatform = System.getProperty("os.name").lastIndexOf("Windows") == -1;
            try {
                ArchiveInputStream tarInput = new ArchiveStreamFactory().createArchiveInputStream((InputStream)bis);
                try {
                    ArchiveEntry archiveEntry;
                    long fileLength = tarFile.length();
                    while ((archiveEntry = tarInput.getNextEntry()) != null) {
                        String entryName = archiveEntry.getName();
                        entryName = isWindowsPlatform ? entryName.replaceAll("\\\\", "/") : entryName.replaceAll("/", "\\\\");
                        File entryFile = new File(entryName);
                        File entryFolder = destinationFolder == null ? entryFile.getParentFile() : new File(destinationFolder, entryName).getParentFile();
                        File destinationFile = new File(entryFolder, entryFile.getName());
                        if (archiveEntry.isDirectory()) {
                            destinationFile.mkdirs();
                        } else if (entryFolder.exists() || entryFolder.mkdirs()) {
                            FileOutputStream fos = new FileOutputStream(destinationFile);
                            try {
                                BufferedOutputStream bos = new BufferedOutputStream(fos);
                                try {
                                    int count;
                                    while ((count = tarInput.read(data, 0, 2048)) != -1) {
                                        bos.write(data, 0, count);
                                        if (waitingHandler == null || !waitingHandler.isRunCanceled()) continue;
                                        break;
                                    }
                                }
                                finally {
                                    bos.close();
                                }
                            }
                            finally {
                                fos.close();
                            }
                            if (waitingHandler != null) {
                                int progress = (int)(100L * tarInput.getBytesRead() / fileLength);
                                waitingHandler.setSecondaryProgressCounter(progress);
                            }
                        } else {
                            throw new IOException("Folder " + destinationFolder.getAbsolutePath() + " does not exist and could not be created. Verify that you have the right to write in this directory.");
                        }
                        if (waitingHandler == null || !waitingHandler.isRunCanceled()) continue;
                        break;
                    }
                }
                finally {
                    tarInput.close();
                }
            }
            finally {
                bis.close();
            }
        }
        finally {
            fi.close();
        }
    }
}

