/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.preferences;

import com.compomics.util.experiment.biology.taxonomy.SpeciesFactory;
import com.compomics.util.experiment.identification.identification_parameters.SearchParameters;
import com.compomics.util.experiment.identification.protein_sequences.FastaIndex;
import com.compomics.util.experiment.identification.protein_sequences.SequenceFactory;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;

public class GenePreferences
implements Serializable {
    static final long serialVersionUID = -1286840382594446279L;
    private Boolean autoUpdate;
    private Boolean useGeneMapping;
    private Integer selectedBackgroundSpecies;
    private static String GENE_MAPPING_FOLDER = System.getProperty("user.home") + "/.compomics/gene_mappings/";
    public static final String GENE_MAPPING_FILE_SUFFIX = "_gene_mappings";
    public static final String GO_MAPPING_FILE_SUFFIX = "_go_mappings";
    private String currentSpecies = null;
    private String currentSpeciesType = null;
    private HashMap<String, String> goDomainMap;
    private HashMap<String, HashMap<String, String>> allSpeciesMap;
    private HashMap<String, ArrayList<String>> allSpecies;

    public GenePreferences() {
    }

    public GenePreferences(GenePreferences genePreferences) {
    }

    public Boolean getUseGeneMapping() {
        if (this.useGeneMapping == null) {
            this.useGeneMapping = true;
        }
        return this.useGeneMapping;
    }

    public void setUseGeneMapping(Boolean useGeneMapping) {
        this.useGeneMapping = useGeneMapping;
    }

    public Boolean getAutoUpdate() {
        if (this.autoUpdate == null) {
            this.autoUpdate = true;
        }
        return this.autoUpdate;
    }

    public void setAutoUpdate(Boolean autoUpdate) {
        this.autoUpdate = autoUpdate;
    }

    public boolean equals(GenePreferences genePreferences) {
        return this.getAutoUpdate().equals(genePreferences.getAutoUpdate());
    }

    public Integer getSelectedBackgroundSpecies() {
        return this.selectedBackgroundSpecies;
    }

    public void setSelectedBackgroundSpecies(Integer selectedBackgroundSpecies) {
        this.selectedBackgroundSpecies = selectedBackgroundSpecies;
    }

    public void setPreferencesFromSearchParameters(SearchParameters searchParameters) {
        File fastaFile = searchParameters.getFastaFile();
        if (fastaFile != null) {
            SpeciesFactory speciesFactory = SpeciesFactory.getInstance();
            try {
                FastaIndex fastaIndex = SequenceFactory.getFastaIndex(fastaFile, false, null);
                HashMap<String, Integer> speciesOccurrence = fastaIndex.getSpecies();
                Integer occurrenceMax = null;
                for (String uniprotTaxonomy : speciesOccurrence.keySet()) {
                    if (uniprotTaxonomy.equals("Unknown")) continue;
                    Integer occurrence = speciesOccurrence.get(uniprotTaxonomy);
                    if (occurrenceMax != null && occurrence <= occurrenceMax) continue;
                    occurrenceMax = occurrence;
                    try {
                        Integer taxon = speciesFactory.getUniprotTaxonomy().getId(uniprotTaxonomy, true);
                        if (taxon == null) continue;
                        this.setSelectedBackgroundSpecies(taxon);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String getShortDescription() {
        String newLine = System.getProperty("line.separator");
        StringBuilder output = new StringBuilder();
        output.append("Use Gene Mappings: ").append(this.getUseGeneMapping()).append(".").append(newLine);
        output.append("Update Gene Mappings: ").append(this.getAutoUpdate()).append(".").append(newLine);
        if (this.selectedBackgroundSpecies != null) {
            SpeciesFactory speciesFactory = SpeciesFactory.getInstance();
            String speciesName = speciesFactory.getName(this.selectedBackgroundSpecies);
            output.append("Species: ").append(speciesName).append(".").append(newLine);
        } else {
            output.append("Species: ").append("(not selected)").append(newLine);
        }
        return output.toString();
    }
}

