/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.preferences;

import com.compomics.util.preferences.ValidationQCPreferences;
import java.io.Serializable;

public class IdMatchValidationPreferences
implements Serializable {
    static final long serialVersionUID = 4327810348755338485L;
    private double defaultProteinFDR = 1.0;
    private double defaultPeptideFDR = 1.0;
    private double defaultPsmFDR = 1.0;
    private Boolean separatePeptides = true;
    private Boolean separatePsms = true;
    private Boolean mergeSmallSubgroups = true;
    private ValidationQCPreferences validationQCPreferences = new ValidationQCPreferences();

    public IdMatchValidationPreferences() {
    }

    public IdMatchValidationPreferences(IdMatchValidationPreferences idMatchValidationPreferences) {
        this.defaultProteinFDR = idMatchValidationPreferences.getDefaultProteinFDR();
        this.defaultPeptideFDR = idMatchValidationPreferences.getDefaultPeptideFDR();
        this.defaultPsmFDR = idMatchValidationPreferences.getDefaultPsmFDR();
        this.separatePeptides = idMatchValidationPreferences.getSeparatePeptides();
        this.separatePsms = idMatchValidationPreferences.getSeparatePsms();
        this.mergeSmallSubgroups = idMatchValidationPreferences.getMergeSmallSubgroups();
        this.validationQCPreferences = new ValidationQCPreferences(idMatchValidationPreferences.getValidationQCPreferences());
    }

    public double getDefaultProteinFDR() {
        return this.defaultProteinFDR;
    }

    public void setDefaultProteinFDR(double defaultProteinFDR) {
        this.defaultProteinFDR = defaultProteinFDR;
    }

    public double getDefaultPeptideFDR() {
        return this.defaultPeptideFDR;
    }

    public void setDefaultPeptideFDR(double defaultPeptideFDR) {
        this.defaultPeptideFDR = defaultPeptideFDR;
    }

    public double getDefaultPsmFDR() {
        return this.defaultPsmFDR;
    }

    public void setDefaultPsmFDR(double defaultPsmFDR) {
        this.defaultPsmFDR = defaultPsmFDR;
    }

    public ValidationQCPreferences getValidationQCPreferences() {
        return this.validationQCPreferences;
    }

    public void setValidationQCPreferences(ValidationQCPreferences validationQCPreferences) {
        this.validationQCPreferences = validationQCPreferences;
    }

    public Boolean getMergeSmallSubgroups() {
        if (this.mergeSmallSubgroups == null) {
            this.mergeSmallSubgroups = true;
        }
        return this.mergeSmallSubgroups;
    }

    public void setMergeSmallSubgroups(Boolean mergeSmallSubgroups) {
        this.mergeSmallSubgroups = mergeSmallSubgroups;
    }

    public Boolean getSeparatePeptides() {
        if (this.separatePeptides == null) {
            this.separatePeptides = true;
        }
        return this.separatePeptides;
    }

    public void setSeparatePeptides(Boolean separatePeptides) {
        this.separatePeptides = separatePeptides;
    }

    public Boolean getSeparatePsms() {
        if (this.separatePsms == null) {
            this.separatePsms = true;
        }
        return this.separatePsms;
    }

    public void setSeparatePsms(Boolean separatePsms) {
        this.separatePsms = separatePsms;
    }

    public String getShortDescription() {
        String newLine = System.getProperty("line.separator");
        StringBuilder output = new StringBuilder();
        output.append("Protein FDR: ").append(this.defaultProteinFDR).append(".").append(newLine);
        output.append("Peptide FDR: ").append(this.defaultPeptideFDR).append(".").append(newLine);
        output.append("PSM FDR: ").append(this.defaultPsmFDR).append(".").append(newLine);
        output.append("Group Small Subgroups: ").append(this.mergeSmallSubgroups).append(".").append(newLine);
        return output.toString();
    }

    public boolean equals(IdMatchValidationPreferences otherIdMatchValidationPreferences) {
        if (otherIdMatchValidationPreferences == null) {
            return false;
        }
        double diff = Math.abs(this.defaultProteinFDR - otherIdMatchValidationPreferences.getDefaultProteinFDR());
        if (diff > 1.0E-13) {
            return false;
        }
        diff = Math.abs(this.defaultPeptideFDR - otherIdMatchValidationPreferences.getDefaultPeptideFDR());
        if (diff > 1.0E-13) {
            return false;
        }
        diff = Math.abs(this.defaultPsmFDR - otherIdMatchValidationPreferences.getDefaultPsmFDR());
        if (diff > 1.0E-13) {
            return false;
        }
        if (this.separatePeptides.booleanValue() != otherIdMatchValidationPreferences.getSeparatePeptides().booleanValue()) {
            return false;
        }
        if (this.separatePsms.booleanValue() != otherIdMatchValidationPreferences.getSeparatePsms().booleanValue()) {
            return false;
        }
        if (this.mergeSmallSubgroups.booleanValue() != otherIdMatchValidationPreferences.getMergeSmallSubgroups().booleanValue()) {
            return false;
        }
        if (this.validationQCPreferences == null && otherIdMatchValidationPreferences.getValidationQCPreferences() != null || this.validationQCPreferences != null && otherIdMatchValidationPreferences.getValidationQCPreferences() == null) {
            return false;
        }
        return this.validationQCPreferences == null || otherIdMatchValidationPreferences.getValidationQCPreferences() == null || this.validationQCPreferences.isSameAs(otherIdMatchValidationPreferences.getValidationQCPreferences());
    }
}

