/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.pride;

import com.compomics.util.io.json.marshallers.PrideMarshaller;
import com.compomics.util.pride.prideobjects.webservice.PrideQuery;
import com.compomics.util.pride.prideobjects.webservice.query.PrideFilter;
import java.io.IOException;
import java.net.URL;
import uk.ac.ebi.pride.archive.web.service.model.assay.AssayDetail;
import uk.ac.ebi.pride.archive.web.service.model.assay.AssayDetailList;
import uk.ac.ebi.pride.archive.web.service.model.file.FileDetailList;
import uk.ac.ebi.pride.archive.web.service.model.peptide.PsmDetailList;
import uk.ac.ebi.pride.archive.web.service.model.project.ProjectDetail;
import uk.ac.ebi.pride.archive.web.service.model.project.ProjectSummaryList;
import uk.ac.ebi.pride.archive.web.service.model.protein.ProteinDetailList;

public class PrideWebService {
    private static final PrideMarshaller MARSHALLER = new PrideMarshaller();
    private static final int PAGE_SIZE = 1000;

    private static String getQueryURL(String queryRoot, String query, PrideFilter ... filters) {
        String queryURLAsString = queryRoot + "?";
        if (!query.isEmpty()) {
            queryURLAsString = queryURLAsString + "query=" + query;
        }
        if (filters != null && filters.length > 0) {
            for (PrideFilter aFilter : filters) {
                queryURLAsString = queryURLAsString + "&" + aFilter.getType().toString() + "=" + aFilter.getValue().replace(" ", "%20");
            }
        }
        System.out.println(queryURLAsString);
        return queryURLAsString;
    }

    private static int getCount(String query) throws IOException {
        return (Integer)MARSHALLER.fromJson(Integer.class, new URL(query.replace("list", "count")));
    }

    public static ProjectSummaryList getProjectSummaryList(String query, PrideFilter ... filters) throws IOException {
        ProjectSummaryList summaryList = new ProjectSummaryList();
        String projectListURL = PrideWebService.getQueryURL(PrideQuery.GET_PROJECTS_BY_CRITERIA.getQueryTemplate(false), query, filters);
        boolean moreResults = true;
        int page = 0;
        while (moreResults) {
            ProjectSummaryList subSummary = MARSHALLER.getProjectSummaryList(projectListURL + "&page=" + page);
            if (subSummary == null || subSummary.getList().isEmpty()) {
                moreResults = false;
            } else {
                summaryList.getList().addAll(subSummary.getList());
            }
            ++page;
        }
        return summaryList;
    }

    public static int getProjectCount(String query, PrideFilter ... filters) throws IOException {
        return PrideWebService.getCount(PrideWebService.getQueryURL(PrideQuery.GET_PROJECTS_BY_CRITERIA.getQueryTemplate(true), query, filters));
    }

    public static ProjectDetail getProjectDetail(String projectAccession) throws IOException {
        URL URL2 = new URL(PrideQuery.GET_PROJECT_BY_ACCESSION.getQueryTemplate(false).replace("{projectAccession}", projectAccession));
        return (ProjectDetail)MARSHALLER.fromJson(ProjectDetail.class, URL2);
    }

    public static AssayDetailList getAssayDetails(String projectAccession) throws IOException {
        String assayListURL = PrideQuery.GET_ASSAYS_BY_PROJECT.getQueryTemplate(false).replace("{projectAccession}", projectAccession);
        AssayDetailList assayDetails = MARSHALLER.getAssayDetailList(assayListURL);
        return assayDetails;
    }

    public static int getAssayCount(String projectAccession) throws IOException {
        return PrideWebService.getCount(PrideQuery.GET_ASSAYS_BY_PROJECT.getQueryTemplate(true).replace("{projectAccession}", projectAccession));
    }

    public static AssayDetail getAssayDetail(String assayAccession) throws IOException {
        URL URL2 = new URL(PrideQuery.GET_ASSAY_BY_ACCESSION.getQueryTemplate(false).replace("{assayAccession}", assayAccession));
        return (AssayDetail)MARSHALLER.fromJson(AssayDetail.class, URL2);
    }

    public static FileDetailList getProjectFileDetails(String projectAccession) throws IOException {
        String fileListURL = PrideQuery.GET_FILES_BY_PROJECT.getQueryTemplate(false).replace("{projectAccession}", projectAccession);
        FileDetailList files = MARSHALLER.getFileDetailList(fileListURL);
        return files;
    }

    public static int getProjectFileCount(String projectAccession) throws IOException {
        return PrideWebService.getCount(PrideQuery.GET_FILES_BY_PROJECT.getQueryTemplate(true).replace("{projectAccession}", projectAccession));
    }

    public static FileDetailList getAssayFileDetails(String assayAccession) throws IOException {
        String fileListURL = PrideQuery.GET_FILES_BY_ASAY.getQueryTemplate(false).replace("{assayAccession}", assayAccession);
        FileDetailList fileDetails = MARSHALLER.getFileDetailList(fileListURL);
        return fileDetails;
    }

    public static int getAssayFileCount(String assayAccession) throws IOException {
        return PrideWebService.getCount(PrideQuery.GET_FILES_BY_ASAY.getQueryTemplate(false).replace("{assayAccession}", assayAccession));
    }

    private static ProteinDetailList bufferProteinIdentifications(String queryURL) throws IOException {
        ProteinDetailList proteins = new ProteinDetailList();
        boolean moreResults = true;
        int page = 0;
        while (moreResults) {
            ProteinDetailList subList = MARSHALLER.getProteinDetailList(queryURL + "?show=" + 1000 + "&page=" + page);
            if (subList.getList().isEmpty()) {
                moreResults = false;
            } else {
                proteins.getList().addAll(subList.getList());
            }
            ++page;
        }
        return proteins;
    }

    public static ProteinDetailList getProteinIdentificationByProject(String projectAccession) throws IOException {
        String proteinIdentificationList = PrideQuery.GET_ALL_PROTEIN_IDENTIFICATIONS_BY_PROJECT.getQueryTemplate(false).replace("{projectAccession}", projectAccession);
        return PrideWebService.bufferProteinIdentifications(proteinIdentificationList);
    }

    public static int getProteinIdentificationCountByProject(String projectAccession) throws IOException {
        return PrideWebService.getCount(PrideQuery.GET_ALL_PROTEIN_IDENTIFICATIONS_BY_PROJECT.getQueryTemplate(true).replace("{projectAccession}", projectAccession));
    }

    public static ProteinDetailList getProteinIdentificationsByProjectAndProtein(String projectAccession, String proteinAccesion) throws IOException {
        String proteinIdentificationList = PrideQuery.GET_PROTEIN_IDENTIFICATION_BY_PROJECT.getQueryTemplate(false).replace("{projectAccession}", projectAccession).replace("{accession}", proteinAccesion);
        return MARSHALLER.getProteinDetailList(proteinIdentificationList);
    }

    public static int getProteinIdentificationsCountByProjectAndProtein(String projectAccession, String proteinAccession) throws IOException {
        String proteinIdentificationList = PrideQuery.GET_PROTEIN_IDENTIFICATION_BY_PROJECT.getQueryTemplate(true).replace("{projectAccession}", projectAccession).replace("{accession}", proteinAccession);
        return PrideWebService.getCount(proteinIdentificationList);
    }

    public static ProteinDetailList getProteinIdentificationByAssay(String assayAccession) throws IOException {
        String proteinIdentificationList = PrideQuery.GET_ALL_PROTEIN_IDENTIFICATIONS_BY_ASSAY.getQueryTemplate(false).replace("{assayAccession}", assayAccession);
        return MARSHALLER.getProteinDetailList(proteinIdentificationList);
    }

    public static int getProteinIdentificationCountByAssay(String assayAccession) throws IOException {
        String proteinIdentificationList = PrideQuery.GET_ALL_PROTEIN_IDENTIFICATIONS_BY_ASSAY.getQueryTemplate(true).replace("{assayAccession}", assayAccession);
        return PrideWebService.getCount(proteinIdentificationList);
    }

    private static PsmDetailList bufferPSMs(String queryURL) throws IOException {
        PsmDetailList psms = new PsmDetailList();
        boolean moreResults = true;
        int page = 0;
        while (moreResults) {
            PsmDetailList subList = MARSHALLER.getPeptideDetailList(queryURL + "?show=" + 1000 + "&page=" + page);
            if (subList.getList().isEmpty()) {
                moreResults = false;
            } else {
                psms.getList().addAll(subList.getList());
            }
            ++page;
        }
        return psms;
    }

    public static PsmDetailList getPSMsByProject(String projectAccession) throws IOException {
        String peptideIdentificationList = PrideQuery.GET_ALL_PEPTIDE_IDENTIFICATIONS_BY_PROJECT.getQueryTemplate(false).replace("{projectAccession}", projectAccession);
        return PrideWebService.bufferPSMs(peptideIdentificationList);
    }

    public static int getPSMCountByProject(String projectAccession) throws IOException {
        return PrideWebService.getCount(PrideQuery.GET_ALL_PEPTIDE_IDENTIFICATIONS_BY_PROJECT.getQueryTemplate(true).replace("{projectAccession}", projectAccession));
    }

    public static PsmDetailList getPSMsByProjectAndSequence(String projectAccession, String sequence) throws IOException {
        String peptideIdentificationList = PrideQuery.GET_ALL_PEPTIDE_IDENTIFICATIONS_BY_PROJECT_AND_SEQUENCE.getQueryTemplate(false).replace("{projectAccession}", projectAccession).replace("{peptideSequence}", sequence);
        return MARSHALLER.getPeptideDetailList(peptideIdentificationList);
    }

    public static int getPSMCountByProjectAndSequence(String projectAccession, String sequence) throws IOException {
        return PrideWebService.getCount(PrideQuery.GET_ALL_PEPTIDE_IDENTIFICATIONS_BY_PROJECT_AND_SEQUENCE.getQueryTemplate(true).replace("{projectAccession}", projectAccession).replace("{peptideSequence}", sequence));
    }

    public static PsmDetailList getPSMsByAssay(String assayAccession) throws IOException {
        String peptideIdentificationList = PrideQuery.GET_ALL_PEPTIDE_IDENTIFICATIONS_BY_ASSAY.getQueryTemplate(false).replace("{assayAccession}", assayAccession);
        return PrideWebService.bufferPSMs(peptideIdentificationList);
    }

    public static int getPSMCountByAssay(String assayAccession) throws IOException {
        return PrideWebService.getCount(PrideQuery.GET_ALL_PEPTIDE_IDENTIFICATIONS_BY_ASSAY.getQueryTemplate(false).replace("{assayAccession}", assayAccession));
    }

    public static PsmDetailList getPSMsByAssayAndSequence(String assayAccession, String sequence) throws IOException {
        String peptideIdentificationList = PrideQuery.GET_ALL_PEPTIDE_IDENTIFICATIONS_BY_ASSAY_AND_SEQUENCE.getQueryTemplate(false).replace("{assayAccession}", assayAccession).replace("{peptideSequence}", sequence);
        return MARSHALLER.getPeptideDetailList(peptideIdentificationList);
    }

    public static int getPSMCountByAssayAndSequence(String assayAccession, String sequence) throws IOException {
        return PrideWebService.getCount(PrideQuery.GET_ALL_PEPTIDE_IDENTIFICATIONS_BY_ASSAY_AND_SEQUENCE.getQueryTemplate(true).replace("{assayAccession}", assayAccession).replace("{peptideSequence}", sequence));
    }
}

