/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.pride.validation;

import com.compomics.util.pride.validation.XMLValidationErrorHandler;
import com.sun.msv.verifier.jarv.TheFactoryImpl;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import org.iso_relax.verifier.Schema;
import org.iso_relax.verifier.Verifier;
import org.iso_relax.verifier.VerifierConfigurationException;
import org.iso_relax.verifier.VerifierFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class PrideXmlValidator {
    public static final VerifierFactory VERIFIER_FACTORY = new TheFactoryImpl();
    private static Schema SCHEMA = null;
    private static final String SCHEMA_NAME = "pride.xsd";
    private XMLValidationErrorHandler xveh;
    private int maxErrorMessagesToDisplay = 10;

    public PrideXmlValidator() throws IOException, VerifierConfigurationException, SAXException {
        SCHEMA = VERIFIER_FACTORY.compileSchema(PrideXmlValidator.class.getClassLoader().getResourceAsStream(SCHEMA_NAME));
    }

    public PrideXmlValidator(URL schemaUrl) throws IOException, VerifierConfigurationException, SAXException {
        SCHEMA = VERIFIER_FACTORY.compileSchema(schemaUrl.openStream());
    }

    public void setSchema(URL schemaUrl) throws IOException, VerifierConfigurationException, SAXException {
        SCHEMA = VERIFIER_FACTORY.compileSchema(schemaUrl.openStream());
    }

    private XMLValidationErrorHandler validate(Reader reader, Schema schema) throws IOException, VerifierConfigurationException, SAXException {
        XMLValidationErrorHandler xmlValidationErrorHandler = new XMLValidationErrorHandler();
        Verifier schemaVerifier = schema.newVerifier();
        schemaVerifier.setErrorHandler((ErrorHandler)xmlValidationErrorHandler);
        try {
            schemaVerifier.verify(new InputSource(reader));
        }
        catch (SAXParseException e) {
            xmlValidationErrorHandler.error(e);
        }
        return xmlValidationErrorHandler;
    }

    private XMLValidationErrorHandler validate(Reader reader) throws IOException, VerifierConfigurationException, SAXException {
        if (SCHEMA == null) {
            SCHEMA = VERIFIER_FACTORY.compileSchema(PrideXmlValidator.class.getClassLoader().getResourceAsStream(SCHEMA_NAME));
        }
        return this.validate(reader, SCHEMA);
    }

    public boolean validate(File prideXmlFile) throws FileNotFoundException, IOException, VerifierConfigurationException, SAXException {
        PrideXmlValidator validator = new PrideXmlValidator();
        BufferedReader br = new BufferedReader(new FileReader(prideXmlFile));
        this.xveh = validator.validate(br);
        br.close();
        return this.xveh.noErrors();
    }

    public String getErrorsAsString() {
        if (this.xveh == null) {
            return "The file has not yet been validated!";
        }
        if (this.xveh.getErrorsAsList().isEmpty()) {
            return "There are no errors.";
        }
        if (this.xveh.getErrorsAsList().size() > this.maxErrorMessagesToDisplay) {
            System.out.println(this.xveh.getErrorsFormattedAsPlainText());
            return "The PRIDE XML file contains errors. See the tool's log file for details.\n\nPlease contact the developers.";
        }
        System.out.println(this.xveh.getErrorsFormattedAsPlainText());
        return "The PRIDE XML file contains errors:" + this.xveh.getErrorsFormattedAsPlainText() + "\n\nPlease contact the developers.";
    }

    public XMLValidationErrorHandler getErrors() {
        return this.xveh;
    }
}

