/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzscope.ionlibraries;

import fr.profi.mzscope.CalibrationIon;
import fr.profi.mzscope.ionlibraries.IonEntry;
import fr.profi.mzscope.ionlibraries.IonLibrary;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.analysis.interpolation.UnivariateInterpolator;
import org.apache.commons.math3.stat.regression.SimpleRegression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Aligner {
    private static final Logger logger = LoggerFactory.getLogger(Aligner.class);
    private final IonLibrary library;
    private double[] x;
    private double[] y;
    private UnivariateFunction interpolationFunction;
    private SimpleRegression regression;

    public Aligner(IonLibrary library) {
        this.library = library;
    }

    public IonLibrary getLibrary() {
        return this.library;
    }

    public boolean addCalibrationIon(CalibrationIon calibrationIon) {
        if (calibrationIon.getRT_observed() == null) {
            return false;
        }
        List<IonEntry> matchingSequenceEntries = this.library.getIonEntryBySequence(calibrationIon.getModification_sequence());
        if (matchingSequenceEntries == null || matchingSequenceEntries.isEmpty()) {
            logger.info("Sequence " + calibrationIon.getModification_sequence() + " not found in the library");
            return false;
        }
        for (IonEntry me : matchingSequenceEntries) {
            if (calibrationIon.getPrec_z() != me.getPrec_z().intValue()) continue;
            me.setRT_observed(calibrationIon.getRT_observed());
            return true;
        }
        return false;
    }

    public void align(UnivariateInterpolator interpolator) {
        ArrayList<IonEntry> controlPoints = new ArrayList<IonEntry>();
        ArrayList<Double> xValues = new ArrayList<Double>();
        ArrayList<Double> yValues = new ArrayList<Double>();
        IonEntry lastPoint = this.library.getEntries().get(0);
        for (IonEntry e : this.library.getEntries()) {
            if (e.getRT_observed() != null) {
                controlPoints.add(e);
            }
            if (!(e.getInitialRT() > lastPoint.getInitialRT())) continue;
            lastPoint = e;
        }
        Collections.sort(controlPoints, new Comparator<IonEntry>(){

            @Override
            public int compare(IonEntry o1, IonEntry o2) {
                return Double.compare(o1.getInitialRT(), o2.getInitialRT());
            }
        });
        IonEntry e1 = (IonEntry)controlPoints.get(0);
        IonEntry e2 = (IonEntry)controlPoints.get(1);
        double slope = 1.0 * (e2.getRT_observed() - e1.getRT_observed()) / (e2.getInitialRT() - e1.getInitialRT());
        double intercept = e1.getRT_observed() - slope * e1.getInitialRT();
        xValues.add(0.0);
        yValues.add(intercept);
        logger.info("first control point added at (0.0," + intercept + ")");
        for (IonEntry e : controlPoints) {
            xValues.add(e.getInitialRT());
            yValues.add(e.getRT_observed());
        }
        e1 = (IonEntry)controlPoints.get(controlPoints.size() - 2);
        e2 = (IonEntry)controlPoints.get(controlPoints.size() - 1);
        slope = 1.0 * (e2.getRT_observed() - e1.getRT_observed()) / (e2.getInitialRT() - e1.getInitialRT());
        intercept = e1.getRT_observed() - slope * e1.getInitialRT();
        xValues.add(lastPoint.getInitialRT());
        yValues.add(slope * lastPoint.getInitialRT() + intercept);
        logger.info("last control point added at (" + lastPoint.getInitialRT() + "," + (slope * lastPoint.getInitialRT() + intercept) + ")");
        this.x = ArrayUtils.toPrimitive((Double[])xValues.toArray(new Double[xValues.size()]));
        this.y = ArrayUtils.toPrimitive((Double[])yValues.toArray(new Double[yValues.size()]));
        this.interpolationFunction = interpolator.interpolate(this.x, this.y);
    }

    public List<IonEntry> predictRT() {
        for (IonEntry e : this.library.getEntries()) {
            try {
                double y = this.interpolationFunction.value(e.getInitialRT().doubleValue());
                e.setRT_predicted(y);
                e.setRT_delta(y - e.getInitialRT());
            }
            catch (Exception ex) {
                logger.error("RT interpolation fail", (Throwable)ex);
            }
        }
        return this.library.getEntries();
    }

    public List<IonEntry> applyPredictedRT() {
        for (IonEntry e : this.library.getEntries()) {
            e.setRT_detected(e.getRT_predicted());
        }
        return this.library.getEntries();
    }
}

