/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzscope.ui;

import fr.profi.mzscope.MSMSSpectrum;
import fr.profi.mzscope.Peak;
import fr.proline.mzscope.model.ExtractionRequest;
import fr.proline.mzscope.model.Spectrum;
import fr.proline.mzscope.ui.IMzScopeController;
import fr.proline.mzscope.ui.IRawFileViewer;
import fr.proline.mzscope.ui.model.MzScopePreferences;
import fr.proline.mzscope.utils.Display;
import fr.proline.studio.export.ExportButton;
import fr.proline.studio.extendedtablemodel.CompoundTableModel;
import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.filter.FilterButton;
import fr.proline.studio.filter.FilterTableModelInterface;
import fr.proline.studio.markerbar.MarkerComponentInterface;
import fr.proline.studio.markerbar.MarkerContainerPanel;
import fr.proline.studio.progress.ProgressInterface;
import fr.proline.studio.table.BeanTableModel;
import fr.proline.studio.table.DecoratedMarkerTable;
import fr.proline.studio.table.TablePopupMenu;
import fr.proline.studio.utils.StudioResourceBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MGFPanel
extends JPanel {
    private static final Logger logger = LoggerFactory.getLogger(MGFPanel.class);
    protected final CompoundTableModel peaksTableModel = new CompoundTableModel((GlobalTableModelInterface)new BeanTableModel(Peak.class), true);
    protected final CompoundTableModel spectrumTableModel = new CompoundTableModel((GlobalTableModelInterface)new BeanTableModel(MSMSSpectrum.class), true);
    protected MarkerContainerPanel peaksMarkerContainerPanel;
    protected MarkerContainerPanel spectrumMarkerContainerPanel;
    protected final IMzScopeController appController;
    protected DecoratedMarkerTable peaksTable;
    protected DecoratedMarkerTable spectrumTable;
    protected JTabbedPane libraryTabbedPane;
    protected JPanel tablePane;
    protected JToolBar tableToolbar;

    public MGFPanel(List<MSMSSpectrum> spectrum, IMzScopeController appController) {
        this.appController = appController;
        this.initComponents();
        this.spectrumMarkerContainerPanel.setMaxLineNumber(spectrum.size());
        ((BeanTableModel)this.spectrumTableModel.getBaseModel()).setData(spectrum);
    }

    private void initComponents() {
        JToolBar panelToolBar = this.getToolbar();
        this.tableToolbar = new JToolBar();
        JSplitPane jSplitPane1 = new JSplitPane();
        this.libraryTabbedPane = new JTabbedPane();
        this.tablePane = new JPanel();
        this.tableToolbar.setFloatable(false);
        this.tableToolbar.setOrientation(1);
        this.tableToolbar.setRollover(true);
        jSplitPane1.setDividerLocation(130);
        jSplitPane1.setLeftComponent(this.libraryTabbedPane);
        this.tablePane.setLayout(new BorderLayout());
        jSplitPane1.setRightComponent(this.tablePane);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jSplitPane1).addComponent(panelToolBar, -1, 380, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(panelToolBar, -2, 26, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jSplitPane1, -1, 217, Short.MAX_VALUE).addContainerGap()));
        this.initCustomComponents();
    }

    protected JToolBar getToolbar() {
        JToolBar jToolBar1 = new JToolBar();
        JButton extractBtn = new JButton();
        JButton displayBtn = new JButton();
        jToolBar1.setFloatable(false);
        jToolBar1.setRollover(true);
        extractBtn.setText(StudioResourceBundle.getMessage(MGFPanel.class, (String)"MGFPanel.extractBtn.text"));
        extractBtn.setToolTipText(StudioResourceBundle.getMessage(MGFPanel.class, (String)"MGFPanel.extractBtn.tooltip"));
        extractBtn.setFocusable(false);
        extractBtn.setHorizontalTextPosition(0);
        extractBtn.setVerticalTextPosition(3);
        extractBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MGFPanel.this.extractBtnActionPerformed(evt);
            }
        });
        jToolBar1.add(extractBtn);
        displayBtn.setText(StudioResourceBundle.getMessage(MGFPanel.class, (String)"MGFPanel.displayBtn.text"));
        displayBtn.setToolTipText(StudioResourceBundle.getMessage(MGFPanel.class, (String)"MGFPanel.displayBtn.tooltip"));
        displayBtn.setFocusable(false);
        displayBtn.setHorizontalTextPosition(0);
        displayBtn.setVerticalTextPosition(3);
        displayBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MGFPanel.this.displayBtnActionPerformed(evt);
            }
        });
        jToolBar1.add(displayBtn);
        return jToolBar1;
    }

    protected void displayBtnActionPerformed(ActionEvent evt) {
        int selectedRow = this.spectrumTable.convertRowIndexToNonFilteredModel(this.spectrumTable.getSelectedRow());
        if (selectedRow >= 0) {
            MSMSSpectrum spectrum = (MSMSSpectrum)((BeanTableModel)this.spectrumTableModel.getBaseModel()).getData().get(selectedRow);
            IRawFileViewer viewer = this.appController.getCurrentRawFileViewer();
            double[] intensities = spectrum.getIntensityValues();
            float[] fIntensities = new float[intensities.length];
            for (int k = 0; k < intensities.length; ++k) {
                fIntensities[k] = (float)intensities[k];
            }
            Spectrum mzScopeSpectrum = new Spectrum(Integer.valueOf(-1), (float)spectrum.getRetentionTime(), spectrum.getMassValues(), fIntensities, 1, Spectrum.ScanType.CENTROID);
            double maxMgfIntensity = Arrays.stream(intensities).max().getAsDouble();
            float[] currentIntensities = viewer.getCurrentSpectrum().getIntensities();
            double maxCurrentIntensity = IntStream.range(0, currentIntensities.length).mapToDouble(i -> currentIntensities[i]).max().getAsDouble();
            viewer.setReferenceSpectrum(mzScopeSpectrum, Float.valueOf((float)(-maxCurrentIntensity / maxMgfIntensity)));
        }
    }

    protected void extractBtnActionPerformed(ActionEvent evt) {
        IRawFileViewer viewer = this.appController.getCurrentRawFileViewer();
        String identifier = new Timestamp(System.currentTimeMillis()).toString();
        Display display = new Display(Display.Mode.SERIES, identifier);
        int selectedRow = this.spectrumTable.convertRowIndexToNonFilteredModel(this.spectrumTable.getSelectedRow());
        if (selectedRow >= 0) {
            MSMSSpectrum spectrum = (MSMSSpectrum)((BeanTableModel)this.spectrumTableModel.getBaseModel()).getData().get(selectedRow);
            ExtractionRequest.Builder builder = ExtractionRequest.builder((Object)this);
            builder.setMzTolPPM(MzScopePreferences.getInstance().getMzPPMTolerance()).setMz(spectrum.getPrecursorMz());
            viewer.extractAndDisplay(builder.build(), display, null);
        }
        if (viewer.getCurrentRawfile().isDIAFile()) {
            int[] selectedRows = this.peaksTable.getSelectedRows();
            List entries = ((BeanTableModel)this.peaksTableModel.getBaseModel()).getData();
            if (selectedRows.length > 0) {
                for (int k = 0; k < selectedRows.length; ++k) {
                    Peak peak = (Peak)entries.get(this.peaksTable.convertRowIndexToNonFilteredModel(selectedRows[k]));
                    ExtractionRequest.Builder builder = ExtractionRequest.builder((Object)this);
                    builder.setMzTolPPM(MzScopePreferences.getInstance().getMzPPMTolerance());
                    builder.setMz(peak.getSpectrum().getPrecursorMz()).setFragmentMz(peak.getMz()).setFragmentMzTolPPM(MzScopePreferences.getInstance().getFragmentMzPPMTolerance());
                    viewer.extractAndDisplay(builder.build(), display, null);
                }
            }
        }
    }

    private void initCustomComponents() {
        JScrollPane peaksScrollPane = new JScrollPane();
        this.peaksTable = new DecoratedMarkerTable(){

            public TablePopupMenu initPopupMenu() {
                return new TablePopupMenu();
            }

            public void prepostPopupMenu() {
            }

            public void addTableModelListener(TableModelListener l) {
                this.getModel().addTableModelListener(l);
            }
        };
        this.peaksTable.setModel((TableModel)this.peaksTableModel);
        this.peaksTable.getColumnExt((Object)"charge").setVisible(false);
        this.peaksTable.getColumnExt((Object)"spectrum").setVisible(false);
        peaksScrollPane.setViewportView((Component)this.peaksTable);
        this.peaksTable.setFillsViewportHeight(true);
        this.peaksTable.setViewport(peaksScrollPane.getViewport());
        ExportButton exportButton = new ExportButton((ProgressInterface)this.peaksTableModel, "Export", (JXTable)this.peaksTable);
        this.tableToolbar.add((Component)exportButton);
        FilterButton filterButton = new FilterButton((FilterTableModelInterface)this.peaksTableModel){

            protected void filteringDone() {
            }
        };
        this.tableToolbar.add((Component)filterButton);
        this.peaksMarkerContainerPanel = new MarkerContainerPanel(peaksScrollPane, (MarkerComponentInterface)this.peaksTable);
        JLabel label = new JLabel("Fragments");
        label.setBorder(new EmptyBorder(3, 10, 5, 10));
        this.tablePane.add((Component)label, "North");
        this.tablePane.add((Component)this.tableToolbar, "West");
        this.tablePane.add((Component)this.peaksMarkerContainerPanel, "Center");
        JScrollPane spectrumScrollPane = new JScrollPane();
        this.spectrumTable = new DecoratedMarkerTable(){

            public TablePopupMenu initPopupMenu() {
                return new TablePopupMenu();
            }

            public void prepostPopupMenu() {
            }

            public void addTableModelListener(TableModelListener l) {
                this.getModel().addTableModelListener(l);
            }

            public void valueChanged(ListSelectionEvent e) {
                super.valueChanged(e);
                int selectedRow = this.convertRowIndexToNonFilteredModel(this.getSelectedRow());
                if (selectedRow >= 0) {
                    List spectrum = ((BeanTableModel)MGFPanel.this.spectrumTableModel.getBaseModel()).getData();
                    ((BeanTableModel)MGFPanel.this.peaksTableModel.getBaseModel()).setData(((MSMSSpectrum)spectrum.get(selectedRow)).getPeaks());
                }
            }
        };
        this.spectrumTable.setModel((TableModel)this.spectrumTableModel);
        this.spectrumTable.getColumnExt((Object)"annotations").setVisible(false);
        this.spectrumTable.getColumnExt((Object)"peaks").setVisible(false);
        this.spectrumTable.getColumnExt((Object)"massValues").setVisible(false);
        this.spectrumTable.getColumnExt((Object)"intensityValues").setVisible(false);
        spectrumScrollPane.setViewportView((Component)this.spectrumTable);
        this.spectrumTable.setFillsViewportHeight(true);
        this.spectrumTable.setViewport(spectrumScrollPane.getViewport());
        this.spectrumMarkerContainerPanel = new MarkerContainerPanel(spectrumScrollPane, (MarkerComponentInterface)this.spectrumTable);
        this.libraryTabbedPane.add("Precursor list", (Component)this.spectrumMarkerContainerPanel);
    }
}

