/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.array;

import org.ojalgo.array.DenseArray;
import org.ojalgo.array.PlainArray;
import org.ojalgo.array.ScalarArray;
import org.ojalgo.function.FunctionSet;
import org.ojalgo.function.QuadrupleFunction;
import org.ojalgo.function.aggregator.AggregatorSet;
import org.ojalgo.function.aggregator.QuadrupleAggregator;
import org.ojalgo.scalar.Quadruple;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.type.math.MathType;

public class ArrayR128
extends ScalarArray<Quadruple> {
    public static final DenseArray.Factory<Quadruple> FACTORY = new DenseArray.Factory<Quadruple>(){

        @Override
        public AggregatorSet<Quadruple> aggregator() {
            return QuadrupleAggregator.getSet();
        }

        @Override
        public FunctionSet<Quadruple> function() {
            return QuadrupleFunction.getSet();
        }

        @Override
        public Scalar.Factory<Quadruple> scalar() {
            return Quadruple.FACTORY;
        }

        @Override
        public MathType getMathType() {
            return MathType.R128;
        }

        @Override
        PlainArray<Quadruple> makeDenseArray(long size) {
            return ArrayR128.make((int)size);
        }
    };

    public static ArrayR128 make(int size) {
        return new ArrayR128(size);
    }

    public static ArrayR128 wrap(Quadruple ... data) {
        return new ArrayR128(data);
    }

    protected ArrayR128(int size) {
        super(FACTORY, size);
    }

    protected ArrayR128(Quadruple[] data) {
        super(FACTORY, (Scalar[])data);
    }
}

