/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.array;

import org.ojalgo.array.ArrayFactory;
import org.ojalgo.array.BasicArray;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Factory1D;
import org.ojalgo.structure.StructureAnyD;

public abstract class DenseArray<N extends Comparable<N>>
extends BasicArray<N> {
    @Deprecated
    public static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;

    protected DenseArray(Factory<N> factory) {
        super(factory);
    }

    abstract void modify(long var1, int var3, Access1D<N> var4, BinaryFunction<N> var5);

    abstract void modify(long var1, int var3, BinaryFunction<N> var4, Access1D<N> var5);

    abstract void modify(long var1, int var3, UnaryFunction<N> var4);

    public static abstract class Factory<N extends Comparable<N>>
    extends ArrayFactory<N, DenseArray<N>>
    implements Factory1D.Dense<DenseArray<N>> {
        @Override
        long getCapacityLimit() {
            return 0x7FFFFFF7L;
        }

        final long getElementSize() {
            return this.getMathType().getTotalMemory();
        }

        abstract DenseArray<N> makeDenseArray(long var1);

        @Override
        final DenseArray<N> makeStructuredZero(long ... structure) {
            long total = StructureAnyD.count(structure);
            if (total > this.getCapacityLimit()) {
                throw new IllegalArgumentException();
            }
            return this.makeDenseArray(total);
        }

        @Override
        final DenseArray<N> makeToBeFilled(long ... structure) {
            long total = StructureAnyD.count(structure);
            if (total > this.getCapacityLimit()) {
                throw new IllegalArgumentException();
            }
            return this.makeDenseArray(total);
        }
    }
}

