/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.array;

import org.ojalgo.array.OffHeapArray;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.type.NativeMemory;

final class OffHeapR032
extends OffHeapArray {
    private final long myPointer;

    OffHeapR032(long count) {
        super(OffHeapArray.R032, count);
        this.myPointer = NativeMemory.allocateFloatArray(this, count);
    }

    @Override
    public void add(long index, Comparable<?> addend) {
        this.add(index, Scalar.floatValue(addend));
    }

    @Override
    public double doubleValue(long index) {
        return NativeMemory.getFloat(this.myPointer, index);
    }

    @Override
    public float floatValue(long index) {
        return NativeMemory.getFloat(this.myPointer, index);
    }

    @Override
    public void reset() {
        NativeMemory.initialiseFloatArray(this.myPointer, this.count());
    }

    @Override
    public void set(long index, Comparable<?> value) {
        this.set(index, Scalar.floatValue(value));
    }

    @Override
    public void set(long index, double value) {
        NativeMemory.setFloat(this.myPointer, index, (float)value);
    }

    @Override
    public void set(long index, float value) {
        NativeMemory.setFloat(this.myPointer, index, value);
    }
}

