/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.array.operation;

import java.lang.reflect.Array;
import org.ojalgo.array.operation.ArrayOperation;
import org.ojalgo.structure.Access2D;

public abstract class COPY
implements ArrayOperation {
    public static int THRESHOLD = 128;

    public static void column(Access2D<?> source, long col, double[] destination, int first, int limit) {
        for (int i = first; i < limit; ++i) {
            destination[i] = source.doubleValue(i, col);
        }
    }

    public static double[] copyOf(double[] original) {
        int tmpLength = original.length;
        double[] retVal = new double[tmpLength];
        System.arraycopy(original, 0, retVal, 0, tmpLength);
        return retVal;
    }

    public static float[] copyOf(float[] original) {
        int tmpLength = original.length;
        float[] retVal = new float[tmpLength];
        System.arraycopy(original, 0, retVal, 0, tmpLength);
        return retVal;
    }

    public static int[] copyOf(int[] original) {
        int tmpLength = original.length;
        int[] retVal = new int[tmpLength];
        System.arraycopy(original, 0, retVal, 0, tmpLength);
        return retVal;
    }

    public static long[] copyOf(long[] original) {
        int tmpLength = original.length;
        long[] retVal = new long[tmpLength];
        System.arraycopy(original, 0, retVal, 0, tmpLength);
        return retVal;
    }

    public static <T> T[] copyOf(T[] original) {
        int tmpLength = original.length;
        Object[] retVal = (Object[])Array.newInstance(original.getClass().getComponentType(), tmpLength);
        System.arraycopy(original, 0, retVal, 0, tmpLength);
        return retVal;
    }

    public static int[] invoke(int[] source, int[] destination) {
        int limit = Math.min(source.length, destination.length);
        System.arraycopy(source, 0, destination, 0, limit);
        return destination;
    }

    public static void row(Access2D<?> source, long row, double[] destination, int first, int limit) {
        for (int j = first; j < limit; ++j) {
            destination[j] = source.doubleValue(row, j);
        }
    }
}

