/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.array.operation;

import org.ojalgo.array.operation.ArrayOperation;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.matrix.transformation.Householder;
import org.ojalgo.scalar.PrimitiveScalar;
import org.ojalgo.scalar.Scalar;

public abstract class GenerateApplyAndCopyHouseholderColumn
implements ArrayOperation {
    public static int THRESHOLD = 128;

    public static boolean invoke(double[] data, int structure, int row, int col, Householder.Primitive64 destination) {
        int tmpColBase = col * structure;
        double[] tmpVector = destination.vector;
        destination.first = row;
        double tmpNormInf = PrimitiveMath.ZERO;
        for (int i = row; i < structure; ++i) {
            tmpVector[i] = data[i + tmpColBase];
            tmpNormInf = Math.max(tmpNormInf, PrimitiveMath.ABS.invoke(tmpVector[i]));
        }
        boolean retVal = tmpNormInf != PrimitiveMath.ZERO;
        double tmpNorm2 = PrimitiveMath.ZERO;
        if (retVal) {
            int i = row + 1;
            while (i < structure) {
                int n = i++;
                double d = tmpVector[n] / tmpNormInf;
                tmpVector[n] = d;
                double tmpVal = d;
                tmpNorm2 += tmpVal * tmpVal;
            }
            boolean bl = retVal = !PrimitiveScalar.isSmall(PrimitiveMath.ONE, tmpNorm2);
        }
        if (retVal) {
            double tmpScale = tmpVector[row] / tmpNormInf;
            tmpNorm2 += tmpScale * tmpScale;
            tmpNorm2 = PrimitiveMath.SQRT.invoke(tmpNorm2);
            if (tmpScale <= PrimitiveMath.ZERO) {
                data[row + tmpColBase] = tmpNorm2 * tmpNormInf;
                tmpScale -= tmpNorm2;
            } else {
                data[row + tmpColBase] = -tmpNorm2 * tmpNormInf;
                tmpScale += tmpNorm2;
            }
            tmpVector[row] = PrimitiveMath.ONE;
            for (int i = row + 1; i < structure; ++i) {
                int n = i;
                double d = tmpVector[n] / tmpScale;
                tmpVector[n] = d;
                data[i + tmpColBase] = d;
            }
            destination.beta = PrimitiveMath.ABS.invoke(tmpScale) / tmpNorm2;
        }
        return retVal;
    }

    public static boolean invoke(float[] data, int structure, int row, int col, Householder.Primitive32 destination) {
        int tmpColBase = col * structure;
        float[] tmpVector = destination.vector;
        destination.first = row;
        double tmpNormInf = PrimitiveMath.ZERO;
        for (int i = row; i < structure; ++i) {
            tmpVector[i] = data[i + tmpColBase];
            tmpNormInf = PrimitiveMath.MAX.invoke(tmpNormInf, (double)PrimitiveMath.ABS.invoke(tmpVector[i]));
        }
        boolean retVal = tmpNormInf != PrimitiveMath.ZERO;
        double tmpNorm2 = PrimitiveMath.ZERO;
        if (retVal) {
            int i = row + 1;
            while (i < structure) {
                int n = i++;
                float f = (float)((double)tmpVector[n] / tmpNormInf);
                tmpVector[n] = f;
                double tmpVal = f;
                tmpNorm2 += tmpVal * tmpVal;
            }
            boolean bl = retVal = !PrimitiveScalar.isSmall(PrimitiveMath.ONE, tmpNorm2);
        }
        if (retVal) {
            double tmpScale = (double)tmpVector[row] / tmpNormInf;
            tmpNorm2 += tmpScale * tmpScale;
            tmpNorm2 = PrimitiveMath.SQRT.invoke(tmpNorm2);
            if (tmpScale <= PrimitiveMath.ZERO) {
                data[row + tmpColBase] = (float)(tmpNorm2 * tmpNormInf);
                tmpScale -= tmpNorm2;
            } else {
                data[row + tmpColBase] = (float)(-tmpNorm2 * tmpNormInf);
                tmpScale += tmpNorm2;
            }
            tmpVector[row] = (float)PrimitiveMath.ONE;
            for (int i = row + 1; i < structure; ++i) {
                int n = i;
                float f = (float)((double)tmpVector[n] / tmpScale);
                tmpVector[n] = f;
                data[i + tmpColBase] = f;
            }
            destination.beta = (float)(PrimitiveMath.ABS.invoke(tmpScale) / tmpNorm2);
        }
        return retVal;
    }

    public static <N extends Scalar<N>> boolean invoke(N[] data, int structure, int row, int col, Householder.Generic<N> destination, Scalar.Factory<N> scalar) {
        int tmpColBase = col * structure;
        N[] tmpVector = destination.vector;
        destination.first = row;
        double tmpNormInf = PrimitiveMath.ZERO;
        for (int i = row; i < structure; ++i) {
            tmpVector[i] = data[i + tmpColBase];
            tmpNormInf = PrimitiveMath.MAX.invoke(tmpNormInf, tmpVector[i].norm());
        }
        boolean retVal = tmpNormInf != PrimitiveMath.ZERO;
        double tmpNorm2 = PrimitiveMath.ZERO;
        if (retVal) {
            for (int i = row + 1; i < structure; ++i) {
                Scalar tmpVal = (Scalar)tmpVector[i].divide(tmpNormInf);
                tmpNorm2 += tmpVal.norm() * tmpVal.norm();
                tmpVector[i] = (Scalar)tmpVal.get();
            }
            boolean bl = retVal = !PrimitiveScalar.isSmall(PrimitiveMath.ONE, tmpNorm2);
        }
        if (retVal) {
            Scalar tmpScale = (Scalar)tmpVector[row].divide(tmpNormInf);
            tmpNorm2 += tmpScale.norm() * tmpScale.norm();
            tmpNorm2 = PrimitiveMath.SQRT.invoke(tmpNorm2);
            data[row + col * structure] = (Scalar)((Scalar)((Scalar)tmpScale.signum()).multiply(tmpNorm2 * tmpNormInf)).get();
            tmpScale = (Scalar)tmpScale.subtract((Scalar)((Scalar)tmpScale.signum()).multiply(tmpNorm2)).get();
            tmpVector[row] = (Scalar)scalar.one().get();
            for (int i = row + 1; i < structure; ++i) {
                tmpVector[i] = (Scalar)tmpVector[i].divide(tmpScale).get();
                data[i + tmpColBase] = tmpVector[i];
            }
            destination.beta = (Scalar)scalar.cast(tmpScale.norm() / tmpNorm2);
        }
        return retVal;
    }
}

