/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.data.domain.finance.portfolio;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.ojalgo.ProgrammingError;
import org.ojalgo.data.domain.finance.portfolio.EquilibriumModel;
import org.ojalgo.data.domain.finance.portfolio.FinancePortfolio;
import org.ojalgo.data.domain.finance.portfolio.MarketEquilibrium;
import org.ojalgo.function.constant.BigMath;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.matrix.MatrixR064;
import org.ojalgo.scalar.BigScalar;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.structure.Access2D;
import org.ojalgo.type.TypeUtils;

public final class BlackLittermanModel
extends EquilibriumModel {
    private BigDecimal myConfidence = BigMath.ONE;
    private final MatrixR064 myOriginalWeights;
    private final List<FinancePortfolio> myViews;

    public BlackLittermanModel(FinancePortfolio.Context context, FinancePortfolio originalWeights) {
        super(context);
        this.myOriginalWeights = (MatrixR064)MATRIX_FACTORY.columns(new List[]{originalWeights.getWeights()});
        this.myViews = new ArrayList<FinancePortfolio>();
    }

    public BlackLittermanModel(MarketEquilibrium marketEquilibrium, MatrixR064 originalWeights) {
        super(marketEquilibrium);
        this.myOriginalWeights = originalWeights;
        this.myViews = new ArrayList<FinancePortfolio>();
    }

    private BlackLittermanModel(MarketEquilibrium aMarketEquilibrium) {
        super(aMarketEquilibrium);
        this.myOriginalWeights = null;
        this.myViews = null;
        ProgrammingError.throwForIllegalInvocation();
    }

    public void addView(FinancePortfolio aView) {
        this.myViews.add(aView);
    }

    public void addViewWithBalancedConfidence(List<BigDecimal> someWeights, Comparable<?> aReturn) {
        View tmpView = new View(this, someWeights);
        tmpView.setMeanReturn(TypeUtils.toBigDecimal(aReturn));
        tmpView.setReturnVariance(null);
        tmpView.setScale(null);
        this.myViews.add(tmpView);
    }

    public void addViewWithScaledConfidence(List<BigDecimal> someWeights, Comparable<?> aReturn, Comparable<?> aScale) {
        View tmpView = new View(this, someWeights);
        tmpView.setMeanReturn(TypeUtils.toBigDecimal(aReturn));
        tmpView.setReturnVariance(null);
        tmpView.setScale(TypeUtils.toBigDecimal(aScale));
        this.myViews.add(tmpView);
    }

    @Deprecated
    public void addViewWithStandardDeviation(List<BigDecimal> someWeights, BigDecimal aReturn, BigDecimal aStdDev) {
        View tmpView = new View(this, someWeights);
        tmpView.setMeanReturn(aReturn);
        tmpView.setReturnVariance(aStdDev.multiply(aStdDev));
        tmpView.setScale(null);
        this.myViews.add(tmpView);
    }

    public Scalar<?> getConfidence() {
        return BigScalar.of(this.myConfidence);
    }

    public void setConfidence(Comparable<?> aWeight) {
        this.myConfidence = TypeUtils.toBigDecimal(aWeight);
    }

    @Override
    protected MatrixR064 calculateAssetReturns() {
        return this.calculateAssetReturns(this.calculateAssetWeights());
    }

    @Override
    protected MatrixR064 calculateAssetWeights() {
        MatrixR064 tmpViewPortfolios = this.getViewPortfolios();
        MatrixR064 tmpViewReturns = this.getViewReturns();
        MatrixR064 tmpViewVariances = this.getViewVariances();
        MatrixR064 tmpCovariances = this.getCovariances();
        MatrixR064 tmpRightParenthesis = (MatrixR064)tmpViewReturns.subtract((MatrixR064)((MatrixR064)tmpViewPortfolios.multiply(tmpCovariances)).multiply(this.myOriginalWeights));
        MatrixR064 tmpViewsTransposed = (MatrixR064)tmpViewPortfolios.transpose();
        MatrixR064 tmpLeftParenthesis = (MatrixR064)tmpViewVariances.add((MatrixR064)((MatrixR064)tmpViewPortfolios.multiply(tmpCovariances)).multiply(tmpViewsTransposed));
        return (MatrixR064)this.myOriginalWeights.add((MatrixR064)tmpViewsTransposed.multiply((MatrixR064)tmpLeftParenthesis.solve((Access2D)tmpRightParenthesis)));
    }

    protected MatrixR064 getOriginalReturns() {
        return this.calculateAssetReturns(this.myOriginalWeights);
    }

    protected MatrixR064 getOriginalWeights() {
        return this.myOriginalWeights;
    }

    protected MatrixR064 getViewPortfolios() {
        int tmpRowDim = this.myViews.size();
        int tmpColDim = (int)this.myOriginalWeights.count();
        MatrixR064.DenseReceiver retVal = (MatrixR064.DenseReceiver)MATRIX_FACTORY.makeDense(tmpRowDim, tmpColDim);
        for (int i = 0; i < tmpRowDim; ++i) {
            FinancePortfolio tmpView = this.myViews.get(i);
            List<BigDecimal> tmpWeights = tmpView.getWeights();
            for (int j = 0; j < tmpColDim; ++j) {
                retVal.set((long)i, (long)j, (Comparable)tmpWeights.get(j));
            }
        }
        return (MatrixR064)retVal.get();
    }

    protected MatrixR064 getViewReturns() {
        int tmpRowDim = this.myViews.size();
        boolean tmpColDim = true;
        MatrixR064.DenseReceiver retVal = (MatrixR064.DenseReceiver)MATRIX_FACTORY.makeDense(tmpRowDim, 1L);
        double tmpRAF = this.getRiskAversion().doubleValue();
        for (int i = 0; i < tmpRowDim; ++i) {
            double tmpRet = this.myViews.get(i).getMeanReturn();
            retVal.set((long)i, 0L, PrimitiveMath.DIVIDE.invoke(tmpRet, tmpRAF));
        }
        return (MatrixR064)retVal.get();
    }

    protected List<FinancePortfolio> getViews() {
        return this.myViews;
    }

    protected MatrixR064 getViewVariances() {
        int tmpDim = this.myViews.size();
        MatrixR064.DenseReceiver retVal = (MatrixR064.DenseReceiver)MATRIX_FACTORY.makeDense(tmpDim, tmpDim);
        if (this.myConfidence.compareTo(BigMath.ONE) == 0) {
            for (int ij = 0; ij < tmpDim; ++ij) {
                retVal.set((long)ij, (long)ij, this.myViews.get(ij).getReturnVariance());
            }
        } else {
            double tmpScale = this.myConfidence.doubleValue();
            for (int ij = 0; ij < tmpDim; ++ij) {
                double tmpVar = this.myViews.get(ij).getReturnVariance();
                retVal.set((long)ij, (long)ij, PrimitiveMath.DIVIDE.invoke(tmpVar, tmpScale));
            }
        }
        return (MatrixR064)retVal.get();
    }

    BigDecimal calculateVariance(MatrixR064 weights) {
        MatrixR064 tmpVal = this.getCovariances();
        tmpVal = (MatrixR064)tmpVal.multiply(weights);
        return TypeUtils.toBigDecimal(((MatrixR064)((MatrixR064)weights.transpose()).multiply(tmpVal)).get(0L, 0L));
    }

    private static final class View
    extends FinancePortfolio {
        private BigDecimal myMeanReturn = BigMath.ZERO;
        private final BlackLittermanModel myModel;
        private BigDecimal myReturnVariance = null;
        private BigDecimal myScale = null;
        private final List<BigDecimal> myWeights;

        public View(BlackLittermanModel aModel, List<BigDecimal> someWeights) {
            this.myModel = aModel;
            this.myWeights = someWeights;
        }

        private View() {
            this.myModel = null;
            this.myWeights = null;
            ProgrammingError.throwForIllegalInvocation();
        }

        @Override
        public double getMeanReturn() {
            if (this.myMeanReturn != null) {
                return this.myMeanReturn.doubleValue();
            }
            return PrimitiveMath.ZERO;
        }

        @Override
        public double getReturnVariance() {
            if (this.myReturnVariance != null) {
                return this.myReturnVariance.doubleValue();
            }
            MatrixR064 tmpWeights = (MatrixR064)MATRIX_FACTORY.columns(new List[]{this.myWeights});
            BigDecimal retVal = this.myModel.calculateVariance(tmpWeights);
            retVal = this.myScale != null ? retVal.multiply(this.myScale) : retVal.multiply(this.myModel.getConfidence().toBigDecimal());
            return retVal.doubleValue();
        }

        @Override
        public List<BigDecimal> getWeights() {
            return this.myWeights;
        }

        @Override
        protected void reset() {
        }

        protected void setMeanReturn(BigDecimal aMeanReturn) {
            this.myMeanReturn = aMeanReturn;
        }

        protected void setReturnVariance(BigDecimal aReturnVariance) {
            this.myReturnVariance = aReturnVariance;
        }

        protected void setScale(BigDecimal aScale) {
            this.myScale = aScale;
        }
    }
}

