/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.data.domain.finance.portfolio;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import org.ojalgo.data.domain.finance.portfolio.FinancePortfolio;
import org.ojalgo.function.constant.BigMath;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.type.TypeUtils;

public final class SimpleAsset
extends FinancePortfolio {
    private final double myMeanReturn;
    private final double myVolatility;
    private final BigDecimal myWeight;

    public SimpleAsset(FinancePortfolio portfolio) {
        this(Double.valueOf(portfolio.getMeanReturn()), Double.valueOf(portfolio.getVolatility()), BigMath.ONE);
    }

    public SimpleAsset(FinancePortfolio portfolio, Comparable<?> weight) {
        this(Double.valueOf(portfolio.getMeanReturn()), Double.valueOf(portfolio.getVolatility()), weight);
    }

    public SimpleAsset(Comparable<?> weight) {
        this(Double.valueOf(PrimitiveMath.ZERO), Double.valueOf(PrimitiveMath.ZERO), weight);
    }

    public SimpleAsset(Comparable<?> meanReturn, Comparable<?> volatility) {
        this(meanReturn, volatility, BigMath.ONE);
    }

    public SimpleAsset(Comparable<?> meanReturn, Comparable<?> volatility, Comparable<?> weight) {
        this.myMeanReturn = meanReturn != null ? Scalar.doubleValue(meanReturn) : PrimitiveMath.ZERO;
        this.myVolatility = volatility != null ? Scalar.doubleValue(volatility) : PrimitiveMath.ZERO;
        this.myWeight = TypeUtils.toBigDecimal(weight);
    }

    private SimpleAsset() {
        this(BigMath.ZERO, BigMath.ZERO, BigMath.ONE);
    }

    @Override
    public double getMeanReturn() {
        return this.myMeanReturn;
    }

    @Override
    public double getVolatility() {
        return this.myVolatility;
    }

    public BigDecimal getWeight() {
        return this.myWeight;
    }

    @Override
    public List<BigDecimal> getWeights() {
        return Collections.singletonList(this.myWeight);
    }

    @Override
    protected void reset() {
    }
}

