/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.data.domain.finance.series;

import java.time.LocalDate;
import org.ojalgo.data.domain.finance.series.DatePrice;
import org.ojalgo.netio.BasicParser;

public class IEXTradingParser
implements BasicParser<Data> {
    public static final IEXTradingParser INSTANCE = new IEXTradingParser();

    public static boolean testHeader(String header) {
        String[] columns = header.split(",");
        int length = columns.length;
        if (length != 12) {
            return false;
        }
        String date = columns[0].trim();
        if (!"date".equalsIgnoreCase(date)) {
            return false;
        }
        String price = columns[4].trim();
        return "close".equalsIgnoreCase(price);
    }

    @Override
    public Data parse(String line) {
        LocalDate date = null;
        double open = Double.NaN;
        double high = Double.NaN;
        double low = Double.NaN;
        double close = Double.NaN;
        double volume = Double.NaN;
        double unadjustedVolume = Double.NaN;
        try {
            int inclBegin = 0;
            int exclEnd = line.indexOf(44, inclBegin);
            String part = line.substring(inclBegin, exclEnd);
            date = LocalDate.parse(part);
            inclBegin = exclEnd + 1;
            exclEnd = line.indexOf(44, inclBegin);
            part = line.substring(inclBegin, exclEnd);
            try {
                open = Double.parseDouble(part);
            }
            catch (NumberFormatException ex) {
                open = Double.NaN;
            }
            inclBegin = exclEnd + 1;
            exclEnd = line.indexOf(44, inclBegin);
            part = line.substring(inclBegin, exclEnd);
            try {
                high = Double.parseDouble(part);
            }
            catch (NumberFormatException ex) {
                high = Double.NaN;
            }
            inclBegin = exclEnd + 1;
            exclEnd = line.indexOf(44, inclBegin);
            part = line.substring(inclBegin, exclEnd);
            try {
                low = Double.parseDouble(part);
            }
            catch (NumberFormatException ex) {
                low = Double.NaN;
            }
            inclBegin = exclEnd + 1;
            exclEnd = line.indexOf(44, inclBegin);
            part = line.substring(inclBegin, exclEnd);
            try {
                close = Double.parseDouble(part);
            }
            catch (NumberFormatException ex) {
                close = Double.NaN;
            }
            inclBegin = exclEnd + 1;
            exclEnd = line.indexOf(44, inclBegin);
            part = line.substring(inclBegin, exclEnd);
            try {
                volume = Double.parseDouble(part);
            }
            catch (NumberFormatException ex) {
                volume = Double.NaN;
            }
            inclBegin = exclEnd + 1;
            exclEnd = line.indexOf(44, inclBegin);
            part = line.substring(inclBegin, exclEnd);
            try {
                unadjustedVolume = Double.parseDouble(part);
            }
            catch (NumberFormatException ex) {
                unadjustedVolume = Double.NaN;
            }
        }
        catch (Exception cause) {
            date = null;
            close = Double.NaN;
        }
        if (date != null && Double.isFinite(close)) {
            return new Data(date, open, high, low, close, volume, unadjustedVolume);
        }
        return null;
    }

    public static final class Data
    extends DatePrice {
        public final double close;
        public final double high;
        public final double low;
        public final double open;
        public final double unadjustedVolume;
        public final double volume;

        public Data(LocalDate date, double open, double high, double low, double close, double volume, double unadjustedVolume) {
            super(date);
            this.open = open;
            this.high = high;
            this.low = low;
            this.close = close;
            this.volume = volume;
            this.unadjustedVolume = unadjustedVolume;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj) || !(obj instanceof Data)) {
                return false;
            }
            Data other = (Data)obj;
            if (Double.doubleToLongBits(this.close) != Double.doubleToLongBits(other.close) || Double.doubleToLongBits(this.high) != Double.doubleToLongBits(other.high) || Double.doubleToLongBits(this.low) != Double.doubleToLongBits(other.low) || Double.doubleToLongBits(this.open) != Double.doubleToLongBits(other.open)) {
                return false;
            }
            return Double.doubleToLongBits(this.unadjustedVolume) == Double.doubleToLongBits(other.unadjustedVolume) && Double.doubleToLongBits(this.volume) == Double.doubleToLongBits(other.volume);
        }

        @Override
        public double getPrice() {
            return this.close;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            long temp = Double.doubleToLongBits(this.close);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.high);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.low);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.open);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.unadjustedVolume);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.volume);
            return 31 * result + (int)(temp ^ temp >>> 32);
        }
    }
}

