/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.function;

import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.FunctionSet;
import org.ojalgo.function.ParameterFunction;
import org.ojalgo.function.PredicateFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.function.VoidFunction;
import org.ojalgo.function.aggregator.AggregatorSet;
import org.ojalgo.function.aggregator.QuaternionAggregator;
import org.ojalgo.function.constant.QuaternionMath;
import org.ojalgo.scalar.Quaternion;
import org.ojalgo.type.context.NumberContext;

public final class QuaternionFunction
extends FunctionSet<Quaternion> {
    private static final QuaternionFunction SET = new QuaternionFunction();

    public static QuaternionFunction getSet() {
        return SET;
    }

    private QuaternionFunction() {
    }

    @Override
    public UnaryFunction<Quaternion> abs() {
        return QuaternionMath.ABS;
    }

    @Override
    public UnaryFunction<Quaternion> acos() {
        return QuaternionMath.ACOS;
    }

    @Override
    public UnaryFunction<Quaternion> acosh() {
        return QuaternionMath.ACOSH;
    }

    @Override
    public BinaryFunction<Quaternion> add() {
        return QuaternionMath.ADD;
    }

    @Override
    public AggregatorSet<Quaternion> aggregator() {
        return QuaternionAggregator.getSet();
    }

    @Override
    public UnaryFunction<Quaternion> asin() {
        return QuaternionMath.ASIN;
    }

    @Override
    public UnaryFunction<Quaternion> asinh() {
        return QuaternionMath.ASINH;
    }

    @Override
    public UnaryFunction<Quaternion> atan() {
        return QuaternionMath.ATAN;
    }

    @Override
    public BinaryFunction<Quaternion> atan2() {
        return QuaternionMath.ATAN2;
    }

    @Override
    public UnaryFunction<Quaternion> atanh() {
        return QuaternionMath.ATANH;
    }

    @Override
    public UnaryFunction<Quaternion> cardinality() {
        return QuaternionMath.CARDINALITY;
    }

    @Override
    public UnaryFunction<Quaternion> cbrt() {
        return QuaternionMath.CBRT;
    }

    @Override
    public UnaryFunction<Quaternion> ceil() {
        return QuaternionMath.CEIL;
    }

    @Override
    public UnaryFunction<Quaternion> conjugate() {
        return QuaternionMath.CONJUGATE;
    }

    @Override
    public UnaryFunction<Quaternion> cos() {
        return QuaternionMath.COS;
    }

    @Override
    public UnaryFunction<Quaternion> cosh() {
        return QuaternionMath.COSH;
    }

    @Override
    public BinaryFunction<Quaternion> divide() {
        return QuaternionMath.DIVIDE;
    }

    public Unary enforce(NumberContext context) {
        return t -> Quaternion.valueOf(context.enforce(t));
    }

    @Override
    public UnaryFunction<Quaternion> exp() {
        return QuaternionMath.EXP;
    }

    @Override
    public UnaryFunction<Quaternion> expm1() {
        return QuaternionMath.EXPM1;
    }

    @Override
    public UnaryFunction<Quaternion> floor() {
        return QuaternionMath.FLOOR;
    }

    @Override
    public BinaryFunction<Quaternion> hypot() {
        return QuaternionMath.HYPOT;
    }

    @Override
    public UnaryFunction<Quaternion> invert() {
        return QuaternionMath.INVERT;
    }

    @Override
    public UnaryFunction<Quaternion> log() {
        return QuaternionMath.LOG;
    }

    @Override
    public UnaryFunction<Quaternion> log10() {
        return QuaternionMath.LOG10;
    }

    @Override
    public UnaryFunction<Quaternion> log1p() {
        return QuaternionMath.LOG1P;
    }

    @Override
    public UnaryFunction<Quaternion> logistic() {
        return QuaternionMath.LOGISTIC;
    }

    @Override
    public UnaryFunction<Quaternion> logit() {
        return QuaternionMath.LOGIT;
    }

    @Override
    public BinaryFunction<Quaternion> max() {
        return QuaternionMath.MAX;
    }

    @Override
    public BinaryFunction<Quaternion> min() {
        return QuaternionMath.MIN;
    }

    @Override
    public BinaryFunction<Quaternion> multiply() {
        return QuaternionMath.MULTIPLY;
    }

    @Override
    public UnaryFunction<Quaternion> negate() {
        return QuaternionMath.NEGATE;
    }

    @Override
    public BinaryFunction<Quaternion> pow() {
        return QuaternionMath.POW;
    }

    @Override
    public ParameterFunction<Quaternion> power() {
        return QuaternionMath.POWER;
    }

    @Override
    public UnaryFunction<Quaternion> rint() {
        return QuaternionMath.RINT;
    }

    @Override
    public ParameterFunction<Quaternion> root() {
        return QuaternionMath.ROOT;
    }

    @Override
    public ParameterFunction<Quaternion> scale() {
        return QuaternionMath.SCALE;
    }

    @Override
    public UnaryFunction<Quaternion> signum() {
        return QuaternionMath.SIGNUM;
    }

    @Override
    public UnaryFunction<Quaternion> sin() {
        return QuaternionMath.SIN;
    }

    @Override
    public UnaryFunction<Quaternion> sinh() {
        return QuaternionMath.SINH;
    }

    @Override
    public UnaryFunction<Quaternion> sqrt() {
        return QuaternionMath.SQRT;
    }

    @Override
    public UnaryFunction<Quaternion> sqrt1px2() {
        return QuaternionMath.SQRT1PX2;
    }

    @Override
    public BinaryFunction<Quaternion> subtract() {
        return QuaternionMath.SUBTRACT;
    }

    @Override
    public UnaryFunction<Quaternion> tan() {
        return QuaternionMath.TAN;
    }

    @Override
    public UnaryFunction<Quaternion> tanh() {
        return QuaternionMath.TANH;
    }

    @Override
    public UnaryFunction<Quaternion> value() {
        return QuaternionMath.VALUE;
    }

    @FunctionalInterface
    public static interface Unary
    extends UnaryFunction<Quaternion> {
        @Override
        default public double invoke(double arg) {
            return this.invoke(Quaternion.valueOf(arg)).doubleValue();
        }

        @Override
        default public float invoke(float arg) {
            return this.invoke(Quaternion.valueOf(arg)).floatValue();
        }
    }

    @FunctionalInterface
    public static interface Predicate
    extends PredicateFunction<Quaternion> {
        @Override
        default public boolean invoke(double arg) {
            return this.invoke(Quaternion.valueOf(arg));
        }

        @Override
        default public boolean invoke(float arg) {
            return this.invoke(Quaternion.valueOf(arg));
        }
    }

    @FunctionalInterface
    public static interface Parameter
    extends ParameterFunction<Quaternion> {
        @Override
        default public double invoke(double arg, int param) {
            return this.invoke(Quaternion.valueOf(arg), param).doubleValue();
        }

        @Override
        default public float invoke(float arg, int param) {
            return this.invoke(Quaternion.valueOf(arg), param).floatValue();
        }
    }

    @FunctionalInterface
    public static interface Consumer
    extends VoidFunction<Quaternion> {
        @Override
        default public void invoke(double arg) {
            this.invoke(Quaternion.valueOf(arg));
        }

        @Override
        default public void invoke(float arg) {
            this.invoke(Quaternion.valueOf(arg));
        }
    }

    @FunctionalInterface
    public static interface Binary
    extends BinaryFunction<Quaternion> {
        @Override
        default public double invoke(double arg1, double arg2) {
            return this.invoke(Quaternion.valueOf(arg1), Quaternion.valueOf(arg2)).doubleValue();
        }

        @Override
        default public float invoke(float arg1, float arg2) {
            return this.invoke(Quaternion.valueOf(arg1), Quaternion.valueOf(arg2)).floatValue();
        }
    }
}

