/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.function.multiary;

import org.ojalgo.ProgrammingError;
import org.ojalgo.function.BasicFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.function.multiary.FirstOrderApproximation;
import org.ojalgo.function.multiary.SecondOrderApproximation;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.structure.Access1D;

public interface MultiaryFunction<N extends Comparable<N>>
extends BasicFunction.PlainUnary<Access1D<N>, N> {
    default public MultiaryFunction<N> andThen(final UnaryFunction<N> after) {
        ProgrammingError.throwIfNull(after);
        return new MultiaryFunction<N>(){

            @Override
            public int arity() {
                return MultiaryFunction.this.arity();
            }

            @Override
            public N invoke(Access1D<N> arg) {
                return after.invoke(MultiaryFunction.this.invoke(arg));
            }
        };
    }

    public int arity();

    @Override
    public N invoke(Access1D<N> var1);

    public static interface TwiceDifferentiable<N extends Comparable<N>>
    extends MultiaryFunction<N> {
        public MatrixStore<N> getGradient(Access1D<N> var1);

        public MatrixStore<N> getHessian(Access1D<N> var1);

        @Deprecated
        default public MatrixStore<N> getLinearFactors() {
            return this.getLinearFactors(false);
        }

        public MatrixStore<N> getLinearFactors(boolean var1);

        default public TwiceDifferentiable<N> toFirstOrderApproximation(Access1D<N> arg) {
            return new FirstOrderApproximation<N>(this, arg);
        }

        default public TwiceDifferentiable<N> toSecondOrderApproximation(Access1D<N> arg) {
            return new SecondOrderApproximation<N>(this, arg);
        }
    }

    public static interface Quadratic<N extends Comparable<N>>
    extends PureQuadratic<N>,
    Linear<N> {
    }

    public static interface PureQuadratic<N extends Comparable<N>>
    extends Constant<N> {
        public PhysicalStore<N> quadratic();
    }

    public static interface Linear<N extends Comparable<N>>
    extends MultiaryFunction<N> {
        public PhysicalStore<N> linear();
    }

    public static interface Convex<N extends Comparable<N>>
    extends MultiaryFunction<N> {
    }

    public static interface Constant<N extends Comparable<N>>
    extends MultiaryFunction<N> {
        public N getConstant();

        public void setConstant(Comparable<?> var1);
    }

    public static interface Affine<N extends Comparable<N>>
    extends Linear<N>,
    Constant<N> {
    }
}

