/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.function.multiary;

import org.ojalgo.function.multiary.ConstantFunction;
import org.ojalgo.function.multiary.MultiaryFunction;
import org.ojalgo.matrix.store.GenericStore;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.Primitive64Store;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.RationalNumber;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Access2D;

public final class PureQuadraticFunction<N extends Comparable<N>>
implements MultiaryFunction.TwiceDifferentiable<N>,
MultiaryFunction.PureQuadratic<N> {
    private final MatrixStore<N> myCoefficients;
    private final ConstantFunction<N> myConstant;

    public static <N extends Comparable<N>> Factory<N> factory(PhysicalStore.Factory<N, ?> factory) {
        return new Factory<N>(factory);
    }

    @Deprecated
    public static PureQuadraticFunction<ComplexNumber> makeComplex(Access2D<?> coefficients) {
        return PureQuadraticFunction.factory(GenericStore.C128).coefficients(coefficients).make(coefficients.getMaxDim());
    }

    @Deprecated
    public static PureQuadraticFunction<ComplexNumber> makeComplex(int arity) {
        return PureQuadraticFunction.factory(GenericStore.C128).make(arity);
    }

    @Deprecated
    public static PureQuadraticFunction<Double> makePrimitive(Access2D<?> coefficients) {
        return PureQuadraticFunction.factory(Primitive64Store.FACTORY).coefficients(coefficients).make(coefficients.getMaxDim());
    }

    @Deprecated
    public static PureQuadraticFunction<Double> makePrimitive(int arity) {
        return PureQuadraticFunction.factory(Primitive64Store.FACTORY).make(arity);
    }

    @Deprecated
    public static PureQuadraticFunction<RationalNumber> makeRational(Access2D<?> coefficients) {
        return PureQuadraticFunction.factory(GenericStore.Q128).coefficients(coefficients).make(coefficients.getMaxDim());
    }

    @Deprecated
    public static PureQuadraticFunction<RationalNumber> makeRational(int arity) {
        return PureQuadraticFunction.factory(GenericStore.Q128).make(arity);
    }

    public static <N extends Comparable<N>> PureQuadraticFunction<N> wrap(PhysicalStore<N> coefficients) {
        return new PureQuadraticFunction<N>(coefficients);
    }

    PureQuadraticFunction(MatrixStore<N> coefficients) {
        if (!coefficients.isSquare()) {
            throw new IllegalArgumentException("Must be sqaure!");
        }
        this.myCoefficients = coefficients;
        this.myConstant = new ConstantFunction<N>(coefficients.countRows(), coefficients.physical());
    }

    @Override
    public int arity() {
        return (int)this.myCoefficients.countColumns();
    }

    @Override
    public N getConstant() {
        return this.myConstant.getConstant();
    }

    @Override
    public MatrixStore<N> getGradient(Access1D<N> point) {
        PhysicalStore retVal = (PhysicalStore)this.myCoefficients.physical().make((long)this.arity(), 1L);
        this.getHessian(point).multiply(point, retVal);
        return retVal;
    }

    @Override
    public MatrixStore<N> getHessian(Access1D<N> point) {
        return this.myCoefficients.add(this.myCoefficients.conjugate());
    }

    @Override
    public MatrixStore<N> getLinearFactors(boolean negated) {
        return this.myCoefficients.physical().makeZero(this.arity(), 1L);
    }

    @Override
    public N invoke(Access1D<N> arg) {
        return (N)((Comparable)this.getScalarValue(arg).get());
    }

    @Override
    public PhysicalStore<N> quadratic() {
        return (PhysicalStore)this.myCoefficients;
    }

    @Override
    public void setConstant(Comparable<?> constant) {
        this.myConstant.setConstant(constant);
    }

    PhysicalStore.Factory<N, ?> factory() {
        return this.myCoefficients.physical();
    }

    Scalar<N> getScalarValue(Access1D<N> arg) {
        Scalar<N> retVal = this.myConstant.getScalarConstant();
        return (Scalar)retVal.add(this.myCoefficients.multiplyBoth(arg));
    }

    public static final class Factory<N extends Comparable<N>> {
        private Access2D<?> myCoefficients = null;
        private final PhysicalStore.Factory<N, ?> myFactory;

        Factory(PhysicalStore.Factory<N, ?> factory) {
            this.myFactory = factory;
        }

        public Factory<N> coefficients(Access2D<?> coefficients) {
            this.myCoefficients = coefficients;
            return this;
        }

        public PureQuadraticFunction<N> make(int arity) {
            if (this.myCoefficients != null) {
                return new PureQuadraticFunction((MatrixStore)this.myFactory.copy(this.myCoefficients));
            }
            return new PureQuadraticFunction((MatrixStore)this.myFactory.make(arity, arity));
        }
    }
}

