/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix;

import org.ojalgo.matrix.BasicMatrix;
import org.ojalgo.matrix.MatrixFactory;
import org.ojalgo.matrix.MatrixR064;
import org.ojalgo.matrix.Mutator2D;
import org.ojalgo.matrix.decomposition.Cholesky;
import org.ojalgo.matrix.decomposition.Eigenvalue;
import org.ojalgo.matrix.decomposition.LDL;
import org.ojalgo.matrix.decomposition.LU;
import org.ojalgo.matrix.decomposition.QR;
import org.ojalgo.matrix.decomposition.SingularValue;
import org.ojalgo.matrix.store.ElementsSupplier;
import org.ojalgo.matrix.store.GenericStore;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.Primitive64Store;
import org.ojalgo.matrix.store.SparseStore;
import org.ojalgo.matrix.task.DeterminantTask;
import org.ojalgo.matrix.task.InverterTask;
import org.ojalgo.matrix.task.SolverTask;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.structure.Structure2D;

public final class MatrixC128
extends BasicMatrix<ComplexNumber, MatrixC128> {
    public static final Factory FACTORY = new Factory();

    MatrixC128(ElementsSupplier<ComplexNumber> supplier) {
        super(FACTORY.getPhysicalFactory(), supplier);
    }

    public DenseReceiver copy() {
        return new DenseReceiver(this.store().copy());
    }

    public MatrixR064 getArgument() {
        return (MatrixR064)MatrixR064.FACTORY.instantiate(Primitive64Store.getComplexArgument(this.store()));
    }

    public MatrixR064 getImaginary() {
        return (MatrixR064)MatrixR064.FACTORY.instantiate(Primitive64Store.getComplexImaginary(this.store()));
    }

    public MatrixR064 getModulus() {
        return (MatrixR064)MatrixR064.FACTORY.instantiate(Primitive64Store.getComplexModulus(this.store()));
    }

    public MatrixR064 getReal() {
        return (MatrixR064)MatrixR064.FACTORY.instantiate(Primitive64Store.getComplexReal(this.store()));
    }

    @Override
    Cholesky<ComplexNumber> newCholesky(Structure2D typical) {
        return (Cholesky)Cholesky.C128.make(typical);
    }

    @Override
    DeterminantTask<ComplexNumber> newDeterminantTask(Structure2D template) {
        return DeterminantTask.C128.make(template, this.isHermitian(), false);
    }

    @Override
    Eigenvalue<ComplexNumber> newEigenvalue(Structure2D typical) {
        return Eigenvalue.C128.make(typical, this.isHermitian());
    }

    @Override
    MatrixC128 newInstance(ElementsSupplier<ComplexNumber> store) {
        return new MatrixC128(store);
    }

    @Override
    InverterTask<ComplexNumber> newInverterTask(Structure2D base) {
        return InverterTask.C128.make(base, this.isHermitian(), false);
    }

    @Override
    LDL<ComplexNumber> newLDL(Structure2D typical) {
        return (LDL)LDL.C128.make(typical);
    }

    @Override
    LU<ComplexNumber> newLU(Structure2D typical) {
        return (LU)LU.C128.make(typical);
    }

    @Override
    QR<ComplexNumber> newQR(Structure2D typical) {
        return QR.C128.make(typical);
    }

    @Override
    SingularValue<ComplexNumber> newSingularValue(Structure2D typical) {
        return SingularValue.C128.make(typical);
    }

    @Override
    SolverTask<ComplexNumber> newSolverTask(Structure2D templateBody, Structure2D templateRHS) {
        return SolverTask.C128.make(templateBody, templateRHS, this.isHermitian(), false);
    }

    public static final class SparseReceiver
    extends Mutator2D<ComplexNumber, MatrixC128, SparseStore<ComplexNumber>> {
        SparseReceiver(SparseStore<ComplexNumber> delegate) {
            super(delegate);
        }

        @Override
        MatrixC128 instantiate(MatrixStore<ComplexNumber> store) {
            return (MatrixC128)FACTORY.instantiate(store);
        }
    }

    public static final class Factory
    extends MatrixFactory<ComplexNumber, MatrixC128, DenseReceiver, SparseReceiver> {
        Factory() {
            super(MatrixC128.class, GenericStore.C128);
        }

        @Override
        DenseReceiver dense(PhysicalStore<ComplexNumber> store) {
            return new DenseReceiver(store);
        }

        @Override
        SparseReceiver sparse(SparseStore<ComplexNumber> store) {
            return new SparseReceiver(store);
        }
    }

    public static final class DenseReceiver
    extends Mutator2D<ComplexNumber, MatrixC128, PhysicalStore<ComplexNumber>> {
        DenseReceiver(PhysicalStore<ComplexNumber> delegate) {
            super(delegate);
        }

        @Override
        MatrixC128 instantiate(MatrixStore<ComplexNumber> store) {
            return (MatrixC128)FACTORY.instantiate(store);
        }
    }
}

