/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix;

import org.ojalgo.matrix.BasicMatrix;
import org.ojalgo.matrix.MatrixFactory;
import org.ojalgo.matrix.Mutator2D;
import org.ojalgo.matrix.decomposition.Cholesky;
import org.ojalgo.matrix.decomposition.Eigenvalue;
import org.ojalgo.matrix.decomposition.LDL;
import org.ojalgo.matrix.decomposition.LU;
import org.ojalgo.matrix.decomposition.QR;
import org.ojalgo.matrix.decomposition.SingularValue;
import org.ojalgo.matrix.store.ElementsSupplier;
import org.ojalgo.matrix.store.GenericStore;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.SparseStore;
import org.ojalgo.matrix.task.DeterminantTask;
import org.ojalgo.matrix.task.InverterTask;
import org.ojalgo.matrix.task.SolverTask;
import org.ojalgo.scalar.Quadruple;
import org.ojalgo.structure.Structure2D;

public final class MatrixR128
extends BasicMatrix<Quadruple, MatrixR128> {
    public static final Factory FACTORY = new Factory();

    MatrixR128(ElementsSupplier<Quadruple> supplier) {
        super(FACTORY.getPhysicalFactory(), supplier);
    }

    public DenseReceiver copy() {
        return new DenseReceiver(this.store().copy());
    }

    @Override
    Cholesky<Quadruple> newCholesky(Structure2D typical) {
        return (Cholesky)Cholesky.R128.make(typical);
    }

    @Override
    DeterminantTask<Quadruple> newDeterminantTask(Structure2D template) {
        return DeterminantTask.R128.make(template, this.isHermitian(), false);
    }

    @Override
    Eigenvalue<Quadruple> newEigenvalue(Structure2D typical) {
        return Eigenvalue.R128.make(typical, this.isHermitian());
    }

    @Override
    MatrixR128 newInstance(ElementsSupplier<Quadruple> store) {
        return new MatrixR128(store);
    }

    @Override
    InverterTask<Quadruple> newInverterTask(Structure2D template) {
        return InverterTask.R128.make(template, this.isHermitian(), false);
    }

    @Override
    LDL<Quadruple> newLDL(Structure2D typical) {
        return (LDL)LDL.R128.make(typical);
    }

    @Override
    LU<Quadruple> newLU(Structure2D typical) {
        return (LU)LU.R128.make(typical);
    }

    @Override
    QR<Quadruple> newQR(Structure2D typical) {
        return QR.R128.make(typical);
    }

    @Override
    SingularValue<Quadruple> newSingularValue(Structure2D typical) {
        return SingularValue.R128.make(typical);
    }

    @Override
    SolverTask<Quadruple> newSolverTask(Structure2D templateBody, Structure2D templateRHS) {
        return SolverTask.R128.make(templateBody, templateRHS, this.isHermitian(), false);
    }

    public static final class SparseReceiver
    extends Mutator2D<Quadruple, MatrixR128, SparseStore<Quadruple>> {
        SparseReceiver(SparseStore<Quadruple> delegate) {
            super(delegate);
        }

        @Override
        MatrixR128 instantiate(MatrixStore<Quadruple> store) {
            return (MatrixR128)FACTORY.instantiate(store);
        }
    }

    public static final class Factory
    extends MatrixFactory<Quadruple, MatrixR128, DenseReceiver, SparseReceiver> {
        Factory() {
            super(MatrixR128.class, GenericStore.R128);
        }

        @Override
        DenseReceiver dense(PhysicalStore<Quadruple> store) {
            return new DenseReceiver(store);
        }

        @Override
        SparseReceiver sparse(SparseStore<Quadruple> store) {
            return new SparseReceiver(store);
        }
    }

    public static final class DenseReceiver
    extends Mutator2D<Quadruple, MatrixR128, PhysicalStore<Quadruple>> {
        DenseReceiver(PhysicalStore<Quadruple> delegate) {
            super(delegate);
        }

        @Override
        MatrixR128 instantiate(MatrixStore<Quadruple> store) {
            return (MatrixR128)FACTORY.instantiate(store);
        }
    }
}

