/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix;

import java.util.function.Supplier;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.NullaryFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.matrix.BasicMatrix;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.TransformableRegion;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Access2D;
import org.ojalgo.structure.Mutate1D;
import org.ojalgo.structure.Mutate2D;
import org.ojalgo.structure.Transformation2D;

abstract class Mutator2D<N extends Comparable<N>, M extends BasicMatrix<N, M>, MR extends MatrixStore<N> & Mutate2D.ModifiableReceiver<N>>
implements Mutate2D.ModifiableReceiver<N>,
Supplier<M>,
Access2D.Collectable<N, TransformableRegion<N>> {
    private final MR myDelegate;
    private boolean mySafe = true;

    Mutator2D(MR delegate) {
        this.myDelegate = delegate;
    }

    @Override
    public void accept(Access2D<?> supplied) {
        if (!this.mySafe) {
            throw new IllegalStateException();
        }
        ((Mutate2D.Receiver)this.myDelegate).accept(supplied);
    }

    @Override
    public void add(long index, Comparable<?> addend) {
        if (!this.mySafe) {
            throw new IllegalStateException();
        }
        ((Mutate2D.Modifiable)this.myDelegate).add(index, addend);
    }

    @Override
    public void add(long index, double addend) {
        if (!this.mySafe) {
            throw new IllegalStateException();
        }
        ((Mutate2D.Modifiable)this.myDelegate).add(index, addend);
    }

    @Override
    public void add(long row, long col, Comparable<?> value) {
        if (!this.mySafe) {
            throw new IllegalStateException();
        }
        ((Mutate2D.Modifiable)this.myDelegate).add(row, col, value);
    }

    @Override
    public void add(long row, long col, double value) {
        if (!this.mySafe) {
            throw new IllegalStateException();
        }
        ((Mutate2D.Modifiable)this.myDelegate).add(row, col, value);
    }

    @Override
    public long count() {
        return this.myDelegate.count();
    }

    @Override
    public long countColumns() {
        return this.myDelegate.countColumns();
    }

    @Override
    public long countRows() {
        return this.myDelegate.countRows();
    }

    @Override
    public double doubleValue(long row, long col) {
        if (this.mySafe) {
            return this.myDelegate.doubleValue(row, col);
        }
        throw new IllegalStateException();
    }

    @Override
    public void exchangeColumns(long colA, long colB) {
        if (!this.mySafe) {
            throw new IllegalStateException();
        }
        ((Mutate2D.Exchangeable)this.myDelegate).exchangeColumns(colA, colB);
    }

    @Override
    public void exchangeRows(long rowA, long rowB) {
        if (!this.mySafe) {
            throw new IllegalStateException();
        }
        ((Mutate2D.Exchangeable)this.myDelegate).exchangeRows(rowA, rowB);
    }

    @Override
    public void fillAll(N value) {
        if (!this.mySafe) {
            throw new IllegalStateException();
        }
        ((Mutate1D.Fillable)this.myDelegate).fillAll(this.myDelegate.physical().scalar().cast((Comparable<?>)value));
    }

    @Override
    public void fillAll(NullaryFunction<?> supplier) {
        if (!this.mySafe) {
            throw new IllegalStateException();
        }
        ((Mutate1D.Fillable)this.myDelegate).fillAll(supplier);
    }

    @Override
    public void fillColumn(long col, Access1D<N> values) {
        if (!this.mySafe) {
            throw new IllegalStateException();
        }
        ((Mutate2D.Fillable)this.myDelegate).fillColumn(col, values);
    }

    @Override
    public void fillColumn(long row, long col, Access1D<N> values) {
        if (!this.mySafe) {
            throw new IllegalStateException();
        }
        ((Mutate2D.Fillable)this.myDelegate).fillColumn(row, col, values);
    }

    @Override
    public void fillColumn(long row, long column, N value) {
        if (!this.mySafe) {
            throw new IllegalStateException();
        }
        ((Mutate2D.Fillable)this.myDelegate).fillColumn((long)((int)row), (long)((int)column), this.myDelegate.physical().scalar().cast((Comparable<?>)value));
    }

    @Override
    public void fillColumn(long row, long col, NullaryFunction<?> supplier) {
        if (!this.mySafe) {
            throw new IllegalStateException();
        }
        ((Mutate2D.Fillable)this.myDelegate).fillColumn(row, col, supplier);
    }

    @Override
    public void fillColumn(long col, N value) {
        if (!this.mySafe) {
            throw new IllegalStateException();
        }
        ((Mutate2D.Fillable)this.myDelegate).fillColumn(col, value);
    }

    @Override
    public void fillColumn(long col, NullaryFunction<?> supplier) {
        if (!this.mySafe) {
            throw new IllegalStateException();
        }
        ((Mutate2D.Fillable)this.myDelegate).fillColumn(col, supplier);
    }

    @Override
    public void fillDiagonal(Access1D<N> values) {
        if (!this.mySafe) {
            throw new IllegalStateException();
        }
        ((Mutate2D.Fillable)this.myDelegate).fillDiagonal(values);
    }

    @Override
    public void fillDiagonal(long row, long col, Access1D<N> values) {
        if (!this.mySafe) {
            throw new IllegalStateException();
        }
        ((Mutate2D.Fillable)this.myDelegate).fillDiagonal(row, col, values);
    }

    @Override
    public void fillDiagonal(long row, long column, N value) {
        if (!this.mySafe) {
            throw new IllegalStateException();
        }
        ((Mutate2D.Fillable)this.myDelegate).fillDiagonal(row, column, this.myDelegate.physical().scalar().cast((Comparable<?>)value));
    }

    @Override
    public void fillDiagonal(long row, long col, NullaryFunction<?> supplier) {
        if (!this.mySafe) {
            throw new IllegalStateException();
        }
        ((Mutate2D.Fillable)this.myDelegate).fillDiagonal(row, col, supplier);
    }

    @Override
    public void fillDiagonal(N value) {
        if (!this.mySafe) {
            throw new IllegalStateException();
        }
        ((Mutate2D.Fillable)this.myDelegate).fillDiagonal(value);
    }

    @Override
    public void fillDiagonal(NullaryFunction<?> supplier) {
        if (!this.mySafe) {
            throw new IllegalStateException();
        }
        ((Mutate2D.Fillable)this.myDelegate).fillDiagonal(supplier);
    }

    @Override
    public void fillMatching(Access1D<?> values) {
        if (!this.mySafe) {
            throw new IllegalStateException();
        }
        ((Mutate1D.Fillable)this.myDelegate).fillMatching(values);
    }

    @Override
    public void fillMatching(Access1D<N> left, BinaryFunction<N> function, Access1D<N> right) {
        if (!this.mySafe) {
            throw new IllegalStateException();
        }
        ((Mutate1D.Fillable)this.myDelegate).fillMatching(left, function, right);
    }

    @Override
    public void fillMatching(UnaryFunction<N> function, Access1D<N> arguments) {
        if (!this.mySafe) {
            throw new IllegalStateException();
        }
        ((Mutate1D.Fillable)this.myDelegate).fillMatching(function, arguments);
    }

    @Override
    public void fillOne(long index, Access1D<?> values, long valueIndex) {
        if (!this.mySafe) {
            throw new IllegalStateException();
        }
        ((Mutate2D.Fillable)this.myDelegate).fillOne(index, values, valueIndex);
    }

    @Override
    public void fillOne(long row, long col, Access1D<?> values, long valueIndex) {
        if (!this.mySafe) {
            throw new IllegalStateException();
        }
        ((Mutate2D.Fillable)this.myDelegate).fillOne(row, col, values, valueIndex);
    }

    @Override
    public void fillOne(long row, long col, N value) {
        if (!this.mySafe) {
            throw new IllegalStateException();
        }
        ((Mutate2D.Fillable)this.myDelegate).fillOne(row, col, value);
    }

    @Override
    public void fillOne(long row, long col, NullaryFunction<?> supplier) {
        if (!this.mySafe) {
            throw new IllegalStateException();
        }
        ((Mutate2D.Fillable)this.myDelegate).fillOne(row, col, supplier);
    }

    @Override
    public void fillOne(long index, N value) {
        if (!this.mySafe) {
            throw new IllegalStateException();
        }
        ((Mutate2D.Fillable)this.myDelegate).fillOne(index, value);
    }

    @Override
    public void fillOne(long index, NullaryFunction<?> supplier) {
        if (!this.mySafe) {
            throw new IllegalStateException();
        }
        ((Mutate2D.Fillable)this.myDelegate).fillOne(index, supplier);
    }

    @Override
    public void fillRange(long first, long limit, N value) {
        if (!this.mySafe) {
            throw new IllegalStateException();
        }
        ((Mutate1D.Fillable)this.myDelegate).fillRange(first, limit, value);
    }

    @Override
    public void fillRange(long first, long limit, NullaryFunction<?> supplier) {
        if (!this.mySafe) {
            throw new IllegalStateException();
        }
        ((Mutate1D.Fillable)this.myDelegate).fillRange(first, limit, supplier);
    }

    @Override
    public void fillRow(long row, Access1D<N> values) {
        if (!this.mySafe) {
            throw new IllegalStateException();
        }
        ((Mutate2D.Fillable)this.myDelegate).fillRow(row, values);
    }

    @Override
    public void fillRow(long row, long col, Access1D<N> values) {
        if (!this.mySafe) {
            throw new IllegalStateException();
        }
        ((Mutate2D.Fillable)this.myDelegate).fillRow(row, col, values);
    }

    @Override
    public void fillRow(long row, long column, N value) {
        if (!this.mySafe) {
            throw new IllegalStateException();
        }
        ((Mutate2D.Fillable)this.myDelegate).fillRow((long)((int)row), (long)((int)column), this.myDelegate.physical().scalar().cast((Comparable<?>)value));
    }

    @Override
    public void fillRow(long row, long col, NullaryFunction<?> supplier) {
        if (!this.mySafe) {
            throw new IllegalStateException();
        }
        ((Mutate2D.Fillable)this.myDelegate).fillRow(row, col, supplier);
    }

    @Override
    public void fillRow(long row, N value) {
        if (!this.mySafe) {
            throw new IllegalStateException();
        }
        ((Mutate2D.Fillable)this.myDelegate).fillRow(row, value);
    }

    @Override
    public void fillRow(long row, NullaryFunction<?> supplier) {
        if (!this.mySafe) {
            throw new IllegalStateException();
        }
        ((Mutate2D.Fillable)this.myDelegate).fillRow(row, supplier);
    }

    @Override
    public M get() {
        this.mySafe = false;
        return this.instantiate((MatrixStore<N>)this.myDelegate);
    }

    @Override
    public N get(long row, long col) {
        if (this.mySafe) {
            return this.myDelegate.get(row, col);
        }
        throw new IllegalStateException();
    }

    @Override
    public void modifyAll(UnaryFunction<N> modifier) {
        if (!this.mySafe) {
            throw new IllegalStateException();
        }
        ((Mutate1D.Modifiable)this.myDelegate).modifyAll(modifier);
    }

    @Override
    public void modifyAny(Transformation2D<N> modifier) {
        if (!this.mySafe) {
            throw new IllegalStateException();
        }
        modifier.transform(this.myDelegate);
    }

    @Override
    public void modifyColumn(long row, long col, UnaryFunction<N> modifier) {
        if (!this.mySafe) {
            throw new IllegalStateException();
        }
        ((Mutate2D.Modifiable)this.myDelegate).modifyColumn(row, col, modifier);
    }

    @Override
    public void modifyColumn(long col, UnaryFunction<N> modifier) {
        if (!this.mySafe) {
            throw new IllegalStateException();
        }
        ((Mutate2D.Modifiable)this.myDelegate).modifyColumn(col, modifier);
    }

    @Override
    public void modifyDiagonal(long row, long col, UnaryFunction<N> modifier) {
        if (!this.mySafe) {
            throw new IllegalStateException();
        }
        ((Mutate2D.Modifiable)this.myDelegate).modifyDiagonal(row, col, modifier);
    }

    @Override
    public void modifyDiagonal(UnaryFunction<N> modifier) {
        if (!this.mySafe) {
            throw new IllegalStateException();
        }
        ((Mutate2D.Modifiable)this.myDelegate).modifyDiagonal(modifier);
    }

    @Override
    public void modifyMatching(Access1D<N> left, BinaryFunction<N> function) {
        if (!this.mySafe) {
            throw new IllegalStateException();
        }
        ((Mutate1D.Modifiable)this.myDelegate).modifyMatching(left, function);
    }

    @Override
    public void modifyMatching(BinaryFunction<N> function, Access1D<N> right) {
        if (!this.mySafe) {
            throw new IllegalStateException();
        }
        ((Mutate1D.Modifiable)this.myDelegate).modifyMatching(function, right);
    }

    @Override
    public void modifyMatchingInColumns(Access1D<N> left, BinaryFunction<N> function) {
        if (!this.mySafe) {
            throw new IllegalStateException();
        }
        ((Mutate2D.Modifiable)this.myDelegate).modifyMatchingInColumns(left, function);
    }

    @Override
    public void modifyMatchingInColumns(BinaryFunction<N> function, Access1D<N> right) {
        if (!this.mySafe) {
            throw new IllegalStateException();
        }
        ((Mutate2D.Modifiable)this.myDelegate).modifyMatchingInColumns(function, right);
    }

    @Override
    public void modifyMatchingInRows(Access1D<N> left, BinaryFunction<N> function) {
        if (!this.mySafe) {
            throw new IllegalStateException();
        }
        ((Mutate2D.Modifiable)this.myDelegate).modifyMatchingInRows(left, function);
    }

    @Override
    public void modifyMatchingInRows(BinaryFunction<N> function, Access1D<N> right) {
        if (!this.mySafe) {
            throw new IllegalStateException();
        }
        ((Mutate2D.Modifiable)this.myDelegate).modifyMatchingInRows(function, right);
    }

    @Override
    public void modifyOne(long row, long col, UnaryFunction<N> modifier) {
        if (!this.mySafe) {
            throw new IllegalStateException();
        }
        ((Mutate2D.Modifiable)this.myDelegate).modifyOne(row, col, modifier);
    }

    @Override
    public void modifyOne(long index, UnaryFunction<N> modifier) {
        if (!this.mySafe) {
            throw new IllegalStateException();
        }
        ((Mutate2D.Modifiable)this.myDelegate).modifyOne(index, modifier);
    }

    @Override
    public void modifyRange(long first, long limit, UnaryFunction<N> modifier) {
        if (!this.mySafe) {
            throw new IllegalStateException();
        }
        ((Mutate1D.Modifiable)this.myDelegate).modifyRange(first, limit, modifier);
    }

    @Override
    public void modifyRow(long row, long col, UnaryFunction<N> modifier) {
        if (!this.mySafe) {
            throw new IllegalStateException();
        }
        ((Mutate2D.Modifiable)this.myDelegate).modifyRow(row, col, modifier);
    }

    @Override
    public void modifyRow(long row, UnaryFunction<N> modifier) {
        if (!this.mySafe) {
            throw new IllegalStateException();
        }
        ((Mutate2D.Modifiable)this.myDelegate).modifyRow(row, modifier);
    }

    @Override
    public void reset() {
        if (!this.mySafe) {
            throw new IllegalStateException();
        }
        ((Mutate1D)this.myDelegate).reset();
    }

    @Override
    public void set(long index, Comparable<?> value) {
        if (!this.mySafe) {
            throw new IllegalStateException();
        }
        ((Mutate2D)this.myDelegate).set(index, (Comparable<?>)this.myDelegate.physical().scalar().cast(value));
    }

    @Override
    public void set(long index, double value) {
        if (!this.mySafe) {
            throw new IllegalStateException();
        }
        ((Mutate2D)this.myDelegate).set(index, value);
    }

    @Override
    public void set(long row, long col, Comparable<?> value) {
        if (!this.mySafe) {
            throw new IllegalStateException();
        }
        ((Mutate2D)this.myDelegate).set(row, col, value);
    }

    @Override
    public void set(long row, long col, double value) {
        if (!this.mySafe) {
            throw new IllegalStateException();
        }
        ((Mutate2D)this.myDelegate).set(row, col, value);
    }

    @Override
    public void supplyTo(TransformableRegion<N> receiver) {
        this.myDelegate.supplyTo(receiver);
    }

    abstract M instantiate(MatrixStore<N> var1);
}

