/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import org.ojalgo.array.Array1D;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.matrix.decomposition.Bidiagonal;
import org.ojalgo.matrix.decomposition.DecompositionStore;
import org.ojalgo.matrix.decomposition.InPlaceDecomposition;
import org.ojalgo.matrix.store.DiagonalStore;
import org.ojalgo.matrix.store.GenericStore;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.Primitive64Store;
import org.ojalgo.matrix.transformation.Householder;
import org.ojalgo.matrix.transformation.HouseholderReference;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.PrimitiveScalar;
import org.ojalgo.scalar.Quadruple;
import org.ojalgo.scalar.Quaternion;
import org.ojalgo.scalar.RationalNumber;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Access2D;
import org.ojalgo.structure.Structure2D;

abstract class BidiagonalDecomposition<N extends Comparable<N>>
extends InPlaceDecomposition<N>
implements Bidiagonal<N> {
    private transient DiagonalStore<N, Array1D<N>> myDiagonal;
    private final boolean myFullSize;
    private Array1D<N> myInitDiagLQ = null;
    private Array1D<N> myInitDiagRQ = null;
    private transient DecompositionStore<N> myLQ;
    private transient DecompositionStore<N> myRQ;

    protected BidiagonalDecomposition(PhysicalStore.Factory<N, ? extends DecompositionStore<N>> factory, boolean fullSize) {
        super(factory);
        this.myFullSize = fullSize;
    }

    @Override
    public boolean decompose(Access2D.Collectable<N, ? super PhysicalStore<N>> matrix) {
        this.reset();
        DecompositionStore storage = this.setInPlace(matrix);
        int tmpRowDim = this.getRowDim();
        int tmpColDim = this.getColDim();
        int tmpLimit = Math.min(tmpRowDim, tmpColDim);
        Householder tmpHouseholderRow = this.makeHouseholder(tmpColDim);
        Householder tmpHouseholderCol = this.makeHouseholder(tmpRowDim);
        if (this.isAspectRatioNormal()) {
            for (int ij = 0; ij < tmpLimit; ++ij) {
                if (ij + 1 < tmpRowDim && storage.generateApplyAndCopyHouseholderColumn(ij, ij, tmpHouseholderCol)) {
                    storage.transformLeft(tmpHouseholderCol, ij + 1);
                }
                if (ij + 2 >= tmpColDim || !storage.generateApplyAndCopyHouseholderRow(ij, ij + 1, tmpHouseholderRow)) continue;
                storage.transformRight(tmpHouseholderRow, ij + 1);
            }
            Array1D<N>[] tmpInitDiags = this.makeReal();
            if (tmpInitDiags != null) {
                this.myInitDiagLQ = tmpInitDiags[0];
                this.myInitDiagRQ = tmpInitDiags[1];
            }
        } else {
            for (int ij = 0; ij < tmpLimit; ++ij) {
                if (ij + 1 < tmpColDim && storage.generateApplyAndCopyHouseholderRow(ij, ij, tmpHouseholderRow)) {
                    storage.transformRight(tmpHouseholderRow, ij + 1);
                }
                if (ij + 2 >= tmpRowDim || !storage.generateApplyAndCopyHouseholderColumn(ij + 1, ij, tmpHouseholderCol)) continue;
                storage.transformLeft(tmpHouseholderCol, ij + 1);
            }
            Array1D<N>[] tmpInitDiags = this.makeReal();
            if (tmpInitDiags != null) {
                this.myInitDiagLQ = tmpInitDiags[0];
                this.myInitDiagRQ = tmpInitDiags[1];
            }
        }
        return this.computed(true);
    }

    @Override
    public MatrixStore<N> getD() {
        Structure2D.Logical<Access2D<N>, MatrixStore<N>> retVal = this.doGetDiagonal();
        if (this.myFullSize) {
            if (this.getRowDim() > retVal.getRowDim()) {
                retVal = retVal.below((long)this.getRowDim() - retVal.countRows());
            } else if (this.getColDim() > retVal.getColDim()) {
                retVal = retVal.right((long)this.getColDim() - retVal.countColumns());
            }
        }
        return retVal;
    }

    @Override
    public MatrixStore<N> getLQ() {
        return this.doGetLQ();
    }

    @Override
    public MatrixStore<N> getRQ() {
        return this.doGetRQ();
    }

    @Override
    public boolean isFullSize() {
        return this.myFullSize;
    }

    @Override
    public boolean isUpper() {
        return this.isAspectRatioNormal();
    }

    @Override
    public void reset() {
        super.reset();
        this.myLQ = null;
        this.myRQ = null;
        this.myDiagonal = null;
        this.myInitDiagLQ = null;
        this.myInitDiagRQ = null;
    }

    private DiagonalStore<N, Array1D<N>> makeDiagonal() {
        Access1D diagSub;
        Access1D diagSuper;
        DecompositionStore storage = this.getInPlace();
        Access1D diagMain = storage.sliceDiagonal(0L, 0L);
        if (this.isAspectRatioNormal()) {
            diagSuper = storage.sliceDiagonal(0L, 1L);
            diagSub = null;
        } else {
            diagSuper = null;
            diagSub = storage.sliceDiagonal(1L, 0L);
        }
        return this.makeDiagonal(diagMain).superdiagonal(diagSuper).subdiagonal(diagSub).get();
    }

    private DecompositionStore<N> makeLQ() {
        int ij;
        HouseholderReference tmpReference = HouseholderReference.makeColumn(this.getInPlace());
        int tmpRowDim = this.getRowDim();
        int tmpMinDim = this.getMinDim();
        DecompositionStore retVal = null;
        if (this.myInitDiagLQ != null) {
            retVal = this.makeZero(tmpRowDim, this.myFullSize ? tmpRowDim : tmpMinDim);
            for (int ij2 = 0; ij2 < tmpMinDim; ++ij2) {
                retVal.set((long)ij2, (long)ij2, (Comparable<?>)this.myInitDiagLQ.get(ij2));
            }
        } else {
            retVal = this.makeEye(tmpRowDim, this.myFullSize ? tmpRowDim : tmpMinDim);
        }
        boolean tmpUpper = this.isUpper();
        int n = ij = tmpUpper && tmpRowDim != tmpMinDim ? tmpMinDim - 1 : tmpMinDim - 2;
        while (ij >= 0) {
            tmpReference.point(tmpUpper ? (long)ij : (long)(ij + 1), ij);
            if (!tmpReference.isZero()) {
                retVal.transformLeft(tmpReference, ij);
            }
            --ij;
        }
        return retVal;
    }

    private DecompositionStore<N> makeRQ() {
        int ij;
        HouseholderReference tmpReference = HouseholderReference.makeRow(this.getInPlace());
        int tmpColDim = this.getColDim();
        int tmpMinDim = this.getMinDim();
        DecompositionStore retVal = null;
        if (this.myInitDiagRQ != null) {
            retVal = this.makeZero(tmpColDim, this.myFullSize ? tmpColDim : tmpMinDim);
            for (int ij2 = 0; ij2 < tmpMinDim; ++ij2) {
                retVal.set((long)ij2, (long)ij2, (Comparable<?>)this.myInitDiagRQ.get(ij2));
            }
        } else {
            retVal = this.makeEye(tmpColDim, this.myFullSize ? tmpColDim : tmpMinDim);
        }
        boolean tmpUpper = this.isUpper();
        int n = ij = tmpUpper ? tmpMinDim - 2 : tmpMinDim - 1;
        while (ij >= 0) {
            tmpReference.point(ij, tmpUpper ? (long)(ij + 1) : (long)ij);
            if (!tmpReference.isZero()) {
                retVal.transformLeft(tmpReference, ij);
            }
            --ij;
        }
        return retVal;
    }

    private void solve(PhysicalStore<N> aMtrxV, MatrixStore<N> aMtrxD, DiagonalStore<N, ?> aMtrxSimilar) {
        int tmpDim = (int)aMtrxV.countRows();
        int tmpLim = tmpDim - 1;
        for (int j = 0; j < tmpDim; ++j) {
            int i;
            double tmpSingular = aMtrxD.doubleValue(j, j);
            double value = tmpSingular;
            if (PrimitiveScalar.isSmall(PrimitiveMath.ONE, value)) {
                for (i = 0; i < tmpDim; ++i) {
                    aMtrxV.set((long)i, (long)j, PrimitiveMath.ZERO);
                }
                continue;
            }
            for (i = 0; i < tmpLim; ++i) {
                aMtrxV.set((long)i, (long)j, (aMtrxSimilar.doubleValue(i, i) * aMtrxV.doubleValue(i, j) + aMtrxSimilar.doubleValue(i, i + 1) * aMtrxV.doubleValue(i + 1, j)) / tmpSingular);
            }
            aMtrxV.set((long)tmpLim, (long)j, aMtrxSimilar.doubleValue(tmpLim, tmpLim) * aMtrxV.doubleValue(tmpLim, j) / tmpSingular);
        }
    }

    private DecompositionStore<N> solve2(PhysicalStore<N> aMtrxV, MatrixStore<N> aMtrxD, DiagonalStore<N, ?> aMtrxSimilar) {
        int tmpDim = (int)aMtrxV.countRows();
        int tmpLim = tmpDim - 1;
        DecompositionStore retVal = this.makeZero(tmpDim, tmpDim);
        for (int j = 0; j < tmpDim; ++j) {
            int i;
            double tmpSingular = aMtrxD.doubleValue(j, j);
            double value = tmpSingular;
            if (PrimitiveScalar.isSmall(PrimitiveMath.ONE, value)) {
                for (i = 0; i < tmpDim; ++i) {
                    retVal.set((long)i, (long)j, aMtrxV.doubleValue(i, j));
                }
                continue;
            }
            for (i = 0; i < tmpLim; ++i) {
                retVal.set((long)i, (long)j, (aMtrxSimilar.doubleValue(i, i) * aMtrxV.doubleValue(i, j) + aMtrxSimilar.doubleValue(i, i + 1) * aMtrxV.doubleValue(i + 1, j)) / tmpSingular);
            }
            retVal.set((long)tmpLim, (long)j, aMtrxSimilar.doubleValue(tmpLim, tmpLim) * aMtrxV.doubleValue(tmpLim, j) / tmpSingular);
        }
        return retVal;
    }

    DiagonalStore<N, Array1D<N>> doGetDiagonal() {
        if (this.myDiagonal == null) {
            this.myDiagonal = this.makeDiagonal();
        }
        return this.myDiagonal;
    }

    DecompositionStore<N> doGetLQ() {
        if (this.myLQ == null) {
            this.myLQ = this.makeLQ();
        }
        return this.myLQ;
    }

    DecompositionStore<N> doGetRQ() {
        if (this.myRQ == null) {
            this.myRQ = this.makeRQ();
        }
        return this.myRQ;
    }

    abstract Array1D<N>[] makeReal();

    static final class R128
    extends BidiagonalDecomposition<Quadruple> {
        R128() {
            this(false);
        }

        R128(boolean fullSize) {
            super(GenericStore.R128, fullSize);
        }

        @Override
        Array1D<Quadruple>[] makeReal() {
            return null;
        }
    }

    static final class R064
    extends BidiagonalDecomposition<Double> {
        R064() {
            this(false);
        }

        R064(boolean fullSize) {
            super(Primitive64Store.FACTORY, fullSize);
        }

        @Override
        Array1D<Double>[] makeReal() {
            return null;
        }
    }

    static final class Q128
    extends BidiagonalDecomposition<RationalNumber> {
        Q128() {
            this(false);
        }

        Q128(boolean fullSize) {
            super(GenericStore.Q128, fullSize);
        }

        @Override
        Array1D<RationalNumber>[] makeReal() {
            return null;
        }
    }

    static final class H256
    extends BidiagonalDecomposition<Quaternion> {
        H256() {
            this(false);
        }

        H256(boolean fullSize) {
            super(GenericStore.H256, fullSize);
        }

        @Override
        Array1D<Quaternion>[] makeReal() {
            return null;
        }
    }

    static final class C128
    extends BidiagonalDecomposition<ComplexNumber> {
        C128() {
            this(false);
        }

        C128(boolean fullSize) {
            super(GenericStore.C128, fullSize);
        }

        @Override
        Array1D<ComplexNumber>[] makeReal() {
            DiagonalStore tmpDiagonalAccessD = this.doGetDiagonal();
            Array1D tmpInitDiagQ1 = (Array1D)Array1D.C128.make(tmpDiagonalAccessD.getDimension());
            tmpInitDiagQ1.fillAll(ComplexNumber.ONE);
            Array1D tmpInitDiagQ2 = (Array1D)Array1D.C128.make(tmpDiagonalAccessD.getDimension());
            tmpInitDiagQ2.fillAll(ComplexNumber.ONE);
            boolean tmpUpper = this.isUpper();
            if (tmpUpper) {
                Array1D<ComplexNumber> tmpMainDiagonal = tmpDiagonalAccessD.getMainDiagonal().get();
                Array1D<ComplexNumber> tmpSuperdiagonal = tmpDiagonalAccessD.getSuperdiagonal().get();
                int tmpLimit = (int)tmpSuperdiagonal.count();
                for (int i = 0; i < tmpLimit; ++i) {
                    ComplexNumber tmpSignum;
                    if (!((ComplexNumber)tmpMainDiagonal.get(i)).isReal()) {
                        tmpSignum = ((ComplexNumber)tmpMainDiagonal.get(i)).signum();
                        tmpMainDiagonal.set(i, ((ComplexNumber)tmpMainDiagonal.get(i)).divide(tmpSignum));
                        tmpSuperdiagonal.set(i, ((ComplexNumber)tmpSuperdiagonal.get(i)).divide(tmpSignum));
                        tmpInitDiagQ1.set(i, tmpSignum);
                    }
                    if (((ComplexNumber)tmpSuperdiagonal.get(i)).isReal()) continue;
                    tmpSignum = ((ComplexNumber)tmpSuperdiagonal.get(i)).signum();
                    tmpSuperdiagonal.set(i, ((ComplexNumber)tmpSuperdiagonal.get(i)).divide(tmpSignum));
                    tmpMainDiagonal.set(i + 1, ((ComplexNumber)tmpMainDiagonal.get(i + 1)).divide(tmpSignum));
                    tmpInitDiagQ2.set(i + 1, tmpSignum.conjugate());
                }
                if (!((ComplexNumber)tmpMainDiagonal.get(tmpLimit)).isReal()) {
                    ComplexNumber tmpSignum = ((ComplexNumber)tmpMainDiagonal.get(tmpLimit)).signum();
                    tmpMainDiagonal.set(tmpLimit, ((ComplexNumber)tmpMainDiagonal.get(tmpLimit)).divide(tmpSignum));
                    tmpInitDiagQ1.set(tmpLimit, tmpSignum);
                }
            } else {
                Array1D<ComplexNumber> tmpMainDiagonal = tmpDiagonalAccessD.getMainDiagonal().get();
                Array1D<ComplexNumber> tmpSubdiagonal = tmpDiagonalAccessD.getSubdiagonal().get();
                int tmpLimit = (int)tmpSubdiagonal.count();
                for (int i = 0; i < tmpLimit; ++i) {
                    ComplexNumber tmpSignum;
                    if (!((ComplexNumber)tmpMainDiagonal.get(i)).isReal()) {
                        tmpSignum = ((ComplexNumber)tmpMainDiagonal.get(i)).signum();
                        tmpMainDiagonal.set(i, ((ComplexNumber)tmpMainDiagonal.get(i)).divide(tmpSignum));
                        tmpSubdiagonal.set(i, ((ComplexNumber)tmpSubdiagonal.get(i)).divide(tmpSignum));
                        tmpInitDiagQ2.set(i, tmpSignum.conjugate());
                    }
                    if (((ComplexNumber)tmpSubdiagonal.get(i)).isReal()) continue;
                    tmpSignum = ((ComplexNumber)tmpSubdiagonal.get(i)).signum();
                    tmpSubdiagonal.set(i, ((ComplexNumber)tmpSubdiagonal.get(i)).divide(tmpSignum));
                    tmpMainDiagonal.set(i + 1, ((ComplexNumber)tmpMainDiagonal.get(i + 1)).divide(tmpSignum));
                    tmpInitDiagQ1.set(i + 1, tmpSignum);
                }
                if (!((ComplexNumber)tmpMainDiagonal.get(tmpLimit)).isReal()) {
                    ComplexNumber tmpSignum = ((ComplexNumber)tmpMainDiagonal.get(tmpLimit)).signum();
                    tmpMainDiagonal.set(tmpLimit, ((ComplexNumber)tmpMainDiagonal.get(tmpLimit)).divide(tmpSignum));
                    tmpInitDiagQ2.set(tmpLimit, tmpSignum.conjugate());
                }
            }
            return new Array1D[]{tmpInitDiagQ1, tmpInitDiagQ2};
        }
    }
}

