/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.type.context.NumberContext;

public abstract class EvD1D {
    public static double[][] hqr2(double[] mtrxH, double[] mtrxV, boolean allTheWay) {
        int tmpDiagDim = PrimitiveMath.SQRT.invoke(mtrxH.length);
        int tmpDiagDimMinusOne = tmpDiagDim - 1;
        double tmpVal = PrimitiveMath.ZERO;
        for (int j = 0; j < tmpDiagDim; ++j) {
            for (int i = Math.min(j + 1, tmpDiagDim - 1); i >= 0; --i) {
                tmpVal += PrimitiveMath.ABS.invoke(mtrxH[i + tmpDiagDim * j]);
            }
        }
        double tmpNorm1 = tmpVal;
        double[] d = new double[tmpDiagDim];
        double[] e = new double[tmpDiagDim];
        double exshift = PrimitiveMath.ZERO;
        double p = 0.0;
        double q = 0.0;
        double r = 0.0;
        double s = 0.0;
        double z = 0.0;
        int iter = 0;
        int n = tmpDiagDimMinusOne;
        while (n >= 0) {
            int m;
            int i;
            double x;
            double w;
            int l;
            for (l = n; l > 0; --l) {
                s = PrimitiveMath.ABS.invoke(mtrxH[l - 1 + tmpDiagDim * (l - 1)]) + PrimitiveMath.ABS.invoke(mtrxH[l + tmpDiagDim * l]);
                if (NumberContext.compare(s, PrimitiveMath.ZERO) == 0) {
                    s = tmpNorm1;
                }
                if (PrimitiveMath.ABS.invoke(mtrxH[l + tmpDiagDim * (l - 1)]) < PrimitiveMath.MACHINE_EPSILON * s) break;
            }
            if (l == n) {
                mtrxH[n + tmpDiagDim * n] = mtrxH[n + tmpDiagDim * n] + exshift;
                d[n] = mtrxH[n + tmpDiagDim * n];
                e[n] = PrimitiveMath.ZERO;
                --n;
                iter = 0;
                continue;
            }
            if (l == n - 1) {
                w = mtrxH[n + tmpDiagDim * (n - 1)] * mtrxH[n - 1 + tmpDiagDim * n];
                p = (mtrxH[n - 1 + tmpDiagDim * (n - 1)] - mtrxH[n + tmpDiagDim * n]) / 2.0;
                q = p * p + w;
                z = PrimitiveMath.SQRT.invoke(PrimitiveMath.ABS.invoke(q));
                mtrxH[n + tmpDiagDim * n] = mtrxH[n + tmpDiagDim * n] + exshift;
                mtrxH[n - 1 + tmpDiagDim * (n - 1)] = mtrxH[n - 1 + tmpDiagDim * (n - 1)] + exshift;
                x = mtrxH[n + tmpDiagDim * n];
                if (q >= 0.0) {
                    z = p >= 0.0 ? p + z : p - z;
                    d[n - 1] = x + z;
                    d[n] = d[n - 1];
                    if (NumberContext.compare(z, PrimitiveMath.ZERO) != 0) {
                        d[n] = x - w / z;
                    }
                    e[n - 1] = PrimitiveMath.ZERO;
                    e[n] = PrimitiveMath.ZERO;
                    x = mtrxH[n + tmpDiagDim * (n - 1)];
                    s = PrimitiveMath.ABS.invoke(x) + PrimitiveMath.ABS.invoke(z);
                    p = x / s;
                    q = z / s;
                    r = PrimitiveMath.SQRT.invoke(p * p + q * q);
                    p /= r;
                    q /= r;
                    for (int j = n - 1; j < tmpDiagDim; ++j) {
                        z = mtrxH[n - 1 + tmpDiagDim * j];
                        mtrxH[n - 1 + tmpDiagDim * j] = q * z + p * mtrxH[n + tmpDiagDim * j];
                        mtrxH[n + tmpDiagDim * j] = q * mtrxH[n + tmpDiagDim * j] - p * z;
                    }
                    for (i = 0; i <= n; ++i) {
                        z = mtrxH[i + tmpDiagDim * (n - 1)];
                        mtrxH[i + tmpDiagDim * (n - 1)] = q * z + p * mtrxH[i + tmpDiagDim * n];
                        mtrxH[i + tmpDiagDim * n] = q * mtrxH[i + tmpDiagDim * n] - p * z;
                    }
                    for (i = 0; i <= tmpDiagDimMinusOne; ++i) {
                        z = mtrxV[i + tmpDiagDim * (n - 1)];
                        mtrxV[i + tmpDiagDim * (n - 1)] = q * z + p * mtrxV[i + tmpDiagDim * n];
                        mtrxV[i + tmpDiagDim * n] = q * mtrxV[i + tmpDiagDim * n] - p * z;
                    }
                } else {
                    d[n - 1] = x + p;
                    d[n] = x + p;
                    e[n - 1] = z;
                    e[n] = -z;
                }
                n -= 2;
                iter = 0;
                continue;
            }
            x = mtrxH[n + tmpDiagDim * n];
            double y = PrimitiveMath.ZERO;
            w = PrimitiveMath.ZERO;
            y = mtrxH[n - 1 + tmpDiagDim * (n - 1)];
            w = mtrxH[n + tmpDiagDim * (n - 1)] * mtrxH[n - 1 + tmpDiagDim * n];
            if (iter > 0 && iter % 11 == 0) {
                exshift += x;
                for (i = 0; i <= n; ++i) {
                    int n2 = i + tmpDiagDim * i;
                    mtrxH[n2] = mtrxH[n2] - x;
                }
                s = PrimitiveMath.ABS.invoke(mtrxH[n + tmpDiagDim * (n - 1)]) + PrimitiveMath.ABS.invoke(mtrxH[n - 1 + tmpDiagDim * (n - 2)]);
                x = y = 0.75 * s;
                w = -0.4375 * s * s;
            }
            if (iter > 0 && iter % 31 == 0) {
                s = (y - x) / 2.0;
                if ((s = s * s + w) > 0.0) {
                    s = PrimitiveMath.SQRT.invoke(s);
                    if (y < x) {
                        s = -s;
                    }
                    s = x - w / ((y - x) / 2.0 + s);
                    for (i = 0; i <= n; ++i) {
                        int n3 = i + tmpDiagDim * i;
                        mtrxH[n3] = mtrxH[n3] - s;
                    }
                    exshift += s;
                    w = 0.964;
                    y = 0.964;
                    x = 0.964;
                }
            }
            ++iter;
            for (m = n - 2; m >= l; --m) {
                z = mtrxH[m + tmpDiagDim * m];
                r = x - z;
                s = y - z;
                p = (r * s - w) / mtrxH[m + 1 + tmpDiagDim * m] + mtrxH[m + tmpDiagDim * (m + 1)];
                q = mtrxH[m + 1 + tmpDiagDim * (m + 1)] - z - r - s;
                r = mtrxH[m + 2 + tmpDiagDim * (m + 1)];
                s = PrimitiveMath.ABS.invoke(p) + PrimitiveMath.ABS.invoke(q) + PrimitiveMath.ABS.invoke(r);
                if (m == l || PrimitiveMath.ABS.invoke(mtrxH[m + tmpDiagDim * (m - 1)]) * (PrimitiveMath.ABS.invoke(q /= s) + PrimitiveMath.ABS.invoke(r /= s)) < PrimitiveMath.MACHINE_EPSILON * (PrimitiveMath.ABS.invoke(p /= s) * (PrimitiveMath.ABS.invoke(mtrxH[m - 1 + tmpDiagDim * (m - 1)]) + PrimitiveMath.ABS.invoke(z) + PrimitiveMath.ABS.invoke(mtrxH[m + 1 + tmpDiagDim * (m + 1)])))) break;
            }
            for (int i2 = m + 2; i2 <= n; ++i2) {
                mtrxH[i2 + tmpDiagDim * (i2 - 2)] = PrimitiveMath.ZERO;
                if (i2 <= m + 2) continue;
                mtrxH[i2 + tmpDiagDim * (i2 - 3)] = PrimitiveMath.ZERO;
            }
            for (int k = m; k <= n - 1; ++k) {
                int i3;
                boolean notlast;
                boolean bl = notlast = k != n - 1;
                if (k != m) {
                    p = mtrxH[k + tmpDiagDim * (k - 1)];
                    q = mtrxH[k + 1 + tmpDiagDim * (k - 1)];
                    r = notlast ? mtrxH[k + 2 + tmpDiagDim * (k - 1)] : PrimitiveMath.ZERO;
                    x = PrimitiveMath.ABS.invoke(p) + PrimitiveMath.ABS.invoke(q) + PrimitiveMath.ABS.invoke(r);
                    if (NumberContext.compare(x, PrimitiveMath.ZERO) == 0) continue;
                    p /= x;
                    q /= x;
                    r /= x;
                }
                s = PrimitiveMath.SQRT.invoke(p * p + q * q + r * r);
                if (p < 0.0) {
                    s = -s;
                }
                if (s == 0.0) continue;
                if (k != m) {
                    mtrxH[k + tmpDiagDim * (k - 1)] = -s * x;
                } else if (l != m) {
                    mtrxH[k + tmpDiagDim * (k - 1)] = -mtrxH[k + tmpDiagDim * (k - 1)];
                }
                x = (p += s) / s;
                y = q / s;
                z = r / s;
                q /= p;
                r /= p;
                for (int j = k; j < tmpDiagDim; ++j) {
                    p = mtrxH[k + tmpDiagDim * j] + q * mtrxH[k + 1 + tmpDiagDim * j];
                    if (notlast) {
                        mtrxH[k + 2 + tmpDiagDim * j] = mtrxH[k + 2 + tmpDiagDim * j] - (p += r * mtrxH[k + 2 + tmpDiagDim * j]) * z;
                    }
                    mtrxH[k + tmpDiagDim * j] = mtrxH[k + tmpDiagDim * j] - p * x;
                    mtrxH[k + 1 + tmpDiagDim * j] = mtrxH[k + 1 + tmpDiagDim * j] - p * y;
                }
                for (i3 = 0; i3 <= Math.min(n, k + 3); ++i3) {
                    p = x * mtrxH[i3 + tmpDiagDim * k] + y * mtrxH[i3 + tmpDiagDim * (k + 1)];
                    if (notlast) {
                        mtrxH[i3 + tmpDiagDim * (k + 2)] = mtrxH[i3 + tmpDiagDim * (k + 2)] - (p += z * mtrxH[i3 + tmpDiagDim * (k + 2)]) * r;
                    }
                    mtrxH[i3 + tmpDiagDim * k] = mtrxH[i3 + tmpDiagDim * k] - p;
                    mtrxH[i3 + tmpDiagDim * (k + 1)] = mtrxH[i3 + tmpDiagDim * (k + 1)] - p * q;
                }
                for (i3 = 0; i3 <= tmpDiagDimMinusOne; ++i3) {
                    p = x * mtrxV[i3 + tmpDiagDim * k] + y * mtrxV[i3 + tmpDiagDim * (k + 1)];
                    if (notlast) {
                        mtrxV[i3 + tmpDiagDim * (k + 2)] = mtrxV[i3 + tmpDiagDim * (k + 2)] - (p += z * mtrxV[i3 + tmpDiagDim * (k + 2)]) * r;
                    }
                    mtrxV[i3 + tmpDiagDim * k] = mtrxV[i3 + tmpDiagDim * k] - p;
                    mtrxV[i3 + tmpDiagDim * (k + 1)] = mtrxV[i3 + tmpDiagDim * (k + 1)] - p * q;
                }
            }
        }
        if (allTheWay && NumberContext.compare(tmpNorm1, PrimitiveMath.ZERO) != 0) {
            int tmpDiagDimMinusOne1;
            int tmpDiagDim1 = PrimitiveMath.SQRT.invoke(mtrxH.length);
            for (int ij = tmpDiagDimMinusOne1 = tmpDiagDim1 - 1; ij >= 0; --ij) {
                double t;
                double y1;
                double x1;
                double w1;
                int i;
                int l;
                double p1 = d[ij];
                double q1 = e[ij];
                if (q1 == 0.0) {
                    l = ij;
                    mtrxH[ij + tmpDiagDim1 * ij] = 1.0;
                    for (i = ij - 1; i >= 0; --i) {
                        int j;
                        w1 = mtrxH[i + tmpDiagDim1 * i] - p1;
                        r = PrimitiveMath.ZERO;
                        for (j = l; j <= ij; ++j) {
                            r += mtrxH[i + tmpDiagDim1 * j] * mtrxH[j + tmpDiagDim1 * ij];
                        }
                        if (e[i] < PrimitiveMath.ZERO) {
                            z = w1;
                            s = r;
                            continue;
                        }
                        l = i;
                        if (e[i] == PrimitiveMath.ZERO) {
                            mtrxH[i + tmpDiagDim1 * ij] = NumberContext.compare(w1, PrimitiveMath.ZERO) != 0 ? -r / w1 : -r / (PrimitiveMath.MACHINE_EPSILON * tmpNorm1);
                        } else {
                            x1 = mtrxH[i + tmpDiagDim1 * (i + 1)];
                            y1 = mtrxH[i + 1 + tmpDiagDim1 * i];
                            q1 = (d[i] - p1) * (d[i] - p1) + e[i] * e[i];
                            mtrxH[i + tmpDiagDim1 * ij] = t = (x1 * s - z * r) / q1;
                            mtrxH[i + 1 + tmpDiagDim1 * ij] = PrimitiveMath.ABS.invoke(x1) > PrimitiveMath.ABS.invoke(z) ? (-r - w1 * t) / x1 : (-s - y1 * t) / z;
                        }
                        t = PrimitiveMath.ABS.invoke(mtrxH[i + tmpDiagDim1 * ij]);
                        if (!(PrimitiveMath.MACHINE_EPSILON * t * t > 1.0)) continue;
                        for (j = i; j <= ij; ++j) {
                            mtrxH[j + tmpDiagDim1 * ij] = mtrxH[j + tmpDiagDim1 * ij] / t;
                        }
                    }
                    continue;
                }
                if (!(q1 < 0.0)) continue;
                l = ij - 1;
                if (PrimitiveMath.ABS.invoke(mtrxH[ij + tmpDiagDim1 * (ij - 1)]) > PrimitiveMath.ABS.invoke(mtrxH[ij - 1 + tmpDiagDim1 * ij])) {
                    mtrxH[ij - 1 + tmpDiagDim1 * (ij - 1)] = q1 / mtrxH[ij + tmpDiagDim1 * (ij - 1)];
                    mtrxH[ij - 1 + tmpDiagDim1 * ij] = -(mtrxH[ij + tmpDiagDim1 * ij] - p1) / mtrxH[ij + tmpDiagDim1 * (ij - 1)];
                } else {
                    ComplexNumber tmpX = ComplexNumber.of(PrimitiveMath.ZERO, -mtrxH[ij - 1 + tmpDiagDim1 * ij]);
                    double imaginary = q1;
                    ComplexNumber tmpY = ComplexNumber.of(mtrxH[ij - 1 + tmpDiagDim1 * (ij - 1)] - p1, imaginary);
                    ComplexNumber tmpZ = tmpX.divide(tmpY);
                    mtrxH[ij - 1 + tmpDiagDim1 * (ij - 1)] = tmpZ.doubleValue();
                    mtrxH[ij - 1 + tmpDiagDim1 * ij] = tmpZ.i;
                }
                mtrxH[ij + tmpDiagDim1 * (ij - 1)] = PrimitiveMath.ZERO;
                mtrxH[ij + tmpDiagDim1 * ij] = 1.0;
                for (i = ij - 2; i >= 0; --i) {
                    ComplexNumber tmpZ;
                    ComplexNumber tmpY;
                    double imaginary;
                    double real;
                    ComplexNumber tmpX;
                    double ra = PrimitiveMath.ZERO;
                    double sa = PrimitiveMath.ZERO;
                    for (int j = l; j <= ij; ++j) {
                        ra += mtrxH[i + tmpDiagDim1 * j] * mtrxH[j + tmpDiagDim1 * (ij - 1)];
                        sa += mtrxH[i + tmpDiagDim1 * j] * mtrxH[j + tmpDiagDim1 * ij];
                    }
                    w1 = mtrxH[i + tmpDiagDim1 * i] - p1;
                    if (e[i] < PrimitiveMath.ZERO) {
                        z = w1;
                        r = ra;
                        s = sa;
                        continue;
                    }
                    l = i;
                    if (e[i] == 0.0) {
                        tmpX = ComplexNumber.of(-ra, -sa);
                        real = w1;
                        imaginary = q1;
                        tmpY = ComplexNumber.of(real, imaginary);
                        tmpZ = tmpX.divide(tmpY);
                        mtrxH[i + tmpDiagDim1 * (ij - 1)] = tmpZ.doubleValue();
                        mtrxH[i + tmpDiagDim1 * ij] = tmpZ.i;
                    } else {
                        x1 = mtrxH[i + tmpDiagDim1 * (i + 1)];
                        y1 = mtrxH[i + 1 + tmpDiagDim1 * i];
                        double vr = (d[i] - p1) * (d[i] - p1) + e[i] * e[i] - q1 * q1;
                        double vi = (d[i] - p1) * 2.0 * q1;
                        if (NumberContext.compare(vr, PrimitiveMath.ZERO) == 0 && NumberContext.compare(vi, PrimitiveMath.ZERO) == 0) {
                            vr = PrimitiveMath.MACHINE_EPSILON * tmpNorm1 * (PrimitiveMath.ABS.invoke(w1) + PrimitiveMath.ABS.invoke(q1) + PrimitiveMath.ABS.invoke(x1) + PrimitiveMath.ABS.invoke(y1) + PrimitiveMath.ABS.invoke(z));
                        }
                        tmpX = ComplexNumber.of(x1 * r - z * ra + q1 * sa, x1 * s - z * sa - q1 * ra);
                        real = vr;
                        imaginary = vi;
                        tmpY = ComplexNumber.of(real, imaginary);
                        tmpZ = tmpX.divide(tmpY);
                        mtrxH[i + tmpDiagDim1 * (ij - 1)] = tmpZ.doubleValue();
                        mtrxH[i + tmpDiagDim1 * ij] = tmpZ.i;
                        if (PrimitiveMath.ABS.invoke(x1) > PrimitiveMath.ABS.invoke(z) + PrimitiveMath.ABS.invoke(q1)) {
                            mtrxH[i + 1 + tmpDiagDim1 * (ij - 1)] = (-ra - w1 * mtrxH[i + tmpDiagDim1 * (ij - 1)] + q1 * mtrxH[i + tmpDiagDim1 * ij]) / x1;
                            mtrxH[i + 1 + tmpDiagDim1 * ij] = (-sa - w1 * mtrxH[i + tmpDiagDim1 * ij] - q1 * mtrxH[i + tmpDiagDim1 * (ij - 1)]) / x1;
                        } else {
                            ComplexNumber tmpX1 = ComplexNumber.of(-r - y1 * mtrxH[i + tmpDiagDim1 * (ij - 1)], -s - y1 * mtrxH[i + tmpDiagDim1 * ij]);
                            double real1 = z;
                            double imaginary1 = q1;
                            ComplexNumber tmpY1 = ComplexNumber.of(real1, imaginary1);
                            ComplexNumber tmpZ1 = tmpX1.divide(tmpY1);
                            mtrxH[i + 1 + tmpDiagDim1 * (ij - 1)] = tmpZ1.doubleValue();
                            mtrxH[i + 1 + tmpDiagDim1 * ij] = tmpZ1.i;
                        }
                    }
                    t = PrimitiveMath.MAX.invoke(PrimitiveMath.ABS.invoke(mtrxH[i + tmpDiagDim1 * (ij - 1)]), PrimitiveMath.ABS.invoke(mtrxH[i + tmpDiagDim1 * ij]));
                    if (!(PrimitiveMath.MACHINE_EPSILON * t * t > 1.0)) continue;
                    for (int j = i; j <= ij; ++j) {
                        mtrxH[j + tmpDiagDim1 * (ij - 1)] = mtrxH[j + tmpDiagDim1 * (ij - 1)] / t;
                        mtrxH[j + tmpDiagDim1 * ij] = mtrxH[j + tmpDiagDim1 * ij] / t;
                    }
                }
            }
            for (int j = tmpDiagDimMinusOne1; j >= 0; --j) {
                for (int i = 0; i <= tmpDiagDimMinusOne1; ++i) {
                    z = PrimitiveMath.ZERO;
                    for (int k = 0; k <= j; ++k) {
                        z += mtrxV[i + tmpDiagDim1 * k] * mtrxH[k + tmpDiagDim1 * j];
                    }
                    mtrxV[i + tmpDiagDim1 * j] = z;
                }
            }
        }
        return new double[][]{d, e};
    }

    public static void orthes(double[] mtrxH, double[] trnspV, double[] vctrWork) {
        int ij;
        int size = vctrWork.length;
        int sizeM1 = size - 1;
        int sizeM2 = size - 2;
        for (ij = 0; ij < sizeM2; ++ij) {
            double f;
            int m = ij + 1;
            double tmpColNorm1 = PrimitiveMath.ZERO;
            for (int i = m; i < size; ++i) {
                tmpColNorm1 += PrimitiveMath.ABS.invoke(mtrxH[i + size * ij]);
            }
            if (NumberContext.compare(tmpColNorm1, PrimitiveMath.ZERO) == 0) continue;
            double tmpInvBeta = PrimitiveMath.ZERO;
            for (int i = sizeM1; i >= m; --i) {
                vctrWork[i] = mtrxH[i + size * ij] / tmpColNorm1;
                tmpInvBeta += vctrWork[i] * vctrWork[i];
            }
            double g = PrimitiveMath.SQRT.invoke(tmpInvBeta);
            if (vctrWork[m] > 0.0) {
                g = -g;
            }
            tmpInvBeta -= vctrWork[m] * g;
            vctrWork[m] = vctrWork[m] - g;
            for (int j = m; j < size; ++j) {
                int i;
                f = PrimitiveMath.ZERO;
                for (i = sizeM1; i >= m; --i) {
                    f += vctrWork[i] * mtrxH[i + size * j];
                }
                f /= tmpInvBeta;
                for (i = m; i <= sizeM1; ++i) {
                    int n = i + size * j;
                    mtrxH[n] = mtrxH[n] - f * vctrWork[i];
                }
            }
            for (int i = 0; i < size; ++i) {
                int j;
                f = PrimitiveMath.ZERO;
                for (j = sizeM1; j >= m; --j) {
                    f += vctrWork[j] * mtrxH[i + size * j];
                }
                f /= tmpInvBeta;
                for (j = m; j < size; ++j) {
                    int n = i + size * j;
                    mtrxH[n] = mtrxH[n] - f * vctrWork[j];
                }
            }
            vctrWork[m] = tmpColNorm1 * vctrWork[m];
            mtrxH[m + size * ij] = tmpColNorm1 * g;
        }
        for (ij = sizeM2; ij >= 1; --ij) {
            int tmpIndex = ij + size * (ij - 1);
            if (mtrxH[tmpIndex] == PrimitiveMath.ZERO) continue;
            for (int i = ij + 1; i <= sizeM1; ++i) {
                vctrWork[i] = mtrxH[i + size * (ij - 1)];
            }
            for (int j = ij; j <= sizeM1; ++j) {
                int i;
                double g = PrimitiveMath.ZERO;
                for (i = ij; i <= sizeM1; ++i) {
                    g += vctrWork[i] * trnspV[i + size * j];
                }
                g = g / vctrWork[ij] / mtrxH[tmpIndex];
                for (i = ij; i <= sizeM1; ++i) {
                    int n = i + size * j;
                    trnspV[n] = trnspV[n] + g * vctrWork[i];
                }
            }
        }
    }
}

