/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import java.util.Optional;
import java.util.function.Supplier;
import org.ojalgo.function.special.MissingMath;
import org.ojalgo.matrix.Provider2D;
import org.ojalgo.matrix.store.ElementsSupplier;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.task.DeterminantTask;
import org.ojalgo.matrix.task.InverterTask;
import org.ojalgo.matrix.task.SolverTask;
import org.ojalgo.matrix.transformation.InvertibleFactor;
import org.ojalgo.structure.Access2D;
import org.ojalgo.structure.Structure2D;

public interface MatrixDecomposition<N extends Comparable<N>>
extends Structure2D {
    public static final Structure2D TYPICAL = new Structure2D(){

        @Override
        public long countColumns() {
            return 50L;
        }

        @Override
        public long countRows() {
            return 50L;
        }
    };

    public boolean decompose(Access2D.Collectable<N, ? super PhysicalStore<N>> var1);

    public boolean isComputed();

    public MatrixStore<N> reconstruct();

    public void reset();

    public static interface Values<N extends Comparable<N>>
    extends Ordered<N> {
        public boolean computeValuesOnly(Access2D.Collectable<N, ? super PhysicalStore<N>> var1);
    }

    public static interface Solver<N extends Comparable<N>>
    extends MatrixDecomposition<N>,
    SolverTask<N>,
    InverterTask<N>,
    Provider2D.Inverse<Optional<MatrixStore<N>>>,
    Provider2D.Solution<Optional<MatrixStore<N>>>,
    InvertibleFactor<N> {
        default public boolean compute(Access2D.Collectable<N, ? super PhysicalStore<N>> matrix) {
            return this.decompose(matrix) && this.isSolvable();
        }

        @Override
        default public void ftran(Access2D.Collectable<N, ? super PhysicalStore<N>> rhs, PhysicalStore<N> solution) {
            this.getSolution(rhs, solution);
        }

        @Override
        default public void ftran(PhysicalStore<N> arg) {
            this.ftran(arg, arg);
        }

        public MatrixStore<N> getInverse();

        public MatrixStore<N> getInverse(PhysicalStore<N> var1);

        public MatrixStore<N> getSolution(Access2D.Collectable<N, ? super PhysicalStore<N>> var1);

        public MatrixStore<N> getSolution(Access2D.Collectable<N, ? super PhysicalStore<N>> var1, PhysicalStore<N> var2);

        @Override
        default public Optional<MatrixStore<N>> invert() {
            if (this.isSolvable()) {
                return Optional.of(this.getInverse());
            }
            return Optional.empty();
        }

        public boolean isSolvable();

        @Override
        default public Optional<MatrixStore<N>> solve(Access2D<?> rhs) {
            if (this.isSolvable()) {
                return Optional.of(this.getSolution(rhs.asCollectable2D()));
            }
            return Optional.empty();
        }

        @Override
        default public Provider2D.Inverse<Optional<MatrixStore<N>>> toInverseProvider(ElementsSupplier<N> original, Supplier<MatrixStore<N>> alternativeOriginalSupplier) {
            boolean ok = this.decompose(original);
            if (ok && this.isSolvable()) {
                return this;
            }
            return Optional::empty;
        }

        @Override
        default public Provider2D.Solution<Optional<MatrixStore<N>>> toSolutionProvider(ElementsSupplier<N> body, Supplier<MatrixStore<N>> alternativeBodySupplier, Access2D<?> rhs) {
            boolean ok = this.decompose(body);
            if (ok && this.isSolvable()) {
                return this;
            }
            return r -> Optional.empty();
        }
    }

    public static interface RankRevealing<N extends Comparable<N>>
    extends Ordered<N>,
    Provider2D.Rank {
        public int countSignificant(double var1);

        @Override
        default public int getRank() {
            return this.countSignificant(this.getRankThreshold());
        }

        public double getRankThreshold();

        default public boolean isFullRank() {
            return this.getRank() == MissingMath.toMinIntExact(this.countRows(), this.countColumns());
        }
    }

    public static interface Pivoting<N extends Comparable<N>>
    extends MatrixDecomposition<N> {
        default public boolean decomposeWithoutPivoting(Access2D.Collectable<N, ? super PhysicalStore<N>> matrix) {
            return this.decompose(matrix);
        }

        public int[] getPivotOrder();

        public int[] getReversePivotOrder();

        public boolean isPivoted();
    }

    public static interface Ordered<N extends Comparable<N>>
    extends MatrixDecomposition<N> {
        public boolean isOrdered();
    }

    public static interface Hermitian<N extends Comparable<N>>
    extends MatrixDecomposition<N> {
        default public boolean checkAndDecompose(MatrixStore<N> matrix) {
            this.reset();
            if (matrix.isHermitian()) {
                return this.decompose(matrix);
            }
            return false;
        }
    }

    public static interface Factory<D extends MatrixDecomposition<?>> {
        default public D make() {
            return this.make(TYPICAL);
        }

        default public D make(final int numberOfRows, final int numberOfColumns) {
            return this.make(new Structure2D(){

                @Override
                public long countColumns() {
                    return numberOfColumns;
                }

                @Override
                public long countRows() {
                    return numberOfRows;
                }
            });
        }

        public D make(Structure2D var1);
    }

    public static interface EconomySize<N extends Comparable<N>>
    extends MatrixDecomposition<N> {
        public boolean isFullSize();
    }

    public static interface Determinant<N extends Comparable<N>>
    extends MatrixDecomposition<N>,
    DeterminantTask<N>,
    Provider2D.Determinant<N> {
        @Override
        public N getDeterminant();

        @Override
        default public Provider2D.Determinant<N> toDeterminantProvider(ElementsSupplier<N> original, Supplier<MatrixStore<N>> alternativeOriginalSupplier) {
            this.decompose(original);
            return this;
        }
    }
}

