/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import org.ojalgo.matrix.decomposition.DeferredTridiagonal;
import org.ojalgo.matrix.decomposition.MatrixDecomposition;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.Quadruple;
import org.ojalgo.scalar.Quaternion;
import org.ojalgo.scalar.RationalNumber;
import org.ojalgo.structure.Access2D;
import org.ojalgo.type.context.NumberContext;

public interface Tridiagonal<N extends Comparable<N>>
extends MatrixDecomposition<N> {
    public static final Factory<ComplexNumber> C128 = typical -> new DeferredTridiagonal.C128();
    public static final Factory<Double> R064 = typical -> new DeferredTridiagonal.R064();
    public static final Factory<Quadruple> R128 = typical -> new DeferredTridiagonal.R128();
    public static final Factory<Quaternion> H256 = typical -> new DeferredTridiagonal.H256();
    public static final Factory<RationalNumber> Q128 = typical -> new DeferredTridiagonal.Q128();
    @Deprecated
    public static final Factory<ComplexNumber> COMPLEX = C128;
    @Deprecated
    public static final Factory<Double> PRIMITIVE = R064;
    @Deprecated
    public static final Factory<Quaternion> QUATERNION = H256;
    @Deprecated
    public static final Factory<RationalNumber> RATIONAL = Q128;

    public static <N extends Comparable<N>> boolean equals(MatrixStore<N> matrix, Tridiagonal<N> decomposition, NumberContext context) {
        boolean retVal = true;
        retVal &= Access2D.equals(matrix, decomposition.reconstruct(), context);
        MatrixStore<Object> mtrxQ = decomposition.getQ();
        Object identity = mtrxQ.physical().makeEye(mtrxQ.countRows(), mtrxQ.countColumns());
        MatrixStore<Object> qqh = mtrxQ.multiply(mtrxQ.conjugate());
        retVal &= qqh.equals((MatrixStore<Object>)identity, context);
        MatrixStore<MatrixStore<N>> qhq = mtrxQ.conjugate().multiply(mtrxQ);
        return retVal &= qhq.equals((MatrixStore<MatrixStore<N>>)identity, context);
    }

    public MatrixStore<N> getD();

    public MatrixStore<N> getQ();

    @Override
    default public MatrixStore<N> reconstruct() {
        MatrixStore<MatrixStore<N>> mtrxQ = this.getQ();
        MatrixStore<N> mtrxD = this.getD();
        return mtrxQ.multiply(mtrxD).multiply((MatrixStore<Object>)mtrxQ.conjugate());
    }

    public static interface Factory<N extends Comparable<N>>
    extends MatrixDecomposition.Factory<Tridiagonal<N>> {
    }
}

