/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store;

import org.ojalgo.ProgrammingError;
import org.ojalgo.matrix.store.AboveBelowStore;
import org.ojalgo.matrix.store.LeftRightStore;
import org.ojalgo.matrix.store.LogicalStore;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.TransposedStore;
import org.ojalgo.matrix.store.WrapperStore;
import org.ojalgo.matrix.store.ZeroStore;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Access2D;

abstract class AbstractStore<N extends Comparable<N>>
implements MatrixStore<N> {
    private final int myColDim;
    private transient Class<?> myComponentType = null;
    private final int myRowDim;

    @SafeVarargs
    static <N extends Comparable<N>> MatrixStore<N> buildColumn(PhysicalStore.Factory<N, ?> factory, long rowsCount, Access2D<N> ... columnStores) {
        MatrixStore<N> retVal = AbstractStore.cast(factory, columnStores[0]);
        for (int i = 1; i < columnStores.length; ++i) {
            retVal = new AboveBelowStore<N>(retVal, AbstractStore.cast(factory, columnStores[i]));
        }
        long rowsSoFar = retVal.countRows();
        if (rowsSoFar < rowsCount) {
            retVal = new AboveBelowStore<N>(retVal, new ZeroStore<N>(retVal.physical(), rowsCount - rowsSoFar, retVal.countColumns()));
        }
        return retVal;
    }

    static <N extends Comparable<N>> MatrixStore<N> buildColumn(PhysicalStore.Factory<N, ?> factory, long rowsCount, Access2D<N> columnStore) {
        MatrixStore<N> retVal = AbstractStore.cast(factory, columnStore);
        long rowsSoFar = retVal.countRows();
        if (rowsSoFar < rowsCount) {
            retVal = new AboveBelowStore<N>(retVal, new ZeroStore<N>(retVal.physical(), rowsCount - rowsSoFar, retVal.countColumns()));
        }
        return retVal;
    }

    @SafeVarargs
    static <N extends Comparable<N>> MatrixStore<N> buildColumn(PhysicalStore.Factory<N, ?> factory, long rowsCount, N ... columnElements) {
        AboveBelowStore<N> retVal = (AboveBelowStore<N>)factory.columns(new Comparable[][]{columnElements});
        long rowsSoFar = retVal.countRows();
        if (rowsSoFar < rowsCount) {
            retVal = new AboveBelowStore<N>(retVal, new ZeroStore<N>(factory, rowsCount - rowsSoFar, retVal.countColumns()));
        }
        return retVal;
    }

    @SafeVarargs
    static <N extends Comparable<N>> MatrixStore<N> buildRow(PhysicalStore.Factory<N, ?> factory, long colsCount, Access2D<N> ... rowStores) {
        MatrixStore<N> retVal = AbstractStore.cast(factory, rowStores[0]);
        for (int j = 1; j < rowStores.length; ++j) {
            retVal = new LeftRightStore<N>(retVal, AbstractStore.cast(factory, rowStores[j]));
        }
        long colsSoFar = retVal.countColumns();
        if (colsSoFar < colsCount) {
            retVal = new LeftRightStore<N>(retVal, new ZeroStore<N>(retVal.physical(), retVal.countRows(), colsCount - colsSoFar));
        }
        return retVal;
    }

    static <N extends Comparable<N>> MatrixStore<N> buildRow(PhysicalStore.Factory<N, ?> factory, long colsCount, Access2D<N> rowStore) {
        MatrixStore<N> retVal = AbstractStore.cast(factory, rowStore);
        long colsSoFar = retVal.countColumns();
        if (colsSoFar < colsCount) {
            retVal = new LeftRightStore<N>(retVal, new ZeroStore<N>(retVal.physical(), retVal.countRows(), colsCount - colsSoFar));
        }
        return retVal;
    }

    @SafeVarargs
    static <N extends Comparable<N>> MatrixStore<N> buildRow(PhysicalStore.Factory<N, ?> factory, long colsCount, N ... rowElements) {
        LogicalStore retVal = new TransposedStore((MatrixStore)factory.columns(new Comparable[][]{rowElements}));
        long colsSoFar = retVal.countColumns();
        if (colsSoFar < colsCount) {
            retVal = new LeftRightStore(retVal, new ZeroStore<N>(factory, retVal.countRows(), colsCount - colsSoFar));
        }
        return retVal;
    }

    static <N extends Comparable<N>> MatrixStore<N> cast(PhysicalStore.Factory<N, ?> factory, Access2D<?> access) {
        if (access instanceof MatrixStore) {
            return (MatrixStore)access;
        }
        return new WrapperStore<N>(factory, access);
    }

    private AbstractStore() {
        this(0, 0);
        ProgrammingError.throwForIllegalInvocation();
    }

    protected AbstractStore(int numberOfRows, int numberOfColumns) {
        this.myRowDim = numberOfRows;
        this.myColDim = numberOfColumns;
    }

    protected AbstractStore(long numberOfRows, long numberOfColumns) {
        this(Math.toIntExact(numberOfRows), Math.toIntExact(numberOfColumns));
    }

    @Override
    public long countColumns() {
        return this.myColDim;
    }

    @Override
    public long countRows() {
        return this.myRowDim;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AbstractStore)) {
            return false;
        }
        AbstractStore other = (AbstractStore)obj;
        if (this.myColDim != other.myColDim) {
            return false;
        }
        if (this.myComponentType == null ? other.myComponentType != null : !this.myComponentType.equals(other.myComponentType)) {
            return false;
        }
        return this.myRowDim == other.myRowDim;
    }

    @Override
    public final int getColDim() {
        return this.myColDim;
    }

    @Override
    public final int getMaxDim() {
        return Math.max(this.myRowDim, this.myColDim);
    }

    @Override
    public final int getMinDim() {
        return Math.min(this.myRowDim, this.myColDim);
    }

    @Override
    public final int getRowDim() {
        return this.myRowDim;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.myColDim;
        result = 31 * result + (this.myComponentType == null ? 0 : this.myComponentType.hashCode());
        result = 31 * result + this.myRowDim;
        return result;
    }

    @Override
    public int limitOfColumn(int col) {
        return this.myRowDim;
    }

    @Override
    public int limitOfRow(int row) {
        return this.myColDim;
    }

    @Override
    public N multiplyBoth(Access1D<N> leftAndRight) {
        if (this.isPrimitive()) {
            PhysicalStore tmpStep1 = (PhysicalStore)this.physical().make(1L, leftAndRight.count());
            tmpStep1.fillByMultiplying(leftAndRight, this);
            PhysicalStore tmpStep2 = (PhysicalStore)this.physical().make(1L, 1L);
            tmpStep2.fillByMultiplying(tmpStep1, leftAndRight);
            return tmpStep2.get(0L);
        }
        return MatrixStore.super.multiplyBoth(leftAndRight);
    }

    public final String toString() {
        return Access2D.toString(this);
    }

    protected final boolean isPrimitive() {
        return this.getComponentType().equals(Double.class);
    }

    final Class<?> getComponentType() {
        if (this.myComponentType == null) {
            this.myComponentType = this.get(0L, 0L).getClass();
        }
        return this.myComponentType;
    }
}

