/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store;

import org.ojalgo.function.VoidFunction;
import org.ojalgo.function.aggregator.Aggregator;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.TransformableRegion;
import org.ojalgo.matrix.store.TransjugatedStore;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Structure2D;

final class TransposedStore<N extends Comparable<N>>
extends TransjugatedStore<N> {
    TransposedStore(MatrixStore<N> base) {
        super(base);
    }

    @Override
    public N aggregateColumn(long col, Aggregator aggregator) {
        return this.base().aggregateRow(col, aggregator);
    }

    @Override
    public N aggregateRow(long row, Aggregator aggregator) {
        return this.base().aggregateColumn(row, aggregator);
    }

    @Override
    public N get(long aRow, long aCol) {
        return this.base().get(aCol, aRow);
    }

    @Override
    public void loopColumn(long col, Structure2D.RowColumnCallback callback) {
        this.base().loopRow(col, callback);
    }

    @Override
    public void loopRow(long row, Structure2D.RowColumnCallback callback) {
        this.base().loopColumn(row, callback);
    }

    @Override
    public MatrixStore<N> multiply(MatrixStore<N> right) {
        MatrixStore<MatrixStore<N>> retVal;
        if (right instanceof TransposedStore) {
            retVal = ((TransposedStore)right).getOriginal().multiply(this.base());
            retVal = new TransposedStore<MatrixStore<MatrixStore<N>>>(retVal);
        } else {
            retVal = super.multiply(right);
        }
        return retVal;
    }

    @Override
    public Access1D<N> sliceColumn(long col) {
        return this.base().sliceRow(col);
    }

    @Override
    public Access1D<N> sliceRow(long row) {
        return this.base().sliceColumn(row);
    }

    @Override
    public void supplyTo(TransformableRegion<N> receiver) {
        this.base().supplyTo(receiver.regionByTransposing());
    }

    @Override
    public Scalar<N> toScalar(long row, long column) {
        return this.base().toScalar(column, row);
    }

    @Override
    public MatrixStore<N> transpose() {
        return this.base();
    }

    @Override
    public void visitColumn(long col, VoidFunction<N> visitor) {
        this.base().visitRow(col, visitor);
    }

    @Override
    public void visitRow(long row, VoidFunction<N> visitor) {
        this.base().visitColumn(row, visitor);
    }
}

