/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store;

import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.ShadingStore;
import org.ojalgo.scalar.Scalar;

final class UpperSymmetricStore<N extends Comparable<N>>
extends ShadingStore<N> {
    private final boolean myHermitian;

    UpperSymmetricStore(MatrixStore<N> base, boolean hermitian) {
        super(base);
        this.myHermitian = hermitian;
    }

    @Override
    public double doubleValue(long row, long col) {
        if (row > col) {
            return this.base().doubleValue(col, row);
        }
        return this.base().doubleValue(row, col);
    }

    @Override
    public N get(long row, long col) {
        if (this.myHermitian) {
            return (N)((Comparable)this.toScalar(row, col).get());
        }
        if (row > col) {
            return this.base().get(col, row);
        }
        return this.base().get(row, col);
    }

    @Override
    public Scalar<N> toScalar(long row, long col) {
        if (row <= col) {
            return this.base().toScalar(row, col);
        }
        if (this.myHermitian) {
            return (Scalar)this.base().toScalar(col, row).conjugate();
        }
        return this.base().toScalar(col, row);
    }
}

