/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.task.iterative;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ojalgo.RecoverableCondition;
import org.ojalgo.equation.Equation;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.task.iterative.IterativeSolverTask;
import org.ojalgo.netio.BasicLogger;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Access2D;
import org.ojalgo.type.context.NumberContext;

public abstract class MutableSolver<D extends IterativeSolverTask>
extends IterativeSolverTask {
    private final D myDelegate;
    private final List<Equation> myRows = new ArrayList<Equation>();
    private final long mySize;

    private MutableSolver() {
        this.myDelegate = null;
        this.mySize = 0L;
    }

    protected MutableSolver(D delegate, long size) {
        this.myDelegate = delegate;
        this.mySize = size;
    }

    public boolean add(Equation row) {
        if (row.count() != this.mySize) {
            BasicLogger.error("row.count(): {} != mySize: {}", row.count(), this.mySize);
            throw new IllegalArgumentException();
        }
        boolean retVal = this.myRows.add(row);
        Collections.sort(this.myRows);
        return retVal;
    }

    public void clear() {
        this.myRows.clear();
    }

    public double[] getRHS() {
        return this.myRows.stream().mapToDouble(Equation::getRHS).toArray();
    }

    public boolean remove(Equation row) {
        return this.myRows.remove(row);
    }

    public final double resolve(PhysicalStore<Double> solution) {
        return ((IterativeSolverTask.SparseDelegate)this.myDelegate).resolve(this.myRows, solution);
    }

    public final double resolve(PhysicalStore<Double> solution, Access1D<?> rhs) {
        return ((IterativeSolverTask.SparseDelegate)this.myDelegate).resolve(this.myRows, solution, rhs);
    }

    @Override
    public MatrixStore<Double> solve(Access2D<?> body, Access2D<?> rhs, PhysicalStore<Double> current) throws RecoverableCondition {
        return this.myDelegate.solve(body, rhs, current);
    }

    protected double doubleValue(int row, int col) {
        return this.myRows.get(row).doubleValue(col);
    }

    protected final D getDelegate() {
        return this.myDelegate;
    }

    @Override
    protected void setAccuracyContext(NumberContext accuracyContext) {
        super.setAccuracyContext(accuracyContext);
        ((IterativeSolverTask)this.myDelegate).setAccuracyContext(accuracyContext);
    }

    @Override
    protected void setDebugPrinter(BasicLogger debugPrinter) {
        super.setDebugPrinter(debugPrinter);
        ((IterativeSolverTask)this.myDelegate).setDebugPrinter(debugPrinter);
    }

    @Override
    protected void setIterationsLimit(int iterationsLimit) {
        super.setIterationsLimit(iterationsLimit);
        ((IterativeSolverTask)this.myDelegate).setIterationsLimit(iterationsLimit);
    }
}

