/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.netio;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.ojalgo.netio.TextLineReader;

@FunctionalInterface
public interface BasicParser<T>
extends TextLineReader.Parser<T> {
    default public void parse(File file, boolean skipHeader, Consumer<T> consumer) {
        try (TextLineReader supplier = TextLineReader.of(file);){
            this.parse(supplier, skipHeader, consumer);
        }
        catch (IOException cause) {
            throw new RuntimeException(cause);
        }
    }

    default public void parse(File file, Consumer<T> consumer) {
        this.parse(file, false, consumer);
    }

    default public void parse(Reader reader, boolean skipHeader, Consumer<T> consumer) {
        try (TextLineReader supplier = new TextLineReader(reader);){
            this.parse(supplier, skipHeader, consumer);
        }
        catch (IOException cause) {
            throw new RuntimeException(cause);
        }
    }

    default public void parse(Reader reader, Consumer<T> consumer) {
        this.parse(reader, false, consumer);
    }

    default public void parse(String filePath, boolean skipHeader, Consumer<T> consumer) {
        this.parse(new File(filePath), skipHeader, consumer);
    }

    default public void parse(String filePath, Consumer<T> consumer) {
        this.parse(filePath, false, consumer);
    }

    default public void parse(Supplier<String> lineSupplier, boolean skipHeader, Consumer<T> consumer) {
        String line = null;
        Object item = null;
        if (skipHeader) {
            line = lineSupplier.get();
            line = null;
        }
        while ((line = lineSupplier.get()) != null) {
            if (!TextLineReader.isLineOK(line)) continue;
            Object t = this.parse(line);
            item = t;
            if (t == null) continue;
            consumer.accept(item);
        }
    }

    default public void parse(Supplier<String> lineSupplier, Consumer<T> consumer) {
        this.parse(lineSupplier, false, consumer);
    }
}

