/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.math.BigDecimal;
import java.util.Map;
import org.ojalgo.optimisation.Expression;
import org.ojalgo.optimisation.ExpressionsBasedModel;
import org.ojalgo.optimisation.ModelEntity;
import org.ojalgo.optimisation.Variable;
import org.ojalgo.structure.Structure1D;
import org.ojalgo.structure.Structure2D;

abstract class FileFormatEBM {
    private static final String TAB = String.valueOf('\t');

    private static Expression readExpression(ExpressionsBasedModel model, String[] fields) {
        Expression expression = model.newExpression(fields[1]);
        FileFormatEBM.readModelEntity(expression, fields);
        return expression;
    }

    private static void readLinear(Expression current, String[] fields) {
        int index = Integer.parseInt(fields[1]);
        BigDecimal value = new BigDecimal(fields[2]);
        current.set(index, value);
    }

    private static void readModelEntity(ModelEntity<?> entity, String[] fields) {
        if (fields.length > 2 && fields[2].length() > 0) {
            entity.lower(new BigDecimal(fields[2]));
        }
        if (fields.length > 3 && fields[3].length() > 0) {
            entity.upper(new BigDecimal(fields[3]));
        }
        if (fields.length > 4 && fields[4].length() > 0) {
            entity.weight(new BigDecimal(fields[4]));
        }
    }

    private static void readQuadratic(Expression current, String[] fields) {
        int row = Integer.parseInt(fields[1]);
        int col = Integer.parseInt(fields[2]);
        BigDecimal value = new BigDecimal(fields[3]);
        current.set(row, col, value);
    }

    private static void readVariable(ExpressionsBasedModel model, String[] fields) {
        Variable variable = model.newVariable(fields[1]);
        FileFormatEBM.readModelEntity(variable, fields);
        variable.integer(Boolean.parseBoolean(fields[5]));
        if (fields.length > 6 && fields[6].length() > 0) {
            variable.setValue(new BigDecimal(fields[6]));
        }
    }

    private static void writeExpression(Expression expression, BufferedWriter writer) throws IOException {
        writer.write("E");
        FileFormatEBM.writeModelEntity(expression, writer);
        writer.newLine();
    }

    private static void writeLinear(Map.Entry<Structure1D.IntIndex, BigDecimal> entry, BufferedWriter writer) throws IOException {
        writer.write("L");
        writer.write(9);
        writer.write(Integer.toString(entry.getKey().index));
        writer.write(9);
        writer.write(entry.getValue().toPlainString());
        writer.newLine();
    }

    private static void writeModelEntity(ModelEntity<?> entity, BufferedWriter writer) throws IOException {
        String name = entity.getName().replace('\t', '\u00a0');
        BigDecimal lower = entity.getLowerLimit();
        BigDecimal upper = entity.getUpperLimit();
        BigDecimal weight = entity.getContributionWeight();
        writer.write(9);
        writer.write(name);
        writer.write(9);
        if (lower != null) {
            writer.write(lower.toPlainString());
        }
        writer.write(9);
        if (upper != null) {
            writer.write(upper.toPlainString());
        }
        writer.write(9);
        if (weight != null) {
            writer.write(weight.toPlainString());
        }
    }

    private static void writeQuadratic(Map.Entry<Structure2D.IntRowColumn, BigDecimal> entry, BufferedWriter writer) throws IOException {
        writer.write("Q");
        writer.write(9);
        writer.write(Integer.toString(entry.getKey().row));
        writer.write(9);
        writer.write(Integer.toString(entry.getKey().column));
        writer.write(9);
        writer.write(entry.getValue().toPlainString());
        writer.newLine();
    }

    private static void writeVariable(Variable variable, BufferedWriter writer) throws IOException {
        writer.write("V");
        FileFormatEBM.writeModelEntity(variable, writer);
        writer.write(9);
        writer.write(Boolean.toString(variable.isInteger()));
        writer.write(9);
        BigDecimal value = variable.getValue();
        if (value != null) {
            writer.write(value.toPlainString());
        }
        writer.newLine();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static ExpressionsBasedModel read(InputStream input) {
        ExpressionsBasedModel retVal = new ExpressionsBasedModel();
        Expression current = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(input));){
            block13: while (true) {
                String line = reader.readLine();
                if (line == null) return retVal;
                String[] fields = line.split(TAB);
                switch (line.charAt(0)) {
                    case 'V': {
                        FileFormatEBM.readVariable(retVal, fields);
                        continue block13;
                    }
                    case 'E': {
                        current = FileFormatEBM.readExpression(retVal, fields);
                        continue block13;
                    }
                    case 'L': {
                        if (current == null) {
                            throw new IllegalStateException();
                        }
                        FileFormatEBM.readLinear(current, fields);
                        continue block13;
                    }
                    case 'Q': {
                        if (current == null) {
                            throw new IllegalStateException();
                        }
                        FileFormatEBM.readQuadratic(current, fields);
                        continue block13;
                    }
                }
                break;
            }
            throw new IllegalStateException();
        }
        catch (IOException cause) {
            throw new RuntimeException(cause);
        }
    }

    static void write(ExpressionsBasedModel model, OutputStream output) {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(output));){
            for (Variable variable : model.getVariables()) {
                FileFormatEBM.writeVariable(variable, writer);
            }
            for (Expression expression : model.getExpressions()) {
                FileFormatEBM.writeExpression(expression, writer);
                for (Map.Entry<Structure1D.IntIndex, BigDecimal> entry : expression.getLinearEntrySet()) {
                    FileFormatEBM.writeLinear(entry, writer);
                }
                for (Map.Entry<Comparable<Structure1D.IntIndex>, BigDecimal> entry : expression.getQuadraticEntrySet()) {
                    FileFormatEBM.writeQuadratic(entry, writer);
                }
            }
        }
        catch (IOException cause) {
            throw new RuntimeException(cause);
        }
    }

    private FileFormatEBM() {
    }
}

