/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.ojalgo.function.constant.BigMath;
import org.ojalgo.optimisation.Expression;
import org.ojalgo.optimisation.ExpressionsBasedModel;
import org.ojalgo.optimisation.Optimisation;
import org.ojalgo.optimisation.Variable;
import org.ojalgo.structure.Structure1D;
import org.ojalgo.type.context.NumberContext;

public abstract class Presolvers {
    public static final ExpressionsBasedModel.Presolver INTEGER = new ExpressionsBasedModel.Presolver(20){

        @Override
        public boolean simplify(Expression expression, Set<Structure1D.IntIndex> remaining, BigDecimal lower, BigDecimal upper, NumberContext precision) {
            expression.doIntegerRounding(remaining, lower, upper);
            return false;
        }
    };
    public static final ExpressionsBasedModel.Presolver LINEAR_OBJECTIVE = new ExpressionsBasedModel.Presolver(10){

        @Override
        public boolean simplify(Expression expression, Set<Structure1D.IntIndex> remaining, BigDecimal lower, BigDecimal upper, NumberContext precision) {
            if (expression.isFunctionLinear()) {
                BigDecimal exprWeight = expression.getContributionWeight();
                for (Map.Entry<Structure1D.IntIndex, BigDecimal> entry : expression.getLinearEntrySet()) {
                    Variable tmpVariable = expression.resolve(entry.getKey());
                    BigDecimal varWeight = tmpVariable.getContributionWeight();
                    BigDecimal contribution = exprWeight.multiply(entry.getValue());
                    varWeight = varWeight != null ? varWeight.add(contribution) : contribution;
                    tmpVariable.weight(varWeight);
                }
                expression.weight(null);
            }
            return false;
        }
    };
    public static final ExpressionsBasedModel.Presolver REDUNDANT_CONSTRAINT = new ExpressionsBasedModel.Presolver(30){

        @Override
        public boolean simplify(Expression expression, Set<Structure1D.IntIndex> remaining, BigDecimal lower, BigDecimal upper, NumberContext precision) {
            if (remaining.isEmpty()) {
                expression.setRedundant();
                return false;
            }
            if (expression.isFunctionLinear()) {
                BigDecimal min = BigMath.ZERO;
                BigDecimal max = BigMath.ZERO;
                for (Structure1D.IntIndex index : remaining) {
                    Variable variable = expression.resolve(index);
                    BigDecimal coefficient = expression.get(index);
                    if (coefficient.signum() < 0) {
                        if (max != null) {
                            max = variable.isLowerLimitSet() ? max.add(coefficient.multiply(variable.getLowerLimit())) : null;
                        }
                        if (min == null) continue;
                        if (variable.isUpperLimitSet()) {
                            min = min.add(coefficient.multiply(variable.getUpperLimit()));
                            continue;
                        }
                        min = null;
                        continue;
                    }
                    if (max != null) {
                        max = variable.isUpperLimitSet() ? max.add(coefficient.multiply(variable.getUpperLimit())) : null;
                    }
                    if (min == null) continue;
                    if (variable.isLowerLimitSet()) {
                        min = min.add(coefficient.multiply(variable.getLowerLimit()));
                        continue;
                    }
                    min = null;
                }
                boolean upperRedundant = false;
                if (upper != null) {
                    if (min != null && min.compareTo(upper) > 0 && Presolvers.findCommonLevel(upper, min) == null) {
                        expression.setInfeasible();
                    } else if (max != null && max.compareTo(upper) <= 0) {
                        upperRedundant = true;
                    }
                } else {
                    upperRedundant = true;
                }
                boolean lowerRedundant = false;
                if (lower != null) {
                    if (max != null && max.compareTo(lower) < 0 && Presolvers.findCommonLevel(lower, max) == null) {
                        expression.setInfeasible();
                    } else if (min != null && min.compareTo(lower) >= 0) {
                        lowerRedundant = true;
                    }
                } else {
                    lowerRedundant = true;
                }
                if (lowerRedundant && upperRedundant) {
                    expression.setRedundant();
                }
            }
            return false;
        }
    };
    public static final ExpressionsBasedModel.VariableAnalyser UNREFERENCED = new ExpressionsBasedModel.VariableAnalyser(4){

        @Override
        public boolean simplify(Variable variable, ExpressionsBasedModel model) {
            if (!model.isReferenced(variable)) {
                if (variable.isObjective()) {
                    int weightSignum = variable.getContributionWeight().signum();
                    if (model.getOptimisationSense() == Optimisation.Sense.MAX && weightSignum == -1 || model.getOptimisationSense() != Optimisation.Sense.MAX && weightSignum == 1) {
                        if (variable.isLowerLimitSet()) {
                            variable.setFixed(variable.getLowerLimit());
                        } else {
                            variable.setUnbounded(true);
                        }
                    } else if (model.getOptimisationSense() == Optimisation.Sense.MAX && weightSignum == 1 || model.getOptimisationSense() != Optimisation.Sense.MAX && weightSignum == -1) {
                        if (variable.isUpperLimitSet()) {
                            variable.setFixed(variable.getUpperLimit());
                        } else {
                            variable.setUnbounded(true);
                        }
                    }
                } else if (!variable.isValueSet()) {
                    variable.setValue(BigMath.ZERO);
                    variable.level(variable.getValue());
                }
            }
            return false;
        }
    };
    public static final ExpressionsBasedModel.Presolver ZERO_ONE_TWO = new ExpressionsBasedModel.Presolver(10){

        @Override
        public boolean simplify(Expression expression, Set<Structure1D.IntIndex> remaining, BigDecimal lower, BigDecimal upper, NumberContext precision) {
            switch (remaining.size()) {
                case 0: {
                    return Presolvers.doCase0(expression, remaining, lower, upper, precision);
                }
                case 1: {
                    return Presolvers.doCase1(expression, remaining, lower, upper, precision);
                }
                case 2: {
                    return Presolvers.doCase2(expression, remaining, lower, upper, precision);
                }
            }
            return Presolvers.doCaseN(expression, remaining, lower, upper, precision);
        }
    };
    private static final NumberContext LEVEL = NumberContext.of(12).withMode(RoundingMode.HALF_DOWN);
    private static final MathContext SIMILARITY = NumberContext.of(12).getMathContext();
    static final MathContext LOWER = NumberContext.ofMath(MathContext.DECIMAL128).withMode(RoundingMode.FLOOR).getMathContext();
    static final MathContext UPPER = NumberContext.ofMath(MathContext.DECIMAL128).withMode(RoundingMode.CEILING).getMathContext();

    public static void checkFeasibility(Expression expression, Set<Structure1D.IntIndex> remaining, BigDecimal lower, BigDecimal upper, NumberContext precision, boolean relaxed) {
        ZERO_ONE_TWO.simplify(expression, remaining, lower, upper, precision);
    }

    public static boolean checkSimilarity(Collection<Expression> current, Expression potential) {
        if (potential.isConstraint() && !potential.isRedundant()) {
            Set<Structure1D.IntIndex> potentialLinearKeySet = potential.getLinearKeySet();
            for (Expression expression : current) {
                BigDecimal subUp;
                if (!expression.isConstraint() || expression.isRedundant()) continue;
                Set<Structure1D.IntIndex> currentLinearKeySet = expression.getLinearKeySet();
                if (expression.getName().equals(potential.getName()) || !currentLinearKeySet.equals(potentialLinearKeySet)) continue;
                BigDecimal fctVal = null;
                BigDecimal tmpVal = null;
                for (Structure1D.IntIndex index : currentLinearKeySet) {
                    tmpVal = expression.get(index).divide(potential.get(index), SIMILARITY);
                    if (fctVal == null) {
                        fctVal = tmpVal;
                        continue;
                    }
                    if (tmpVal.compareTo(fctVal) == 0) continue;
                    fctVal = null;
                    break;
                }
                if (fctVal == null) continue;
                boolean pos = fctVal.signum() == 1;
                BigDecimal refLo = expression.getLowerLimit();
                BigDecimal refUp = expression.getUpperLimit();
                BigDecimal subLo = pos ? potential.getLowerLimit() : potential.getUpperLimit();
                BigDecimal bigDecimal = subUp = pos ? potential.getUpperLimit() : potential.getLowerLimit();
                if (fctVal.compareTo(BigMath.ONE) != 0) {
                    if (subLo != null) {
                        subLo = subLo.multiply(fctVal);
                    }
                    if (subUp != null) {
                        subUp = subUp.multiply(fctVal);
                    }
                }
                if (subLo != null) {
                    if (refLo != null) {
                        expression.lower(subLo.max(refLo));
                    } else {
                        expression.lower(subLo);
                    }
                }
                if (subUp != null) {
                    if (refUp != null) {
                        expression.upper(subUp.min(refUp));
                    } else {
                        expression.upper(subUp);
                    }
                }
                potential.setRedundant();
                return true;
            }
        }
        return false;
    }

    public static boolean reduce(Collection<Expression> expressions) {
        boolean retVal = false;
        for (Expression expression : expressions) {
            retVal |= Presolvers.checkSimilarity(expressions, expression);
        }
        return retVal;
    }

    static boolean doCase0(Expression expression, Set<Structure1D.IntIndex> remaining, BigDecimal lower, BigDecimal upper, NumberContext precision) {
        expression.setRedundant();
        if (lower != null && precision.isMoreThan(BigMath.ZERO, lower)) {
            expression.setInfeasible();
        }
        if (upper != null && precision.isLessThan(BigMath.ZERO, upper)) {
            expression.setInfeasible();
        }
        return false;
    }

    static boolean doCase1(Expression expression, Set<Structure1D.IntIndex> remaining, BigDecimal lower, BigDecimal upper, NumberContext precision) {
        BigDecimal level;
        BigDecimal upperCand;
        BigDecimal lowerCand;
        expression.setRedundant();
        Structure1D.IntIndex index = remaining.iterator().next();
        Variable variable = expression.resolve(index);
        BigDecimal factor = expression.get(index);
        boolean neg = factor.signum() == -1;
        BigDecimal lowerOld = variable.getLowerLimit();
        BigDecimal upperOld = variable.getUpperLimit();
        if (expression.isEqualityConstraint()) {
            BigDecimal solution = BigMath.DIVIDE.invoke(upper, factor);
            if (!variable.validate(solution, precision, null)) {
                expression.setInfeasible();
                return false;
            }
            if (!variable.isFixed()) {
                variable.setFixed(solution);
                return true;
            }
            if (Presolvers.findCommonLevel(solution, variable.getValue()) == null) {
                expression.setInfeasible();
            }
            return false;
        }
        if (neg) {
            lowerCand = upper != null ? upper.divide(factor, LOWER) : null;
            upperCand = lower != null ? lower.divide(factor, UPPER) : null;
        } else {
            lowerCand = lower != null ? lower.divide(factor, LOWER) : null;
            BigDecimal bigDecimal = upperCand = upper != null ? upper.divide(factor, UPPER) : null;
        }
        BigDecimal lowerNew = lowerOld != null ? (lowerCand != null ? lowerOld.max(lowerCand) : lowerOld) : lowerCand;
        BigDecimal upperNew = upperOld != null ? (upperCand != null ? upperOld.min(upperCand) : upperOld) : upperCand;
        if (lowerNew != null && upperNew != null && (level = Presolvers.findCommonLevel(lowerNew, upperNew)) != null) {
            lowerNew = level;
            upperNew = level;
            variable.setFixed(level);
        }
        if (lowerNew != null && variable.isInteger()) {
            lowerNew = lowerNew.setScale(0, RoundingMode.CEILING);
        }
        if (upperNew != null && variable.isInteger()) {
            upperNew = upperNew.setScale(0, RoundingMode.FLOOR);
        }
        if (lowerNew != null && upperNew != null) {
            if (lowerNew.compareTo(upperNew) > 0) {
                expression.setInfeasible();
                return false;
            }
            level = Presolvers.findCommonLevel(lowerNew, upperNew);
            if (level != null) {
                variable.setFixed(level);
                return true;
            }
        }
        ((Variable)variable.lower((Comparable)lowerNew)).upper((Comparable)upperNew);
        return false;
    }

    static boolean doCase2(Expression expression, Set<Structure1D.IntIndex> remaining, BigDecimal lower, BigDecimal upper, NumberContext precision) {
        BigDecimal level;
        BigDecimal limit;
        BigDecimal contrMaxB;
        BigDecimal contrMinB;
        BigDecimal contrMaxA;
        BigDecimal contrMinA;
        Iterator<Structure1D.IntIndex> iterator = remaining.iterator();
        Variable variableA = expression.resolve(iterator.next());
        BigDecimal factorA = expression.get(variableA);
        boolean negA = factorA.signum() == -1;
        BigDecimal lowerOldA = variableA.getLowerLimit();
        BigDecimal upperOldA = variableA.getUpperLimit();
        if (negA) {
            contrMinA = upperOldA != null ? factorA.multiply(upperOldA) : null;
            contrMaxA = lowerOldA != null ? factorA.multiply(lowerOldA) : null;
        } else {
            contrMinA = lowerOldA != null ? factorA.multiply(lowerOldA) : null;
            contrMaxA = upperOldA != null ? factorA.multiply(upperOldA) : null;
        }
        Variable variableB = expression.resolve(iterator.next());
        BigDecimal factorB = expression.get(variableB);
        boolean negB = factorB.signum() == -1;
        BigDecimal lowerOldB = variableB.getLowerLimit();
        BigDecimal upperOldB = variableB.getUpperLimit();
        if (negB) {
            contrMinB = upperOldB != null ? factorB.multiply(upperOldB) : null;
            contrMaxB = lowerOldB != null ? factorB.multiply(lowerOldB) : null;
        } else {
            contrMinB = lowerOldB != null ? factorB.multiply(lowerOldB) : null;
            BigDecimal bigDecimal = contrMaxB = upperOldB != null ? factorB.multiply(upperOldB) : null;
        }
        if (lower != null && contrMaxA != null && contrMaxB != null && precision.isLessThan(lower, contrMaxA.add(contrMaxB))) {
            expression.setInfeasible();
            return false;
        }
        if (upper != null && contrMinA != null && contrMinB != null && precision.isMoreThan(upper, contrMinA.add(contrMinB))) {
            expression.setInfeasible();
            return false;
        }
        BigDecimal allowedMinA = contrMinA;
        BigDecimal allowedMaxA = contrMaxA;
        BigDecimal allowedMinB = contrMinB;
        BigDecimal allowedMaxB = contrMaxB;
        if (lower != null) {
            if (contrMaxB != null) {
                limit = lower.subtract(contrMaxB);
                allowedMinA = contrMinA != null ? contrMinA.max(limit) : limit;
            }
            if (contrMaxA != null) {
                limit = lower.subtract(contrMaxA);
                allowedMinB = contrMinB != null ? contrMinB.max(limit) : limit;
            }
        }
        if (upper != null) {
            if (contrMinB != null) {
                limit = upper.subtract(contrMinB);
                allowedMaxA = contrMaxA != null ? contrMaxA.min(limit) : limit;
            }
            if (contrMinA != null) {
                limit = upper.subtract(contrMinA);
                allowedMaxB = contrMaxB != null ? contrMaxB.min(limit) : limit;
            }
        }
        BigDecimal lowerNewA = lowerOldA;
        BigDecimal upperNewA = upperOldA;
        BigDecimal lowerNewB = lowerOldB;
        BigDecimal upperNewB = upperOldB;
        if (allowedMinA != null) {
            if (negA) {
                upperNewA = allowedMinA.divide(factorA, UPPER);
            } else {
                lowerNewA = allowedMinA.divide(factorA, LOWER);
            }
        }
        if (allowedMaxA != null) {
            if (negA) {
                lowerNewA = allowedMaxA.divide(factorA, LOWER);
            } else {
                upperNewA = allowedMaxA.divide(factorA, UPPER);
            }
        }
        if (allowedMinB != null) {
            if (negB) {
                upperNewB = allowedMinB.divide(factorB, UPPER);
            } else {
                lowerNewB = allowedMinB.divide(factorB, LOWER);
            }
        }
        if (allowedMaxB != null) {
            if (negB) {
                lowerNewB = allowedMaxB.divide(factorB, LOWER);
            } else {
                upperNewB = allowedMaxB.divide(factorB, UPPER);
            }
        }
        if (lowerNewA != null && upperNewA != null && (level = Presolvers.findCommonLevel(lowerNewA, upperNewA)) != null) {
            lowerNewA = level;
            upperNewA = level;
            variableA.setFixed(level);
        }
        if (lowerNewB != null && upperNewB != null && (level = Presolvers.findCommonLevel(lowerNewB, upperNewB)) != null) {
            lowerNewB = level;
            upperNewB = level;
            variableB.setFixed(level);
        }
        if (variableA.isInteger()) {
            if (lowerNewA != null) {
                lowerNewA = lowerNewA.setScale(0, RoundingMode.CEILING);
            }
            if (upperNewA != null) {
                upperNewA = upperNewA.setScale(0, RoundingMode.FLOOR);
            }
        }
        if (variableB.isInteger()) {
            if (lowerNewB != null) {
                lowerNewB = lowerNewB.setScale(0, RoundingMode.CEILING);
            }
            if (upperNewB != null) {
                upperNewB = upperNewB.setScale(0, RoundingMode.FLOOR);
            }
        }
        ((Variable)variableA.lower((Comparable)lowerNewA)).upper((Comparable)upperNewA);
        ((Variable)variableB.lower((Comparable)lowerNewB)).upper((Comparable)upperNewB);
        return variableA.isFixed() || variableB.isFixed();
    }

    static boolean doCaseN(Expression expression, Set<Structure1D.IntIndex> remaining, BigDecimal lower, BigDecimal upper, NumberContext precision) {
        Variable freeVariable;
        int signum;
        boolean didFixVariable = false;
        if (lower != null && expression.isNegativeOn(remaining)) {
            signum = lower.signum();
            if (signum > 0) {
                expression.setInfeasible();
                return false;
            }
            for (Structure1D.IntIndex indexOfFree : remaining) {
                freeVariable = expression.resolve(indexOfFree);
                if (signum == 0) {
                    if (!freeVariable.validate(BigMath.ZERO, precision, null)) {
                        expression.setInfeasible();
                        return false;
                    }
                    freeVariable.setFixed(BigMath.ZERO);
                    didFixVariable = true;
                    continue;
                }
                if (!freeVariable.isBinary() || expression.get(freeVariable).compareTo(lower) >= 0) continue;
                freeVariable.setFixed(BigMath.ZERO);
                didFixVariable = true;
            }
        }
        if (upper != null && expression.isPositiveOn(remaining)) {
            signum = upper.signum();
            if (signum < 0) {
                expression.setInfeasible();
                return false;
            }
            for (Structure1D.IntIndex indexOfFree : remaining) {
                freeVariable = expression.resolve(indexOfFree);
                if (signum == 0) {
                    if (!freeVariable.validate(BigMath.ZERO, precision, null)) {
                        expression.setInfeasible();
                        return false;
                    }
                    freeVariable.setFixed(BigMath.ZERO);
                    didFixVariable = true;
                    continue;
                }
                if (!freeVariable.isBinary() || expression.get(freeVariable).compareTo(upper) <= 0) continue;
                freeVariable.setFixed(BigMath.ZERO);
                didFixVariable = true;
            }
        }
        return didFixVariable;
    }

    static BigDecimal findCommonLevel(BigDecimal a, BigDecimal b) {
        BigDecimal levelledB;
        if (a.compareTo(b) == 0) {
            return a;
        }
        BigDecimal levelledA = LEVEL.enforce(a);
        if (levelledA.compareTo(levelledB = LEVEL.enforce(b)) == 0) {
            return BigMath.DIVIDE.invoke(a.add(a), BigMath.TWO);
        }
        return null;
    }
}

