/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation.linear;

import java.util.ArrayList;
import java.util.List;
import org.ojalgo.array.ArrayR064;
import org.ojalgo.array.SparseArray;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.matrix.decomposition.LU;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.Primitive64Store;
import org.ojalgo.matrix.transformation.InvertibleFactor;
import org.ojalgo.structure.Access2D;
import org.ojalgo.type.ObjectPool;

final class ProductFormInverse
implements InvertibleFactor<Double> {
    private final ObjectPool<SparseArray<Double>> myArrayPool;
    private final int myDim;
    private final List<ElementaryFactor> myFactors = new ArrayList<ElementaryFactor>();
    private final LU<Double> myRoot;
    private final Primitive64Store myWork;
    private final double myScalingThreshold;

    ProductFormInverse(int dim, double scalingThreshold) {
        this.myDim = dim;
        this.myRoot = (LU)LU.R064.make(dim, dim);
        this.myWork = (Primitive64Store)Primitive64Store.FACTORY.make(dim, 1);
        this.myArrayPool = new ArrayPool(dim);
        this.myScalingThreshold = scalingThreshold;
    }

    @Override
    public void btran(PhysicalStore<Double> arg) {
        for (int i = this.myFactors.size() - 1; i >= 0; --i) {
            this.myFactors.get(i).btran(arg);
        }
        if (this.myRoot.isSolvable()) {
            this.myRoot.ftran(arg);
        }
    }

    @Override
    public long countColumns() {
        return this.myDim;
    }

    @Override
    public long countRows() {
        return this.myDim;
    }

    @Override
    public void ftran(PhysicalStore<Double> arg) {
        if (this.myRoot.isSolvable()) {
            this.myRoot.btran(arg);
        }
        for (InvertibleFactor invertibleFactor : this.myFactors) {
            invertibleFactor.ftran(arg);
        }
    }

    private void clearFactors() {
        for (ElementaryFactor factor : this.myFactors) {
            this.myArrayPool.giveBack(factor.getColumn());
        }
        this.myFactors.clear();
    }

    private ElementaryFactor newFactor(Primitive64Store values, int col, double diagonalElement) {
        SparseArray<Double> sparse = this.myArrayPool.borrow();
        int limit = values.size();
        for (int i = 0; i < limit; ++i) {
            double value = values.doubleValue((long)i);
            if (value == PrimitiveMath.ZERO) continue;
            sparse.set((long)i, value);
        }
        return new ElementaryFactor(sparse, col, diagonalElement);
    }

    void reset() {
        this.clearFactors();
        this.myRoot.reset();
    }

    void reset(MatrixStore<Double> basis) {
        this.clearFactors();
        this.myRoot.decompose((Access2D.Collectable<Double, PhysicalStore<Double>>)((Object)basis.transpose()));
    }

    void update(int col, SparseArray<Double> values) {
        values.supplyTo(this.myWork);
        this.ftran(this.myWork);
        double diagonalElement = this.myWork.doubleValue((long)col);
        this.myFactors.add(this.newFactor(this.myWork, col, diagonalElement));
    }

    void update(MatrixStore<Double> basis, int index, SparseArray<Double> values) {
        values.supplyTo(this.myWork);
        this.ftran(this.myWork);
        double diagonalElement = this.myWork.doubleValue((long)index);
        if (Math.abs(diagonalElement) >= this.myScalingThreshold) {
            this.myFactors.add(this.newFactor(this.myWork, index, diagonalElement));
        } else {
            this.clearFactors();
            this.myRoot.decompose((Access2D.Collectable<Double, PhysicalStore<Double>>)((Object)basis.transpose()));
        }
    }

    static final class ElementaryFactor
    implements InvertibleFactor<Double> {
        private final SparseArray<Double> myColumn;
        private final int myIndex;
        private final double myNegatedDiagonal;

        ElementaryFactor(SparseArray<Double> column, int index, double diagonalElement) {
            this.myColumn = column;
            this.myIndex = index;
            this.myNegatedDiagonal = -diagonalElement;
        }

        @Override
        public void btran(PhysicalStore<Double> arg) {
            double f = -arg.doubleValue(this.myIndex);
            for (SparseArray.NonzeroView nz : this.myColumn.nonzeros()) {
                long index = nz.index();
                if (index == (long)this.myIndex) continue;
                f += nz.doubleValue() * arg.doubleValue(index);
            }
            if (f != PrimitiveMath.ZERO) {
                arg.set((long)this.myIndex, f /= this.myNegatedDiagonal);
            } else {
                arg.set((long)this.myIndex, PrimitiveMath.ZERO);
            }
        }

        @Override
        public long countColumns() {
            return this.myColumn.count();
        }

        @Override
        public long countRows() {
            return this.myColumn.count();
        }

        @Override
        public void ftran(PhysicalStore<Double> arg) {
            double d = arg.doubleValue(this.myIndex);
            if (d == PrimitiveMath.ZERO) {
                return;
            }
            d /= this.myNegatedDiagonal;
            for (SparseArray.NonzeroView nz : this.myColumn.nonzeros()) {
                long index = nz.index();
                if (index == (long)this.myIndex) {
                    arg.set(index, -d);
                    continue;
                }
                arg.add(index, nz.doubleValue() * d);
            }
        }

        SparseArray<Double> getColumn() {
            return this.myColumn;
        }
    }

    static final class ArrayPool
    extends ObjectPool<SparseArray<Double>> {
        private static final SparseArray.SparseFactory<Double> FACTORY = SparseArray.factory(ArrayR064.FACTORY);
        private final int myDim;

        ArrayPool(int dim) {
            this.myDim = dim;
        }

        @Override
        protected SparseArray<Double> newObject() {
            return (SparseArray)FACTORY.make(this.myDim);
        }

        @Override
        protected void reset(SparseArray<Double> object) {
            object.reset();
        }
    }
}

