/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation.linear;

import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collection;
import org.ojalgo.equation.Equation;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.optimisation.Optimisation;
import org.ojalgo.optimisation.UpdatableSolver;
import org.ojalgo.optimisation.linear.LinearSolver;
import org.ojalgo.optimisation.linear.SimplexStore;
import org.ojalgo.structure.Access2D;
import org.ojalgo.type.context.NumberContext;

abstract class SimplexSolver
extends LinearSolver {
    private static final NumberContext ALGORITHM = NumberContext.of(8).withMode(RoundingMode.HALF_DOWN);
    private final SimplexStore mySimplex;
    private final double[] mySolutionShift;
    private Validator myValidator = null;
    private double myValueShift = PrimitiveMath.ZERO;
    private final int n;

    SimplexSolver(Optimisation.Options solverOptions, SimplexStore simplexStore) {
        super(solverOptions);
        this.mySimplex = simplexStore;
        this.mySolutionShift = new double[simplexStore.n];
        this.n = simplexStore.n - simplexStore.structure().nbVarsArt;
    }

    @Override
    public UpdatableSolver.EntityMap getEntityMap() {
        return this.mySimplex.meta;
    }

    private double[] extractSolution() {
        double[] retVal = this.mySimplex.extractSolution();
        for (int i = 0; i < this.mySolutionShift.length; ++i) {
            int n = i;
            retVal[n] = retVal[n] + this.mySolutionShift[i];
        }
        return retVal;
    }

    private double extractValue() {
        return this.mySimplex.extractValue() + this.myValueShift;
    }

    private boolean getDualExitCandidate(IterDescr iteration) {
        if (iteration != null && this.isLogDebug()) {
            this.log();
            this.log("getDualExitCandidate", new Object[0]);
        }
        boolean retVal = false;
        boolean printable = this.mySimplex.isPrintable();
        ExitInfo exit = null;
        if (iteration != null) {
            exit = iteration.exit;
        }
        double largest = 1.0E-10;
        int[] included = this.mySimplex.included;
        int limit = included.length;
        for (int ji = 0; ji < limit; ++ji) {
            int j = included[ji];
            double candidate = this.mySimplex.getInfeasibility(ji);
            double magnitude = Math.abs(candidate);
            if (printable && this.isLogDebug()) {
                this.log(1, "{}({}) {}", j, ji, candidate);
            }
            if (!(magnitude > largest)) continue;
            if (exit != null) {
                exit.index = ji;
                if (candidate > PrimitiveMath.ZERO) {
                    exit.direction = Direction.DECREASE;
                    exit.to = SimplexStore.ColumnState.UPPER;
                } else {
                    exit.direction = Direction.INCREASE;
                    exit.to = SimplexStore.ColumnState.LOWER;
                }
                if (this.isLogDebug()) {
                    this.log(2, "{} => {}", magnitude, exit);
                }
            }
            largest = magnitude;
            retVal = true;
        }
        if (iteration != null && this.isLogDebug()) {
            this.log("==>> {}", exit);
        }
        return retVal;
    }

    private double getLowerBound(int index) {
        return this.mySimplex.getLowerBound(index) + this.mySolutionShift[index];
    }

    private double[] getLowerBounds() {
        double[] retVal = new double[this.mySolutionShift.length];
        for (int j = 0; j < retVal.length; ++j) {
            retVal[j] = this.mySimplex.getLowerBound(j) + this.mySolutionShift[j];
        }
        return retVal;
    }

    private boolean getPrimalEnterCandidate(IterDescr iteration) {
        if (iteration != null && this.isLogDebug()) {
            this.log();
            this.log("getPrimalEnterCandidate", new Object[0]);
        }
        boolean retVal = false;
        boolean printable = this.mySimplex.isPrintable();
        EnterInfo enter = null;
        if (iteration != null) {
            enter = iteration.enter;
        }
        double largest = 1.0E-10;
        int[] excluded = this.mySimplex.excluded;
        for (int je = 0; je < excluded.length; ++je) {
            int j = excluded[je];
            if (j >= this.n) continue;
            SimplexStore.ColumnState columnState = this.mySimplex.getColumnState(j);
            double candidate = this.mySimplex.getReducedCost(je);
            double magnitude = Math.abs(candidate);
            if (printable && this.isLogDebug()) {
                this.log(1, "{}({}) {} @ {}", new Object[]{j, je, candidate, columnState});
            }
            if (!(magnitude > largest)) continue;
            if (candidate <= PrimitiveMath.ZERO && columnState != SimplexStore.ColumnState.UPPER) {
                if (enter != null) {
                    enter.index = je;
                    enter.from = columnState;
                    enter.direction = Direction.INCREASE;
                    if (this.isLogDebug()) {
                        this.log(2, "{} => {}", magnitude, enter);
                    }
                }
                largest = magnitude;
                retVal = true;
                continue;
            }
            if (!(candidate >= PrimitiveMath.ZERO) || columnState == SimplexStore.ColumnState.LOWER) continue;
            if (enter != null) {
                enter.index = je;
                enter.from = columnState;
                enter.direction = Direction.DECREASE;
                if (this.isLogDebug()) {
                    this.log(2, "{} => {}", magnitude, enter);
                }
            }
            largest = magnitude;
            retVal = true;
        }
        if (iteration != null && this.isLogDebug()) {
            this.log("==>> {}", enter);
        }
        return retVal;
    }

    private double getUpperBound(int index) {
        return this.mySimplex.getUpperBound(index) + this.mySolutionShift[index];
    }

    private double[] getUpperBounds() {
        double[] retVal = new double[this.mySolutionShift.length];
        for (int j = 0; j < retVal.length; ++j) {
            retVal[j] = this.mySimplex.getUpperBound(j) + this.mySolutionShift[j];
        }
        return retVal;
    }

    private void logCurrentState() {
        this.log();
        this.log("{} iteration {}, partition {}", this.getState(), this.countIterations(), this.mySimplex.toString());
        double[] lb = this.getLowerBounds();
        this.log("LB: {}", new Object[]{lb});
        double[] x = this.extractSolution();
        this.log(" X: {}", new Object[]{x});
        double[] ub = this.getUpperBounds();
        this.log("UB: {}", new Object[]{ub});
        for (int j = 0; j < x.length; ++j) {
            if (!(lb[j] > x[j]) && !(ub[j] < x[j])) continue;
            this.log("!!! {} < {} < {}", lb[j], x[j], ub[j]);
        }
        if (this.mySimplex.isPrintable() && this.mySimplex instanceof Access2D) {
            this.log(Arrays.toString(this.mySimplex.included), (Access2D)((Object)this.mySimplex));
        } else {
            this.log(Arrays.toString(this.mySimplex.included), new Object[0]);
        }
    }

    private void shift(int column, SimplexStore.ColumnState state) {
        double shift = PrimitiveMath.ZERO;
        if (state == SimplexStore.ColumnState.LOWER) {
            shift = this.mySimplex.getLowerBound(column);
        } else if (state == SimplexStore.ColumnState.UPPER) {
            shift = this.mySimplex.getUpperBound(column);
        }
        if (shift != PrimitiveMath.ZERO) {
            this.mySimplex.shiftColumn(column, shift);
            int n = column;
            this.mySolutionShift[n] = this.mySolutionShift[n] + shift;
            this.myValueShift += this.mySimplex.getCost(column) * shift;
        }
    }

    private void shiftBounds(boolean prioritiseFeasibility, boolean modifyObjective) {
        for (int j : this.mySimplex.excluded) {
            double ub;
            double rc = prioritiseFeasibility ? PrimitiveMath.ZERO : this.mySimplex.getCost(j);
            double lb = this.mySimplex.getLowerBound(j);
            if (lb > (ub = this.mySimplex.getUpperBound(j))) {
                throw new IllegalStateException();
            }
            if (rc > PrimitiveMath.ZERO && Double.isFinite(lb)) {
                this.mySimplex.lower(j);
                this.mySimplex.shiftColumn(j, lb);
                this.mySolutionShift[j] = lb;
                this.myValueShift += rc * lb;
                continue;
            }
            if (rc < PrimitiveMath.ZERO && Double.isFinite(ub)) {
                this.mySimplex.upper(j);
                this.mySimplex.shiftColumn(j, ub);
                this.mySolutionShift[j] = ub;
                this.myValueShift += rc * ub;
                continue;
            }
            if (!Double.isFinite(lb) && !Double.isFinite(ub)) {
                this.mySimplex.unbounded(j);
                if (!modifyObjective) continue;
                this.mySimplex.objective().set((long)j, PrimitiveMath.ZERO);
                continue;
            }
            if (Math.abs(lb) <= Math.abs(ub)) {
                this.mySimplex.lower(j);
                this.mySimplex.shiftColumn(j, lb);
                this.mySolutionShift[j] = lb;
                this.myValueShift += rc * lb;
                if (!modifyObjective) continue;
                this.mySimplex.objective().set((long)j, PrimitiveMath.ONE);
                continue;
            }
            if (Math.abs(lb) >= Math.abs(ub)) {
                this.mySimplex.upper(j);
                this.mySimplex.shiftColumn(j, ub);
                this.mySolutionShift[j] = ub;
                this.myValueShift += rc * ub;
                if (!modifyObjective) continue;
                this.mySimplex.objective().set((long)j, PrimitiveMath.NEG);
                continue;
            }
            this.mySimplex.lower(j);
            if (!modifyObjective) continue;
            this.mySimplex.objective().set((long)j, PrimitiveMath.ONE);
        }
    }

    private Optimisation.Result solveUnconstrained() {
        int nbVars = this.mySimplex.n;
        double retValue = PrimitiveMath.ZERO;
        double[] retSolution = new double[nbVars];
        Optimisation.State retState = Optimisation.State.OPTIMAL;
        for (int j = 0; j < nbVars; ++j) {
            double value;
            double cost = this.mySimplex.getCost(j);
            if (cost == PrimitiveMath.ZERO) {
                retSolution[j] = value = this.mySolutionShift[j];
                continue;
            }
            if (cost > PrimitiveMath.ZERO) {
                value = this.getLowerBound(j);
                if (Double.isFinite(value)) {
                    retSolution[j] = value;
                    retValue += value * cost;
                    continue;
                }
                retSolution[j] = PrimitiveMath.ZERO;
                retState = Optimisation.State.UNBOUNDED;
                continue;
            }
            if (!(cost < PrimitiveMath.ZERO)) continue;
            value = this.getUpperBound(j);
            if (Double.isFinite(value)) {
                retSolution[j] = value;
                retValue += value * cost;
                continue;
            }
            retSolution[j] = PrimitiveMath.ZERO;
            retState = Optimisation.State.UNBOUNDED;
        }
        return Optimisation.Result.of(retValue, retState, retSolution);
    }

    private boolean testDualEnterRatio(IterDescr iteration) {
        if (this.isLogDebug()) {
            this.log();
            this.log("testDualEnterRatio", new Object[0]);
        }
        boolean printable = this.mySimplex.isPrintable();
        ExitInfo exit = iteration.exit;
        EnterInfo enter = iteration.enter;
        Direction exitDirection = exit.direction;
        double numer = PrimitiveMath.ZERO;
        double denom = PrimitiveMath.ONE;
        double ratio = PrimitiveMath.ZERO;
        iteration.ratioDual = Double.MAX_VALUE;
        int[] excluded = this.mySimplex.excluded;
        for (int je = 0; je < excluded.length; ++je) {
            int j = excluded[je];
            if (j >= this.n || ALGORITHM.isZero(denom = this.mySimplex.getTableauElement(exit, je))) continue;
            SimplexStore.ColumnState columnState = this.mySimplex.getColumnState(j);
            ratio = Double.MAX_VALUE;
            if (columnState == SimplexStore.ColumnState.UNBOUNDED) {
                ratio = PrimitiveMath.ZERO;
            } else {
                numer = this.mySimplex.getReducedCost(je);
                if (exitDirection == Direction.INCREASE) {
                    if (columnState == SimplexStore.ColumnState.LOWER && denom < PrimitiveMath.ZERO) {
                        ratio = numer / -denom;
                    } else if (columnState == SimplexStore.ColumnState.UPPER && denom > PrimitiveMath.ZERO) {
                        ratio = -numer / denom;
                    }
                } else if (exitDirection == Direction.DECREASE) {
                    if (columnState == SimplexStore.ColumnState.LOWER && denom > PrimitiveMath.ZERO) {
                        ratio = numer / denom;
                    } else if (columnState == SimplexStore.ColumnState.UPPER && denom < PrimitiveMath.ZERO) {
                        ratio = -numer / -denom;
                    }
                }
            }
            if (printable && this.isLogDebug()) {
                this.log(1, "{}({}) {} / {} = {}", j, je, numer, denom, ratio);
            }
            if (!(ratio < iteration.ratioDual)) continue;
            enter.index = je;
            enter.from = columnState;
            Direction direction = enter.direction = columnState == SimplexStore.ColumnState.UPPER ? Direction.DECREASE : Direction.INCREASE;
            if (this.isLogDebug()) {
                this.log(2, "{} => {}", ratio, enter);
            }
            iteration.ratioDual = ratio;
        }
        if (this.isLogDebug()) {
            this.log("==>> {}", enter);
        }
        return enter.index >= 0;
    }

    private boolean testPrimalExitRatio(IterDescr iteration) {
        if (this.isLogDebug()) {
            this.log();
            this.log("testPrimalExitRatio", new Object[0]);
        }
        boolean printable = this.mySimplex.isPrintable();
        EnterInfo enter = iteration.enter;
        ExitInfo exit = iteration.exit;
        Direction enterDirection = enter.direction;
        double range = this.mySimplex.getRange(enter.column());
        double numer = PrimitiveMath.ZERO;
        double denom = PrimitiveMath.ONE;
        double ratio = PrimitiveMath.ZERO;
        iteration.ratioPrimal = range;
        int[] included = this.mySimplex.included;
        for (int ji = 0; ji < included.length; ++ji) {
            int j = included[ji];
            denom = this.mySimplex.getTableauElement(ji, enter);
            if (ALGORITHM.isZero(denom)) continue;
            if (enterDirection == Direction.INCREASE) {
                if (denom < PrimitiveMath.ZERO) {
                    numer = this.mySimplex.getUpperGap(ji);
                    ratio = numer / -denom;
                } else if (denom > PrimitiveMath.ZERO) {
                    numer = this.mySimplex.getLowerGap(ji);
                    ratio = numer / denom;
                }
                if (printable && this.isLogDebug()) {
                    this.log(1, "{}({}) {} / {} = {}", j, ji, numer, denom, ratio);
                }
                if (!(ratio < iteration.ratioPrimal)) continue;
                exit.index = ji;
                if (denom < PrimitiveMath.ZERO) {
                    exit.direction = Direction.INCREASE;
                    exit.to = SimplexStore.ColumnState.UPPER;
                } else {
                    exit.direction = Direction.DECREASE;
                    exit.to = SimplexStore.ColumnState.LOWER;
                }
                if (this.isLogDebug()) {
                    this.log(2, "{} => {}", ratio, exit);
                }
                iteration.ratioPrimal = ratio;
                continue;
            }
            if (enterDirection == Direction.DECREASE) {
                if (denom < PrimitiveMath.ZERO) {
                    numer = this.mySimplex.getLowerGap(ji);
                    ratio = numer / -denom;
                } else if (denom > PrimitiveMath.ZERO) {
                    numer = this.mySimplex.getUpperGap(ji);
                    ratio = numer / denom;
                }
                if (printable && this.isLogDebug()) {
                    this.log(1, "{}({}) {} / {} = {}", j, ji, numer, denom, ratio);
                }
                if (!(ratio < iteration.ratioPrimal)) continue;
                exit.index = ji;
                if (denom > PrimitiveMath.ZERO) {
                    exit.direction = Direction.INCREASE;
                    exit.to = SimplexStore.ColumnState.UPPER;
                } else {
                    exit.direction = Direction.DECREASE;
                    exit.to = SimplexStore.ColumnState.LOWER;
                }
                if (this.isLogDebug()) {
                    this.log(2, "{} => {}", ratio, exit);
                }
                iteration.ratioPrimal = ratio;
                continue;
            }
            throw new IllegalStateException();
        }
        if (iteration.ratioPrimal >= range) {
            if (this.isLogDebug()) {
                this.log("Bound switch!", new Object[0]);
            }
            iteration.markAsBoundSwitch();
        }
        if (this.isLogDebug()) {
            this.log("==>> {}", exit);
        }
        return exit.index >= 0 || iteration.isBoundSwitch();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void update(IterDescr iteration) {
        if (iteration.isBasisUpdate()) {
            if (this.isLogDebug()) {
                this.log();
                this.log("Pivoting: {}", iteration);
                this.log("==>> Row: {}, Exit: {}, Column/Enter: {}.", iteration.exit.index, iteration.exit.column(), iteration.enter.column());
                this.log("Shift Exit: {}, Enter: {}", this.mySolutionShift[iteration.exit.column()], this.mySolutionShift[iteration.enter.column()]);
            }
            this.mySimplex.pivot(iteration);
            this.shift(iteration.enter.column(), iteration.exit.to);
            this.mySimplex.calculateIteration(iteration);
            return;
        } else if (iteration.isBoundSwitch()) {
            if (this.isLogDebug()) {
                this.log();
                this.log("Switching bounds: {}", iteration.enter);
                this.log("==>> Column: {}.", iteration.enter.column());
            }
            int j = iteration.enter.column();
            SimplexStore.ColumnState from = iteration.enter.from;
            if (from == SimplexStore.ColumnState.LOWER) {
                this.mySimplex.upper(j);
                this.shift(j, SimplexStore.ColumnState.UPPER);
                return;
            } else if (from == SimplexStore.ColumnState.UPPER) {
                this.mySimplex.lower(j);
                this.shift(j, SimplexStore.ColumnState.LOWER);
                return;
            } else {
                if (from != SimplexStore.ColumnState.UNBOUNDED) throw new IllegalStateException();
                this.setState(Optimisation.State.UNBOUNDED);
            }
            return;
        } else {
            if (!this.isLogDebug()) return;
            this.log();
            this.log("No update operation!", new Object[0]);
        }
    }

    final SimplexSolver basis(int[] basis) {
        this.mySimplex.resetBasis(basis);
        return this;
    }

    final void doDualIterations(IterDescr iteration) {
        boolean done = false;
        while (this.isIterationAllowed() && !done) {
            iteration.reset();
            if (this.getDualExitCandidate(iteration)) {
                this.mySimplex.calculateDualDirection(iteration.exit);
                if (this.testDualEnterRatio(iteration)) {
                    if (iteration.isBasisUpdate()) {
                        this.mySimplex.calculatePrimalDirection(iteration.enter);
                    }
                    this.update(iteration);
                    this.incrementIterationsCount();
                } else {
                    this.setState(Optimisation.State.INFEASIBLE);
                }
            } else {
                this.setState(Optimisation.State.FEASIBLE);
                done = true;
            }
            if (!this.isLogDebug()) continue;
            this.logCurrentState();
        }
    }

    final void doPrimalIterations(IterDescr iteration) {
        if (this.options.validate && this.myValidator != null) {
            this.myValidator.validate(this.extractResult());
        }
        boolean done = false;
        while (this.isIterationAllowed() && !done) {
            iteration.reset();
            if (this.getPrimalEnterCandidate(iteration)) {
                this.mySimplex.calculatePrimalDirection(iteration.enter);
                if (this.testPrimalExitRatio(iteration)) {
                    if (iteration.isBasisUpdate()) {
                        this.mySimplex.calculateDualDirection(iteration.exit);
                    }
                    this.update(iteration);
                    this.incrementIterationsCount();
                } else {
                    this.setState(Optimisation.State.UNBOUNDED);
                }
            } else {
                this.setState(Optimisation.State.OPTIMAL);
                done = true;
            }
            if (this.isLogDebug()) {
                this.logCurrentState();
            }
            if (!this.options.validate || this.myValidator == null) continue;
            this.myValidator.validate(this.extractResult());
        }
    }

    final Optimisation.Result extractResult() {
        double retValue = this.extractValue();
        Optimisation.State retState = this.getState();
        double[] retSolution = this.extractSolution();
        Optimisation.Result result = Optimisation.Result.of(retValue, retState, retSolution);
        if (this.isLogDebug()) {
            this.log();
            this.log("{} {} {}", retValue, retState, this.mySimplex.toString());
            this.log("LB: {}", new Object[]{this.getLowerBounds()});
            this.log(" X: {}", new Object[]{retSolution});
            this.log("UB: {}", new Object[]{this.getUpperBounds()});
        }
        return result;
    }

    void initiatePhase1() {
        this.mySimplex.copyObjective();
    }

    final boolean isDualFeasible() {
        return !this.getPrimalEnterCandidate(null);
    }

    final boolean isPrimalFeasible() {
        return !this.getDualExitCandidate(null);
    }

    final IterDescr prepareToIterate(boolean prioritiseFeasibility, boolean modifyObjective) {
        this.shiftBounds(prioritiseFeasibility, modifyObjective);
        if (this.mySimplex.m == 0) {
            this.solveUnconstrained();
        }
        this.mySimplex.calculateIteration();
        this.resetIterationsCount();
        if (this.isLogDebug()) {
            this.logCurrentState();
        }
        return new IterDescr(this.mySimplex);
    }

    void setValidator(Validator validator) {
        this.myValidator = validator;
    }

    void switchToPhase2() {
        this.mySimplex.restoreObjective();
        this.mySimplex.calculateIteration();
    }

    @Override
    public final Collection<Equation> generateCutCandidates(double fractionality, boolean ... integer) {
        return this.mySimplex.generateCutCandidates(integer, this.options.integer().getIntegralityTolerance(), fractionality);
    }

    static interface Validator {
        public void validate(Optimisation.Result var1);
    }

    static final class IterDescr {
        final EnterInfo enter;
        final ExitInfo exit;
        double ratioDual = Double.MAX_VALUE;
        double ratioPrimal = Double.MAX_VALUE;

        IterDescr(SimplexStore simplex) {
            this.enter = new EnterInfo(simplex.excluded);
            this.exit = new ExitInfo(simplex.included);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof IterDescr)) {
                return false;
            }
            IterDescr other = (IterDescr)obj;
            if (this.enter == null ? other.enter != null : !this.enter.equals(other.enter)) {
                return false;
            }
            return !(this.exit == null ? other.exit != null : !this.exit.equals(other.exit));
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.enter == null ? 0 : this.enter.hashCode());
            return 31 * result + (this.exit == null ? 0 : this.exit.hashCode());
        }

        public String toString() {
            if (this.isBasisUpdate()) {
                return this.exit.toString() + " -> " + this.enter.toString();
            }
            if (this.isBoundSwitch()) {
                return this.enter.toString() + " -> " + this.exit.to;
            }
            return "-";
        }

        boolean isBasisUpdate() {
            return this.enter.index >= 0 && this.exit.index >= 0;
        }

        boolean isBoundSwitch() {
            return this.enter.index >= 0 && this.enter.direction != Direction.STAY && this.enter.direction == this.exit.direction;
        }

        boolean isNoOperation() {
            return !this.isBasisUpdate() && !this.isBoundSwitch();
        }

        void markAsBoundSwitch() {
            this.exit.reset();
            if (this.enter.direction == Direction.INCREASE) {
                this.exit.direction = Direction.INCREASE;
                this.exit.to = SimplexStore.ColumnState.UPPER;
            } else {
                this.exit.direction = Direction.DECREASE;
                this.exit.to = SimplexStore.ColumnState.LOWER;
            }
        }

        void reset() {
            this.exit.reset();
            this.enter.reset();
            this.ratioPrimal = Double.MAX_VALUE;
            this.ratioDual = Double.MAX_VALUE;
        }
    }

    static final class ExitInfo {
        private final int[] myIncluded;
        Direction direction = Direction.STAY;
        int index = -1;
        SimplexStore.ColumnState to = SimplexStore.ColumnState.BASIS;

        ExitInfo(int[] included) {
            this.myIncluded = included;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ExitInfo)) {
                return false;
            }
            ExitInfo other = (ExitInfo)obj;
            return this.direction == other.direction && this.index == other.index && this.to == other.to;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.direction == null ? 0 : this.direction.hashCode());
            result = 31 * result + this.index;
            return 31 * result + (this.to == null ? 0 : this.to.hashCode());
        }

        public String toString() {
            return this.column() + "(" + this.index + ") " + this.direction + " " + this.to;
        }

        int column() {
            return this.index >= 0 ? this.myIncluded[this.index] : this.index;
        }

        void reset() {
            this.index = -1;
            this.to = SimplexStore.ColumnState.BASIS;
            this.direction = Direction.STAY;
        }

        int row() {
            return this.index;
        }
    }

    static final class EnterInfo {
        private final int[] myExcluded;
        Direction direction = Direction.STAY;
        SimplexStore.ColumnState from = SimplexStore.ColumnState.BASIS;
        int index = -1;

        EnterInfo(int[] excluded) {
            this.myExcluded = excluded;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof EnterInfo)) {
                return false;
            }
            EnterInfo other = (EnterInfo)obj;
            return this.direction == other.direction && this.from == other.from && this.index == other.index;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.direction == null ? 0 : this.direction.hashCode());
            result = 31 * result + (this.from == null ? 0 : this.from.hashCode());
            return 31 * result + this.index;
        }

        public String toString() {
            return this.column() + "(" + this.index + ") " + this.from + " " + this.direction;
        }

        int column() {
            return this.index >= 0 ? this.myExcluded[this.index] : this.index;
        }

        void reset() {
            this.index = -1;
            this.from = SimplexStore.ColumnState.BASIS;
            this.direction = Direction.STAY;
        }
    }

    static enum Direction {
        DECREASE,
        INCREASE,
        STAY;

    }
}

