/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation.linear;

import org.ojalgo.equation.Equation;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.optimisation.linear.Primitive1D;
import org.ojalgo.type.context.NumberContext;

abstract class TableauCutGenerator {
    private static final NumberContext ACCURACY = NumberContext.of(4, 16);

    TableauCutGenerator() {
    }

    private static double fraction(double value) {
        return value - Math.floor(value);
    }

    private static boolean ifFractionalEnough(double value, double fraction, double away) {
        if (ACCURACY.isSmall(value, Math.min(fraction, PrimitiveMath.ONE - fraction))) {
            return false;
        }
        return away < fraction && fraction < PrimitiveMath.ONE - away;
    }

    static Equation doGomory(Primitive1D body, int variableIndex, double rhs, double fractionality) {
        int nbVariables = body.size();
        double f0 = TableauCutGenerator.fraction(rhs);
        if (!TableauCutGenerator.ifFractionalEnough(rhs, f0, fractionality)) {
            return null;
        }
        double[] cut = new double[nbVariables];
        for (int j = 0; j < nbVariables; ++j) {
            double fj;
            double aj = body.doubleValue(j);
            if (ACCURACY.isZero(aj) || ACCURACY.isZero(fj = TableauCutGenerator.fraction(aj))) continue;
            cut[j] = fj / f0;
        }
        return Equation.of(PrimitiveMath.ONE, variableIndex, cut);
    }

    static Equation doGomoryMixedInteger(Primitive1D body, int variableIndex, double rhs, boolean[] integer, double fractionality) {
        int nbVariables = body.size();
        double f0 = TableauCutGenerator.fraction(rhs);
        if (!TableauCutGenerator.ifFractionalEnough(rhs, f0, fractionality)) {
            return null;
        }
        double cf0 = PrimitiveMath.ONE - f0;
        double[] cut = new double[nbVariables];
        for (int j = 0; j < nbVariables; ++j) {
            double aj = body.doubleValue(j);
            if (j == variableIndex || ACCURACY.isZero(aj)) continue;
            if (integer[j]) {
                double fj = TableauCutGenerator.fraction(aj);
                if (fj <= f0) {
                    if (ACCURACY.isZero(fj)) continue;
                    cut[j] = fj / f0;
                    continue;
                }
                double cfj = PrimitiveMath.ONE - fj;
                if (ACCURACY.isZero(cfj)) continue;
                cut[j] = cfj / cf0;
                continue;
            }
            cut[j] = aj > PrimitiveMath.ZERO ? aj / f0 : -aj / cf0;
        }
        return Equation.of(PrimitiveMath.ONE, variableIndex, cut);
    }
}

