/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.random;

import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.function.special.BetaFunction;
import org.ojalgo.function.special.GammaFunction;
import org.ojalgo.random.AbstractContinuous;
import org.ojalgo.random.Cauchy;
import org.ojalgo.random.Normal;

public class TDistribution
extends AbstractContinuous {
    private static final double _0_0001 = 1.0E-4;
    private static final Normal NORMAL = new Normal();
    private final double myConstant;
    private final double myDegreesOfFreedom;

    public static TDistribution of(int degreesOfFreedom) {
        switch (degreesOfFreedom) {
            case 1: {
                return new Degree1();
            }
            case 2: {
                return new Degree2();
            }
            case 3: {
                return new Degree3();
            }
            case 4: {
                return new Degree4();
            }
            case 5: {
                return new Degree5();
            }
            case 0x7FFFFFFF: {
                return new DegreeInfinity();
            }
        }
        return new TDistribution(degreesOfFreedom);
    }

    public static TDistribution ofInfinity() {
        return TDistribution.of(Integer.MAX_VALUE);
    }

    TDistribution(double degreesOfFreedom) {
        this.myDegreesOfFreedom = Math.min(100.0, degreesOfFreedom);
        this.myConstant = GammaFunction.gamma((this.myDegreesOfFreedom + PrimitiveMath.ONE) / PrimitiveMath.TWO) / (Math.sqrt(this.myDegreesOfFreedom * PrimitiveMath.PI) * GammaFunction.gamma(this.myDegreesOfFreedom / PrimitiveMath.TWO));
    }

    @Override
    public double getDensity(double value) {
        return this.myConstant * Math.pow(PrimitiveMath.ONE + value * value / this.myDegreesOfFreedom, (PrimitiveMath.NEG - this.myDegreesOfFreedom) / PrimitiveMath.TWO);
    }

    @Override
    public double getDistribution(double value) {
        if (value >= PrimitiveMath.ZERO) {
            double x = this.myDegreesOfFreedom / (value * value + this.myDegreesOfFreedom);
            return PrimitiveMath.ONE - PrimitiveMath.HALF * BetaFunction.Regularized.beta(x, this.myDegreesOfFreedom / PrimitiveMath.TWO, PrimitiveMath.HALF);
        }
        return PrimitiveMath.ONE - this.getDistribution(-value);
    }

    @Override
    public double getExpected() {
        if (this.myDegreesOfFreedom > PrimitiveMath.ONE) {
            return PrimitiveMath.ZERO;
        }
        return Double.NaN;
    }

    @Override
    public double getQuantile(double probability) {
        double retVal = this.approximateQuantile(probability);
        if (Double.isInfinite(retVal)) {
            return retVal;
        }
        double reverse = this.getDistribution(retVal);
        double lower = retVal;
        double higher = retVal;
        if (probability - reverse > 1.0E-4) {
            while (this.getDistribution(higher *= PrimitiveMath.TWO) <= probability) {
            }
        } else if (reverse - probability > 1.0E-4) {
            while (this.getDistribution(lower /= PrimitiveMath.TWO) >= probability) {
            }
        } else {
            return retVal;
        }
        do {
            if ((reverse = this.getDistribution(retVal = (lower + higher) / PrimitiveMath.TWO)) < probability) {
                lower = retVal;
                continue;
            }
            if (!(reverse > probability)) continue;
            higher = retVal;
        } while (Math.abs(reverse - probability) >= 1.0E-4);
        return retVal;
    }

    @Override
    public double getVariance() {
        if (this.myDegreesOfFreedom > PrimitiveMath.TWO) {
            return this.myDegreesOfFreedom / (this.myDegreesOfFreedom - PrimitiveMath.TWO);
        }
        if (this.myDegreesOfFreedom > PrimitiveMath.ONE) {
            return Double.POSITIVE_INFINITY;
        }
        return Double.NaN;
    }

    private double approximateQuantile(double probability) {
        return NORMAL.getQuantile(probability);
    }

    static final class DegreeInfinity
    extends TDistribution {
        private final Normal myNormal = new Normal();

        DegreeInfinity() {
            super(Double.POSITIVE_INFINITY);
        }

        @Override
        public double getDensity(double value) {
            return this.myNormal.getDensity(value);
        }

        @Override
        public double getDistribution(double value) {
            return this.myNormal.getDistribution(value);
        }

        @Override
        public double getQuantile(double probability) {
            return this.myNormal.getQuantile(probability);
        }

        @Override
        protected double generate() {
            return this.myNormal.generate();
        }
    }

    static final class Degree5
    extends TDistribution {
        private static final double SQRT5 = PrimitiveMath.SQRT.invoke(PrimitiveMath.FIVE);

        Degree5() {
            super(PrimitiveMath.FIVE);
        }

        @Override
        public double getDensity(double value) {
            return PrimitiveMath.EIGHT / (PrimitiveMath.THREE * PrimitiveMath.PI * SQRT5 * PrimitiveMath.POW.invoke(PrimitiveMath.ONE + value * value / PrimitiveMath.FIVE, PrimitiveMath.THREE));
        }

        @Override
        public double getDistribution(double value) {
            double x = PrimitiveMath.ONE + value * value / PrimitiveMath.FIVE;
            return PrimitiveMath.HALF + (value / (SQRT5 * x) * (PrimitiveMath.ONE + PrimitiveMath.TWO / (PrimitiveMath.THREE * x)) + PrimitiveMath.ATAN.invoke(value / SQRT5)) / PrimitiveMath.PI;
        }
    }

    static final class Degree4
    extends TDistribution {
        Degree4() {
            super(PrimitiveMath.FOUR);
        }

        @Override
        public double getDensity(double value) {
            return PrimitiveMath.THREE / (PrimitiveMath.EIGHT * PrimitiveMath.POW.invoke(PrimitiveMath.ONE + value * value / PrimitiveMath.FOUR, PrimitiveMath.FIVE / PrimitiveMath.TWO));
        }

        @Override
        public double getDistribution(double value) {
            double x = PrimitiveMath.ONE + value * value / PrimitiveMath.FOUR;
            return PrimitiveMath.HALF + PrimitiveMath.THREE / PrimitiveMath.EIGHT * (value / PrimitiveMath.SQRT.invoke(x)) * (PrimitiveMath.ONE - PrimitiveMath.TWELFTH * (value * value / x));
        }

        @Override
        public double getQuantile(double probability) {
            double alpha = PrimitiveMath.FOUR * probability * (PrimitiveMath.ONE - probability);
            double sqrt = Math.sqrt(alpha);
            double q = Math.cos(PrimitiveMath.THIRD * Math.acos(sqrt)) / sqrt;
            return Math.signum(probability - PrimitiveMath.HALF) * PrimitiveMath.TWO * Math.sqrt(q - PrimitiveMath.ONE);
        }
    }

    static final class Degree3
    extends TDistribution {
        Degree3() {
            super(PrimitiveMath.THREE);
        }

        @Override
        public double getDensity(double value) {
            return PrimitiveMath.SIX * Math.sqrt(PrimitiveMath.THREE) / (PrimitiveMath.PI * Math.pow(PrimitiveMath.THREE + value * value, PrimitiveMath.TWO));
        }

        @Override
        public double getDistribution(double value) {
            return PrimitiveMath.HALF + PrimitiveMath.ONE / PrimitiveMath.PI * (PrimitiveMath.ONE / PrimitiveMath.SQRT.invoke(PrimitiveMath.THREE) * (value / (PrimitiveMath.ONE + value * value / PrimitiveMath.THREE)) + PrimitiveMath.ATAN.invoke(value / PrimitiveMath.SQRT.invoke(PrimitiveMath.THREE)));
        }
    }

    static final class Degree2
    extends TDistribution {
        Degree2() {
            super(PrimitiveMath.TWO);
        }

        @Override
        public double getDensity(double value) {
            return PrimitiveMath.ONE / Math.pow(PrimitiveMath.TWO + value * value, PrimitiveMath.THREE / PrimitiveMath.TWO);
        }

        @Override
        public double getDistribution(double value) {
            return PrimitiveMath.HALF + value / (PrimitiveMath.TWO * Math.sqrt(PrimitiveMath.TWO + value * value));
        }

        @Override
        public double getQuantile(double probability) {
            double alpha = PrimitiveMath.FOUR * probability * (PrimitiveMath.ONE - probability);
            return PrimitiveMath.TWO * (probability - PrimitiveMath.HALF) * Math.sqrt(PrimitiveMath.TWO / alpha);
        }
    }

    static final class Degree1
    extends TDistribution {
        private final Cauchy myCauchy = new Cauchy();

        Degree1() {
            super(PrimitiveMath.ONE);
        }

        @Override
        public double getDensity(double value) {
            return this.myCauchy.getDensity(value);
        }

        @Override
        public double getDistribution(double value) {
            return this.myCauchy.getDistribution(value);
        }

        @Override
        public double getQuantile(double probability) {
            return this.myCauchy.getQuantile(probability);
        }

        @Override
        protected double generate() {
            return this.myCauchy.generate();
        }
    }
}

