/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.random.process;

import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.function.special.ErrorFunction;
import org.ojalgo.random.Normal;
import org.ojalgo.random.process.Process1D;
import org.ojalgo.random.process.SingleValueBasedProcess;

public final class WienerProcess
extends SingleValueBasedProcess<Normal>
implements Process1D.ComponentProcess<Normal> {
    private static final Normal GENERATOR = new Normal();

    public WienerProcess() {
        this.setCurrentValue(PrimitiveMath.ZERO);
    }

    private WienerProcess(double initialValue) {
        this.setCurrentValue(initialValue);
    }

    @Override
    public Normal getDistribution(double evaluationPoint) {
        return new Normal(this.getCurrentValue(), PrimitiveMath.SQRT.invoke(evaluationPoint));
    }

    @Override
    public double getValue() {
        return this.getCurrentValue();
    }

    @Override
    public void setValue(double newValue) {
        this.setCurrentValue(newValue);
    }

    @Override
    public double step(double stepSize, double standardGaussianInnovation) {
        return this.doStep(stepSize, standardGaussianInnovation);
    }

    @Override
    double doStep(double stepSize, double normalisedRandomIncrement) {
        double retVal = this.getCurrentValue() + PrimitiveMath.SQRT.invoke(stepSize) * normalisedRandomIncrement;
        this.setCurrentValue(retVal);
        return retVal;
    }

    @Override
    double getExpected(double stepSize) {
        return this.getCurrentValue();
    }

    @Override
    double getLowerConfidenceQuantile(double stepSize, double confidence) {
        return this.getCurrentValue() - PrimitiveMath.SQRT.invoke(stepSize) * PrimitiveMath.SQRT_TWO * ErrorFunction.erfi(confidence);
    }

    @Override
    double getNormalisedRandomIncrement() {
        return GENERATOR.doubleValue();
    }

    @Override
    double getStandardDeviation(double stepSize) {
        return PrimitiveMath.SQRT.invoke(stepSize);
    }

    @Override
    double getUpperConfidenceQuantile(double stepSize, double confidence) {
        return this.getCurrentValue() + PrimitiveMath.SQRT.invoke(stepSize) * PrimitiveMath.SQRT_TWO * ErrorFunction.erfi(confidence);
    }

    @Override
    double getVariance(double stepSize) {
        return stepSize;
    }
}

