/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.scalar;

import java.math.BigDecimal;
import java.math.MathContext;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.type.NumberDefinition;
import org.ojalgo.type.context.NumberContext;

public final class PrimitiveScalar
implements Scalar<Double>,
NumberContext.Enforceable<PrimitiveScalar> {
    public static final Scalar.Factory<Double> FACTORY = new Scalar.Factory<Double>(){

        @Override
        public Double cast(Comparable<?> number) {
            return NumberDefinition.doubleValue(number);
        }

        @Override
        public Double cast(double value) {
            return value;
        }

        public PrimitiveScalar convert(Comparable<?> number) {
            return PrimitiveScalar.valueOf(number);
        }

        public PrimitiveScalar convert(double value) {
            return PrimitiveScalar.of(value);
        }

        public PrimitiveScalar one() {
            return ONE;
        }

        public PrimitiveScalar zero() {
            return ZERO;
        }
    };
    public static final PrimitiveScalar NaN = new PrimitiveScalar(Double.NaN);
    public static final PrimitiveScalar NEG = new PrimitiveScalar(PrimitiveMath.NEG);
    public static final PrimitiveScalar NEGATIVE_INFINITY = new PrimitiveScalar(Double.NEGATIVE_INFINITY);
    public static final PrimitiveScalar ONE = new PrimitiveScalar(PrimitiveMath.ONE);
    public static final PrimitiveScalar POSITIVE_INFINITY = new PrimitiveScalar(Double.POSITIVE_INFINITY);
    public static final PrimitiveScalar TWO = new PrimitiveScalar(PrimitiveMath.TWO);
    public static final PrimitiveScalar ZERO = new PrimitiveScalar(PrimitiveMath.ZERO);
    static final NumberContext CONTEXT = NumberContext.ofMath(MathContext.DECIMAL64);
    private final double myValue;

    public static boolean isAbsolute(double value) {
        return value >= PrimitiveMath.ZERO;
    }

    public static boolean isInfinite(double value) {
        return Double.isInfinite(value);
    }

    public static boolean isNaN(double value) {
        return Double.isNaN(value);
    }

    public static boolean isSmall(double comparedTo, double value) {
        return CONTEXT.isSmall(comparedTo, value);
    }

    public static PrimitiveScalar of(double value) {
        return new PrimitiveScalar(value);
    }

    public static PrimitiveScalar valueOf(Comparable<?> number) {
        return PrimitiveScalar.of(NumberDefinition.doubleValue(number));
    }

    public static PrimitiveScalar valueOf(double value) {
        return PrimitiveScalar.of(value);
    }

    public PrimitiveScalar() {
        this.myValue = PrimitiveMath.ZERO;
    }

    private PrimitiveScalar(double value) {
        this.myValue = value;
    }

    @Override
    public PrimitiveScalar add(double arg) {
        return new PrimitiveScalar(this.myValue + arg);
    }

    @Override
    public PrimitiveScalar add(Double arg) {
        return new PrimitiveScalar(this.myValue + arg);
    }

    @Override
    public PrimitiveScalar add(float scalarAddend) {
        return this.add((double)scalarAddend);
    }

    @Override
    public int compareTo(Double reference) {
        return NumberContext.compare(this.myValue, reference);
    }

    @Override
    public PrimitiveScalar conjugate() {
        return this;
    }

    @Override
    public PrimitiveScalar divide(double arg) {
        return new PrimitiveScalar(this.myValue / arg);
    }

    @Override
    public PrimitiveScalar divide(Double arg) {
        return new PrimitiveScalar(this.myValue / arg);
    }

    @Override
    public PrimitiveScalar divide(float scalarDivisor) {
        return this.divide((double)scalarDivisor);
    }

    @Override
    public double doubleValue() {
        return this.myValue;
    }

    @Override
    public PrimitiveScalar enforce(NumberContext context) {
        return new PrimitiveScalar(context.enforce(this.myValue));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PrimitiveScalar)) {
            return false;
        }
        PrimitiveScalar other = (PrimitiveScalar)obj;
        return Double.doubleToLongBits(this.myValue) == Double.doubleToLongBits(other.myValue);
    }

    @Override
    public float floatValue() {
        return (float)this.myValue;
    }

    @Override
    public Double get() {
        return this.myValue;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.myValue);
        return 31 * result + (int)(temp ^ temp >>> 32);
    }

    @Override
    public int intValue() {
        return (int)this.myValue;
    }

    @Override
    public PrimitiveScalar invert() {
        return new PrimitiveScalar(PrimitiveMath.ONE / this.myValue);
    }

    @Override
    public boolean isAbsolute() {
        return PrimitiveScalar.isAbsolute(this.myValue);
    }

    @Override
    public boolean isSmall(double comparedTo) {
        return PrimitiveScalar.isSmall(comparedTo, this.myValue);
    }

    @Override
    public long longValue() {
        return (long)this.myValue;
    }

    @Override
    public PrimitiveScalar multiply(double arg) {
        return new PrimitiveScalar(this.myValue * arg);
    }

    @Override
    public PrimitiveScalar multiply(Double arg) {
        return new PrimitiveScalar(this.myValue * arg);
    }

    @Override
    public PrimitiveScalar multiply(float scalarMultiplicand) {
        return this.multiply((double)scalarMultiplicand);
    }

    @Override
    public PrimitiveScalar negate() {
        return new PrimitiveScalar(-this.myValue);
    }

    @Override
    public double norm() {
        return PrimitiveMath.ABS.invoke(this.myValue);
    }

    @Override
    public PrimitiveScalar power(int power) {
        double retVal = PrimitiveMath.ONE;
        for (int p = 0; p < power; ++p) {
            retVal *= this.myValue;
        }
        return new PrimitiveScalar(retVal);
    }

    @Override
    public PrimitiveScalar signum() {
        return new PrimitiveScalar(PrimitiveMath.SIGNUM.invoke(this.myValue));
    }

    @Override
    public PrimitiveScalar subtract(double arg) {
        return new PrimitiveScalar(this.myValue - arg);
    }

    @Override
    public PrimitiveScalar subtract(Double arg) {
        return new PrimitiveScalar(this.myValue - arg);
    }

    @Override
    public PrimitiveScalar subtract(float scalarSubtrahend) {
        return this.subtract((double)scalarSubtrahend);
    }

    @Override
    public BigDecimal toBigDecimal() {
        return new BigDecimal(this.myValue, CONTEXT.getMathContext());
    }

    public String toString() {
        return Double.toString(this.myValue);
    }

    @Override
    public String toString(NumberContext context) {
        return context.enforce(this.toBigDecimal()).toString();
    }
}

