/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.scalar;

import java.math.BigDecimal;
import java.math.MathContext;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.function.special.MissingMath;
import org.ojalgo.scalar.BigScalar;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.scalar.SelfDeclaringScalar;
import org.ojalgo.type.TypeUtils;
import org.ojalgo.type.context.NumberContext;

public class Quadruple
implements SelfDeclaringScalar<Quadruple> {
    public static Scalar.Factory<Quadruple> FACTORY = new Scalar.Factory<Quadruple>(){

        @Override
        public Quadruple cast(Comparable<?> number) {
            return Quadruple.valueOf(number);
        }

        @Override
        public Quadruple cast(double value) {
            return Quadruple.valueOf(value);
        }

        public Quadruple convert(Comparable<?> number) {
            return Quadruple.valueOf(number);
        }

        public Quadruple convert(double value) {
            return Quadruple.valueOf(value);
        }

        public Quadruple one() {
            return ONE;
        }

        public Quadruple zero() {
            return ZERO;
        }
    };
    public static final Quadruple MAX_VALUE = new Quadruple(Double.MAX_VALUE, 0.0);
    public static final Quadruple MIN_VALUE = new Quadruple(-9.223372036854776E18, 0.0);
    public static final Quadruple NaN = new Quadruple(Double.NaN, Double.NaN);
    public static final Quadruple NEG = new Quadruple(-1.0, 0.0);
    public static final Quadruple NEGATIVE_INFINITY = new Quadruple(Double.NEGATIVE_INFINITY, 0.0);
    public static final Quadruple ONE = new Quadruple(1.0, 0.0);
    public static final Quadruple POSITIVE_INFINITY = new Quadruple(Double.POSITIVE_INFINITY, 0.0);
    public static final Quadruple TWO = new Quadruple(2.0, 0.0);
    public static final Quadruple ZERO = new Quadruple(0.0, 0.0);
    private static final double SPLIT = 1.34217729E8;
    static final MathContext MATH_CONTEXT = MathContext.DECIMAL128;
    static final NumberContext NUMBER_CONTEXT = NumberContext.ofMath(MATH_CONTEXT);
    private final double myBase;
    private transient BigDecimal myDecimal = null;
    private final double myRemainder;

    public static boolean isAbsolute(Quadruple value) {
        return value.isAbsolute();
    }

    public static boolean isInfinite(Quadruple value) {
        return Double.isInfinite(value.getBase()) || Double.isInfinite(value.getRemainder());
    }

    public static boolean isNaN(Quadruple value) {
        return Double.isNaN(value.getBase()) || Double.isNaN(value.getRemainder());
    }

    public static boolean isSmall(double comparedTo, Quadruple value) {
        return value.isSmall(comparedTo);
    }

    public static Quadruple parse(CharSequence plainNumberString) {
        BigDecimal decimal = new BigDecimal(plainNumberString.toString());
        return Quadruple.valueOf(decimal);
    }

    public static Quadruple valueOf(BigDecimal number) {
        double base = number.doubleValue();
        BigDecimal mag = new BigDecimal(base);
        BigDecimal rem = number.subtract(mag);
        double remainder = rem.doubleValue();
        return new Quadruple(base, remainder);
    }

    public static Quadruple valueOf(Comparable<?> number) {
        if (number == null) {
            return ZERO;
        }
        if (number instanceof Quadruple) {
            return (Quadruple)number;
        }
        BigDecimal tmpBigD = TypeUtils.toBigDecimal(number);
        return Quadruple.valueOf(tmpBigD);
    }

    public static Quadruple valueOf(double value) {
        return new Quadruple(value);
    }

    private static Quadruple add(double base1, double remainder1, double base2, double remainder2) {
        double t1 = base1 + base2;
        double e = t1 - base1;
        double t2 = base2 - e + (base1 - (t1 - e)) + remainder1 + remainder2;
        double base = t1 + t2;
        double remainder = t2 - (base - t1);
        return new Quadruple(base, remainder);
    }

    private static Quadruple divide(Quadruple arg1, Quadruple arg2) {
        BigDecimal decimal1 = arg1.toBigDecimal();
        BigDecimal decimal2 = arg2.toBigDecimal();
        BigDecimal quotient = MissingMath.divide(decimal1, decimal2);
        return Quadruple.valueOf(quotient);
    }

    private static Quadruple multiply(double base1, double remainder1, double base2, double remainder2) {
        double cona = base1 * 1.34217729E8;
        double conb = base2 * 1.34217729E8;
        double a1 = cona - (cona - base1);
        double b1 = conb - (conb - base2);
        double a2 = base1 - a1;
        double b2 = base2 - b1;
        double c11 = base1 * base2;
        double c21 = a2 * b2 + (a2 * b1 + (a1 * b2 + (a1 * b1 - c11)));
        double c2 = base1 * remainder2 + remainder1 * base2;
        double t1 = c11 + c2;
        double e = t1 - c11;
        double t2 = remainder1 * remainder2 + (c2 - e + (c11 - (t1 - e))) + c21;
        double base = t1 + t2;
        double remainder = t2 - (base - t1);
        return new Quadruple(base, remainder);
    }

    public Quadruple() {
        this(0.0, 0.0);
    }

    private Quadruple(double base) {
        this(base, 0.0);
    }

    private Quadruple(double base, double remainder) {
        this.myBase = base;
        this.myRemainder = remainder;
    }

    @Override
    public Quadruple add(double arg) {
        return new Quadruple(this.myBase + arg, this.myRemainder);
    }

    @Override
    public Quadruple add(Quadruple arg) {
        if (Quadruple.isNaN(this) || Quadruple.isNaN(arg)) {
            return NaN;
        }
        if (Quadruple.isInfinite(this)) {
            if (!Quadruple.isInfinite(arg) || this.sign() == arg.sign()) {
                return this;
            }
            return NaN;
        }
        double base1 = this.getBase();
        double remainder1 = this.getRemainder();
        double base2 = arg.getBase();
        double remainder2 = arg.getRemainder();
        return Quadruple.add(base1, remainder1, base2, remainder2);
    }

    @Override
    public int compareTo(Quadruple reference) {
        return Double.compare(this.doubleValue(), reference.doubleValue());
    }

    @Override
    public Quadruple conjugate() {
        return this;
    }

    @Override
    public Quadruple divide(double arg) {
        return this.divide(Quadruple.valueOf(arg));
    }

    @Override
    public Quadruple divide(Quadruple arg) {
        if (Quadruple.isNaN(this) || Quadruple.isNaN(arg)) {
            return NaN;
        }
        return Quadruple.divide(this, arg);
    }

    @Override
    public double doubleValue() {
        return this.myBase + this.myRemainder;
    }

    @Override
    public Quadruple enforce(NumberContext context) {
        return Quadruple.valueOf(this.toBigDecimal(context.getMathContext()));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Quadruple)) {
            return false;
        }
        Quadruple other = (Quadruple)obj;
        return Double.doubleToLongBits(this.myBase) == Double.doubleToLongBits(other.myBase) && Double.doubleToLongBits(this.myRemainder) == Double.doubleToLongBits(other.myRemainder);
    }

    @Override
    public float floatValue() {
        return this.toBigDecimal().floatValue();
    }

    @Override
    public Quadruple get() {
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.myBase);
        result = prime * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.myRemainder);
        return prime * result + (int)(temp ^ temp >>> 32);
    }

    @Override
    public int intValue() {
        return this.toBigDecimal().intValue();
    }

    @Override
    public Quadruple invert() {
        return ONE.divide(this);
    }

    @Override
    public boolean isAbsolute() {
        return this.myBase >= 0.0;
    }

    @Override
    public boolean isSmall(double comparedTo) {
        return BigScalar.CONTEXT.isSmall(comparedTo, this.doubleValue());
    }

    @Override
    public long longValue() {
        return Math.round(this.myBase + this.myRemainder);
    }

    @Override
    public Quadruple multiply(double arg) {
        return Quadruple.multiply(this.myBase, this.myRemainder, arg, 0.0);
    }

    @Override
    public Quadruple multiply(Quadruple arg) {
        if (Quadruple.isNaN(this) || Quadruple.isNaN(arg)) {
            return NaN;
        }
        if (Quadruple.isInfinite(this)) {
            return arg.sign() > 0 ? this : this.negate();
        }
        double base1 = this.getBase();
        double remainder1 = this.getRemainder();
        double base2 = arg.getBase();
        double remainder2 = arg.getRemainder();
        return Quadruple.multiply(base1, remainder1, base2, remainder2);
    }

    @Override
    public Quadruple negate() {
        return new Quadruple(-this.myBase, -this.myRemainder);
    }

    @Override
    public double norm() {
        return Math.abs(this.doubleValue());
    }

    @Override
    public Quadruple power(int power) {
        Quadruple retVal = ONE;
        for (int p = 0; p < power; ++p) {
            retVal = retVal.multiply(this);
        }
        return retVal;
    }

    @Override
    public Quadruple signum() {
        if (!Quadruple.isInfinite(this) && Quadruple.isSmall(PrimitiveMath.ONE, this)) {
            return ZERO;
        }
        if (this.sign() == -1) {
            return NEG;
        }
        return ONE;
    }

    @Override
    public Quadruple subtract(double arg) {
        return new Quadruple(this.myBase - arg, this.myRemainder);
    }

    @Override
    public Quadruple subtract(Quadruple arg) {
        if (Quadruple.isNaN(this) || Quadruple.isNaN(arg)) {
            return NaN;
        }
        if (Quadruple.isInfinite(this)) {
            if (!Quadruple.isInfinite(arg) || this.sign() != arg.sign()) {
                return this;
            }
            return NaN;
        }
        double base1 = this.getBase();
        double remainder1 = this.getRemainder();
        double base2 = -arg.getBase();
        double remainder2 = -arg.getRemainder();
        return Quadruple.add(base1, remainder1, base2, remainder2);
    }

    @Override
    public BigDecimal toBigDecimal() {
        if (this.myDecimal == null) {
            this.myDecimal = this.toBigDecimal(MATH_CONTEXT);
        }
        return this.myDecimal;
    }

    public String toString() {
        return "Quadruple [" + this.myBase + " + " + this.myRemainder + "]";
    }

    @Override
    public String toString(NumberContext context) {
        return context.enforce(this.toBigDecimal()).toString();
    }

    private int sign() {
        return Double.compare(this.doubleValue(), 0.0);
    }

    private BigDecimal toBigDecimal(MathContext context) {
        return new BigDecimal(this.myBase).add(new BigDecimal(this.myRemainder), context);
    }

    double getBase() {
        return this.myBase;
    }

    double getRemainder() {
        return this.myRemainder;
    }
}

